<?php // $file = /home/allisonr/public_html/templates/yootheme/vendor/yootheme/builder/elements/html/element.json

return [
  '@import' => $filter->apply('path', './element.php', $file), 
  'name' => 'html', 
  'title' => 'Html', 
  'icon' => $filter->apply('url', 'images/icon.svg', $file), 
  'group' => 'basic', 
  'iconSmall' => $filter->apply('url', 'images/iconSmall.svg', $file), 
  'element' => true, 
  'width' => 500, 
  'placeholder' => [
    'props' => [
      'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.'
    ]
  ], 
  'templates' => [
    'render' => $filter->apply('path', './templates/template.php', $file), 
    'content' => $filter->apply('path', './templates/content.php', $file)
  ], 
  'fields' => [
    'content' => [
      'label' => 'Content', 
      'type' => 'editor', 
      'editor' => 'code', 
      'mode' => 'text/html', 
      'source' => true
    ], 
    'name' => $config->get('builder.name'), 
    'source' => $config->get('builder.source'), 
    'id' => $config->get('builder.id'), 
    'status' => $config->get('builder.status'), 
    'class' => $config->get('builder.cls'), 
    'attributes' => $config->get('builder.attrs'), 
    'css' => [
      'type' => 'editor', 
      'label' => 'CSS', 
      'description' => 'Enter your own custom CSS. The following selectors will be prefixed automatically for this element: <code>.el-element</code>', 
      'editor' => 'code', 
      'mode' => 'css', 
      'attrs' => [
        'debounce' => 500
      ]
    ]
  ], 
  'fieldset' => [
    'default' => [
      'type' => 'tabs', 
      'fields' => [[
          'title' => 'Content', 
          'fields' => ['content']
        ], $config->get('builder.advanced')]
    ]
  ]
];
