<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined ( 'JPATH_PLATFORM' ) or die ();

$app = JFactory::getApplication ();

jimport ( 'joomla.filesystem.file' );

// allow an override here
$template_override = dirname ( __FILE__ ) . '/override.php';
if (JFile::exists ( $template_override )) {
	include $template_override;
}
$document = JFactory::getDocument ();

?>
<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta name="robots" content="noindex, nofollow">
<link rel="stylesheet" href="<?php echo JUri::root(true); ?>/components/com_marketingrocket/assets/css/bootstrap.min.css" type="text/css" />
</head>
<body>
    <div style="position: absolute;width: 100%;top : 50%;margin-top: -10em">
        <div style="width: 600px;margin: 0px auto 0px;text-align: center">
    <?php if (($this->error->getCode()) == '404'): ?>
        
            
            <?php 
                $pk = JFactory::getApplication()->getUserState('marketing_rocket_template.alias');
                if(empty($pk)){ // root called ?>
                    <h1><?php echo JText::_('TPL_MORKETINGROCKET_WHOOPS_NOTHING_HERE') ?></h1>
                    <h4 style="font-weight: normal"><?php echo "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]" ?></h4>
                    <p style="font-size: 1.2em;color: #7C7C7C">
                        <?php echo JText::_('TPL_MORKETINGROCKET_WHOOPS_DESC') ?>
                    </p>
                    <br />
                    <p style="font-size: 1.2em;color: #7C7C7C">
                        <?php echo JText::_('TPL_MORKETINGROCKET_WHOOPS_DESC_2') ?>
                    </p>
                <?php }
                else { // not found landing happend ?>
                    <h1><?php echo JText::_('TPL_MORKETINGROCKET_404_PAGE_NOT_FOUND') ?></h1>
                    <h4 style="font-weight: normal"><?php echo "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]" ?></h4>
                    <p style="font-size: 1.2em;color: #7C7C7C">
                        <?php echo JText::_('TPL_MORKETINGROCKET_404_DESC') ?>
                    </p>
                <?php } ?>

            <?php else : ?>
                <span class="label label-inverse"><?php echo $this->error->getCode(); ?></span> <?php echo htmlspecialchars($this->error->getMessage(), ENT_QUOTES, 'UTF-8');?>
            <?php endif ?>
            <br /> 
            <br /> 
            <p style="font-size: 1.2em;color: #7C7C7C">
                Powered by:
            </p>
            <a href="https://marketing-rocket.com">
                <img src="<?php echo JUri::root(true) ?>/media/com_marketingrocket/logo-transparent.png" />
            </a>
        </div>
    </div>
    <?php if ($this->debug) : ?>
            <?php echo $this->renderBacktrace(); ?>
    <?php endif; ?>
    <?php echo $document->getBuffer('modules', 'debug', array('style' => 'none')); ?>
</body>
</html>