<?php

/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */


class handler
{
    public static $formName = 'Virtumart Customer';
    public static $api = null;

    public static function handleOrderChange($data, $old_order_status){


        if(empty(self::$api)){
            require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'models'.DS.'api.php';
            $api = MarketingrocketModelApi::getApiByType('virtuemart');
            self::$api = $api;
        }
        else
            $api = self::$api;

        if(empty($api))
            return;



        $leadExist = true;
        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_marketingrocket'.DS.'tables');

        $user = JFactory::getUser($data->virtuemart_user_id);
        if(empty($user))
            return false;

        $lead = JTable::getInstance('Lead', 'MarketingrocketTable');
        $lead->load(array('email' => $user->email));

        if(empty($lead->id)){
            $leadExist = false;
            $lead = MarketingrocketTableLead::createLead($user->email, $user->name, '', 1, self::$formName, $user->id);

        }
        if(!$lead instanceof MarketingrocketTableLead)
            return;

        // if new status selected by admin

        if(!in_array($data->order_status, $api->tags->order_status))
            return;

        if($leadExist && !empty($old_order_status) && in_array($old_order_status, $api->tags->order_status)){
            $key = array_search($old_order_status, $api->tags->order_status);
            $tagId = $api->tags->tag_id[$key];

            $leadTag = $lead->hasTag($tagId);
            if($leadTag){
                $leadTag->delete();
            }

        }
        $newKey = array_search($data->order_status, $api->tags->order_status);
        $newTagId = $api->tags->tag_id[$newKey];
        $lead->addTag($newTagId);

        if(!empty($api->new_tag)){
            $db = JFactory::getDbo();
            $q = $db->getQuery(true)
                ->select('*')
                ->from($db->qn('#__virtuemart_order_items', 'a'))
                ->where($db->qn('virtuemart_order_id').' = '.$db->q($data->virtuemart_order_id));
            $db->setQuery($q);
            $products = $db->loadObjectList();

            foreach ($products as $product){
                $tagName = trim($api->new_tag);
                $tagName = str_ireplace('%product_name%', $product->order_item_name, $tagName);

                $tagTable = JTable::getInstance('Tag', 'MarketingrocketTable');
                $tagTable->load(array('title' => $tagName));

                if(empty($tagTable->id)){
                    $tagTable->title = $tagName;
                    $tagTable->published = 1;
                    $tagTable->store();
                }
                $lead->addTag($tagTable->id);
            }

        }

    }
}