<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
use Joomla\Registry\Registry;
class PlgUserMarketingrocketuser extends JPlugin
{

    private static $oldGroups;
    private static $newGroups;
    private static $forceCreateLead = false;
    
    protected $autoloadLanguage = true;
     
    public function onBeforeFormLoad(&$type){
        if($type == 'user')
            JForm::addFormPath(JPATH_PLUGINS.'/user/marketingrocketuser/form');
         
    }
    
    public function onApiLoadFormData(&$type, &$data){
        if($type == 'user'){
            if(!empty($data['id'])){
                $data['import_existing'] = 0;
            }
        }
    }
    
    public function onApiFormValidate(&$ret, $form, &$data){
        if($data['type'] == 'user'){
            if(empty($data['id'])){
                $db = JFactory::getDbo();
                
                $q = $db->getQuery(true);
                
                $q->select('id')->from('#__mrocket_api')->where('type = "user"');
                $db->setQuery($q);
                
                $res = $db->loadResult();
                
                if(!empty($res)){
                    JFactory::getApplication()->enqueueMessage(JText::_('COM_MARKETINGROCKETUSER_ONLY_ONE_CAN_BE_USED'), 'error');
                    $ret = false;
                }
            }
        }
    }
    
    public function afterApiSaveForm(&$type, $data, $oldDate, $id){
        if($type == 'user'){
            if($data['import_existing'] == 1){
                $db = JFactory::getDbo();
                $q = $db->getQuery(true);
                
                $q->select('*')->from('#__users')->where('block = 0');
                $db->setQuery($q);
                
                $list = $db->loadObjectList();
                $count = 0;
                foreach ($list as $user){
                    $ret = $this->_saveNewLead($user, $data);
                    if($ret)
                      $count++;  
                }
                
                JFactory::getApplication()->enqueueMessage(JText::plural('PLG_USER_MARKETINGROCKETUSER_N_LEAD_IMPORTED', $count), 'notice');
            }
        }
    }
    
    private function _saveNewLead($user, $data){
        
        
        JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');

        JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_marketingrocket/models');
        
        $landingModel = JModelLegacy::getInstance('landing', 'MarketingrocketModel', array('ignore_request' => true));
        
        $leadTable = JTable::getInstance('Lead', 'MarketingrocketTable');
                    
        $leadTable->load(array('email' => $user->email));

        if(!empty($leadTable->id)){
            return false;
        }

        $leadTable->first_name = $user->name;
        $leadTable->email = $user->email;
        $leadTable->user_id = $user->id;
        $leadTable->published = 1;
        $leadTable->store();
        
        $leadTable->addRefCode();
        
        $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
        $leadDetailsTable->landing_id = 0;
        $leadDetailsTable->lead_id = $leadTable->id;
        $leadDetailsTable->field_name = 'MR_form_name';
        $leadDetailsTable->value = 'Joomla User';
        $leadDetailsTable->store();

        $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
        $leadDetailsTable->landing_id = 0;
        $leadDetailsTable->lead_id = $leadTable->id;
        $leadDetailsTable->field_name = 'MR_submited_date';
        $leadDetailsTable->value = JFactory::getDate()->toSql();
        $leadDetailsTable->store();




        if(!empty($data['adding_tag'])){
            foreach ($data['adding_tag'] as $tagId){
                $leadTable->addTag($tagId);
            }
        }



        if(!empty($data['add_responder_sequence'])){
            foreach ($data['add_responder_sequence'] as $sequenceId){
                $item = new stdClass();
                $item->responder_type = 'default';
                $item->responder_sequence_id = $sequenceId;
                $landingModel->_addResponderToLead($leadTable->id, '', $item);
            }
        }

        if(!empty($data['subscrib_campaign'])){
            $landingModel->_addLeadToCampaign($leadTable->id, $data['subscrib_campaign']);
        }
        return true;
    }
    
    public function onUserAfterSave($user, $isNew, $successs, $msg){

        if($successs == true && $user['block'] == 0){


            $registry = new Registry;
                
            $registry->loadArray($user);
            $user = $registry->toObject();
            $db = JFactory::getDbo();

            $q = $db->getQuery(true);

            $q->select('params')->from('#__mrocket_api')->where('type = "user"');
            $db->setQuery($q);

            $params = $db->loadResult();
            if(!empty($params)){
                $registry = new Registry;
                $registry->loadString($params);
                $data = $registry->toArray();




            }


            if($isNew == true || self::$forceCreateLead){
                if(!empty($data))
                    $this->_saveNewLead($user, $data);
            }
            else {



                JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');
                
                $leadTable = JTable::getInstance('Lead', 'MarketingrocketTable');
                    
                $leadTable->load(array('user_id' => $user->id));
                
                if(empty($leadTable->id))
                {
                    return;
                }
                
                $leadTable->first_name = $user->name;
                $leadTable->email = $user->email;
                
                $leadTable->store();

                $lang = JFactory::getLanguage();
                $extension = 'com_marketingrocket';
                $base_dir = JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket';
                $language_tag = JFactory::getApplication()->getLanguage()->getTag();
                $reload = true;
                $lang->load($extension, $base_dir, $language_tag, $reload);

                if(!empty($data['removing_tag_on_group_remove'])){

                    $groupTable = JTable::getInstance('Usergroup', 'JTable');

                    foreach (self::$oldGroups as $oldGroup){
                        if(!in_array($oldGroup, self::$newGroups)){ // removed group

                            $groupTable->load($oldGroup);

                            $tagName = trim($data['removing_tag_on_group_remove']);
                            $tagName = str_replace('%group_name%', $groupTable->title, $tagName);

                            $tagTable = JTable::getInstance('Tag', 'MarketingrocketTable');
                            $tagTable->load(array('title' => $tagName));

                            if(empty($tagTable->id)){
                                continue;
                            }

                            $leadTagTable = JTable::getInstance('Leadtag','MarketingrocketTable');

                            $leadTagTable->load(array('lead_id' => $leadTable->id, 'tag_id' => $tagTable->id));
                            if(!empty($leadTagTable->id))
                                $leadTagTable->delete();
                        }
                    }
                }

                if(!empty($data['adding_tag_on_group_add'])){

                    $groupTable = JTable::getInstance('Usergroup', 'JTable');

                    foreach (self::$newGroups as $newGroup){
                        if(!in_array($newGroup, self::$oldGroups)){ // removed group
                            $groupTable->load($newGroup);

                            $tagName = trim($data['adding_tag_on_group_add']);
                            $tagName = str_replace('%group_name%', $groupTable->title, $tagName);

                            $tagTable = JTable::getInstance('Tag', 'MarketingrocketTable');
                            $tagTable->load(array('title' => $tagName));

                            if(empty($tagTable->id)){
                                $tagTable->title = $tagName;
                                $tagTable->published = 1;
                                $tagTable->store();
                            }

                            $leadTable->addTag($tagTable->id);
                        }
                    }
                }

            }
        }
    }
    public function onUserBeforeSave($oldProperties, $isNew, $newProperties){
        if($isNew)
            return;


        self::$oldGroups = $oldProperties['groups'];
        self::$newGroups = $newProperties['groups'];

        if($oldProperties['block'] == 1 && $newProperties['block'] == 0){ // User Activated
            self::$forceCreateLead = true;
        }


    }
    public function onViewForm(&$type, &$buttons){
        if($type == 'user'){
            $buttons = array(
                'jform[adding_tag][]' => array(
                    'type' => 'tag',
                ),
                'jform[add_responder_sequence][]' => array(
                    'type' => 'sequence'
                ),
                'jform[subscrib_campaign]' => array(
                    'type' => 'campaign'
                )
            );
        }
    }

    public function onCPayUserStateChange(){
        die('o');
    }
}
