<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgSystemMarketingrocket extends JPlugin
{
    public function onAfterRoute(){
        $app = JFactory::getApplication();
        if(!$app->isAdmin()){
            if($app->input->get('option') == 'com_marketingrocket' && ($app->input->get('view') == 'preview' || $app->input->get('view') == 'landing')){
                $app->input->set('template', 'marketingrocket');
            }
        }
        
    }
    public function onAfterInitialise() {

                $app = JFactory::getApplication();
                if($app->isAdmin()){
                    if($app->input->get('option') == 'com_categories' && $app->input->get('extension') == 'com_marketingrocket'){
                        $document  = JFactory::getDocument();
                        if($app->input->get('layout', '') != 'edit')
                            $document->addCustomTag('<link rel="stylesheet" href="' . JURI::root(true) . '/components/com_marketingrocket/assets/css/bootstrap.min.css" type="text/css" />');
                        $document->addCustomTag('<link rel="stylesheet" href="' . JURI::base() . '/components/com_marketingrocket/assets/css/style.css" type="text/css" />');
                        $document->addStyleSheet (JURI::base() . 'components/com_marketingrocket/assets/css/dashboard.css' ); 
                        
                        JFactory::getDocument()->addScriptDeclaration('jQuery(document).ready(function($){$("#jform_tags").parents(".control-group:first").hide()})');
                        
                        $this->videoHelp = array('img' => 'components/com_marketingrocket/assets/images/videos/campaigns.png', 'videoId' => 'wKJp7H5WIyw?rel=0', 'text' => 'Campaigns & Campaign Categories');
                        
                        $lang = JFactory::getLanguage();
                        $extension = 'com_marketingrocket';
                        $base_dir = JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket';
                        $language_tag = JFactory::getApplication()->getLanguage()->getTag();
                        $reload = true;
                        $lang->load($extension, $base_dir, $language_tag, $reload); 
                
                        $html = '<div><br />
                        <p class="center bold"><a onclick="showmodal()" style="cursor: pointer;color:#fff;">
                                <img src="'.$this->videoHelp['img'] .'" alt="'.$this->videoHelp['text'] .'" />
                        </a></p>
                        <p style="text-align:center;">'.JText::_('COM_MARKETINGROCKET_CLICK_HERE_FOR_MORE_SUPPORT').'</p>';
                        
                        ob_start();
                        
                       

			// Include the requested template filename in the local scope
			// (this will execute the view logic).
			include JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'views'.DIRECTORY_SEPARATOR.'_common'.DIRECTORY_SEPARATOR.'default_video_modal.php';

			// Done with the requested template; get the buffer and
			// clear it.
			$html .= ob_get_contents();
			ob_end_clean();
			    $html .= '</div>';
                        
                        $dom = new DOMDocument();
                        @$dom->loadHTML($html);
                        
                        $scriptNode = $dom->getElementsByTagName('script')->item(0);
                        $scriptText = $scriptNode->nodeValue;

                        $scripts = $dom->getElementsByTagName('script');
                        foreach ($scripts as $script) {
                            $script->parentNode->removeChild($script);

                        }


                        $firstDiv = $dom->getElementsByTagName('div')->item(0);
                        $html =  trim(preg_replace('/\s+/', ' ', $dom->saveHTML($firstDiv)));
                        
                        
                        
                        JFactory::getDocument()->addScriptDeclaration('jQuery(document).ready(function($){'
                                . '$("#j-sidebar-container").append(\''.JText::_($html,true).'\')'
                                . '});'.$scriptText);
                        
                        
                    }
                     else if($app->input->get('option') == 'com_modules' && $app->input->get('view') == 'module'){
                         $db = JFactory::getDbo();
                         $query = $db->getQuery(true);
                         $addJs = false;
                         if($app->input->getInt('id', 0) > 0){
                             $id = $app->input->getInt('id', 0);
                             $query->select('*')->from('#__modules')->where('id = '.$id);
                             $db->setQuery($query);
                             $res = $db->loadObject();
                              if(!empty($res) && $res->module == 'mod_marketingrocketfront' && $res->client_id == 0){
                                    $addJs = true;
                                }
                         }
                         else {
                            $extensionId = $app->getUserState('com_modules.add.module.extension_id', 0);
                            if(!empty($extensionId)){
                                 $query->select('*')->from('#__extensions')->where('extension_id = '.$extensionId);
                                 $db->setQuery($query);
                                 $res = $db->loadObject();
                                 if(!empty($res) && $res->element == 'mod_marketingrocketfront' && $res->client_id == 0){
                                     $addJs = true;
                                 }
                            }
                         }
                         if($addJs){
                            JHtml::_('jquery.framework');
                            $document  = JFactory::getDocument();
                            $document->addScript(JURI::root().'modules/mod_marketingrocketfront/js/js.js');
                         }
                    }
                    else if($app->input->get('option') == 'com_templates' && $app->input->get('view') == 'style'){
                         $db = JFactory::getDbo();
                         $query = $db->getQuery(true);
                        $id = $app->input->getInt('id', 0);
                        $query->select('template')->from('#__template_styles')->where('id = '.$id);
                        $db->setQuery($query);
                        $res = $db->loadResult();
                        
                        if($res == 'marketingrocket'){
                            $document = JFactory::getDocument ();
                            
                            $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/lib/codemirror.js' , "text/javascript" , true );
                
                            $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/mode/xml/xml.js' , "text/javascript" , true );
                            $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/mode/htmlmixed/htmlmixed.js' , "text/javascript" , true );

                            $document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/lib/codemirror.css' );
                            $document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/theme/elegant.css' );
                            
                            $document->addCustomTag('<script>jQuery(document).ready(function($){
  	$(\'a[href="#attrib-advanced"]\').click(function(){
  		if(window.HeadCodeEditor == undefined){
  			setTimeout(function(){
  				HeadCodeEditor = CodeMirror.fromTextArea($(\'#jform_params_header_code\')[0]
  					, {
  						lineNumbers: true,
                        mode:  "htmlmixed"
  					});
                                        
                                var BodyCodeEditor = CodeMirror.fromTextArea($(\'#jform_params_footer_code\')[0]
  					, {
  						lineNumbers: true,
                        mode:  "htmlmixed"
  					});
  			},500)
        };
  });
  setTimeout(function(){
    if($(\'#jform_params_header_code\').is(":visible")){

          $(\'a[href="#attrib-advanced"]\').click();
    }
   },500);
  });</script>');
                        }
                    }
                }
                else {
                    
                    if($app->input->get('option') == 'com_marketingrocket' && ($app->input->get('view') == 'preview' || $app->input->get('view') == 'landing')){
                        $app->input->set('template', 'marketingrocket');
                    }
                   
                }
                
                
		
    }
    public function onInstallerBeforeInstaller($model, &$package){
        if($package['type'] == 'package'){
            $xml = JFolder::files($package['extractdir'], '.xml$', false, true);
            $path = pathinfo($xml[0]);
            if($path['basename'] == 'pkg_marketingrocket.xml'){
                $dom = new DOMDocument();
                $dom->load($package['extractdir'].DIRECTORY_SEPARATOR.'pkg_marketingrocket.xml');

                $childs = $dom->getElementsByTagName('file');
                foreach ($childs as $child){
                    $id =  $child->getAttribute('id');
                    $client = false;

                    $file = $package['extractdir'].DIRECTORY_SEPARATOR.'packages'.DIRECTORY_SEPARATOR.$child->nodeValue;

                    if($child->hasAttribute('client'))
                        $client = $child->getAttribute('client');

                    switch ($child->getAttribute('type')){
                        case 'template' :
                            $target = JPATH_SITE.DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.$id;
                            if(!file_exists($target)){
                                $this->extract($file, $target);
                            }
                            break;
                        case 'plugin' : 
                            $group = $child->getAttribute('group');
                            $target = JPATH_SITE.DIRECTORY_SEPARATOR.'plugins'.DIRECTORY_SEPARATOR.$group.DIRECTORY_SEPARATOR.$id;
                            if(!file_exists($target)){
                                $this->extract($file, $target);
                            }
                            break;
                        case 'module' :
                            if($client == 'site')
                                $target = JPATH_SITE.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.$id;
                            else 
                                $target = JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.$id;
                            if(!file_exists($target)){
                                $this->extract($file, $target);
                            }
                            break;
                    }
                }
            }
            
        }
        
    }
    private function extract($file, $target){
        
        $package = JInstallerHelper::unpack($file, true);
        
        $xml = JFolder::files($package['extractdir'], '.xml$', false, true);
        mkdir($target);
        
        $path = pathinfo($xml[0]);
        
        rename($xml[0], $target.DIRECTORY_SEPARATOR.$path['basename']);
    }
}
