<?php

/**

 * @package        Joomla

 * @subpackage     Membership Pro

 * @author         Tuan Pham Ngoc

 * @copyright      Copyright (C) 2012 - 2016 Ossolution Team

 * @license        GNU/GPL, see LICENSE.php

 */
defined('_JEXEC') or die;
use Joomla\Registry\Registry;


class plgOSMembershipMarketingrocket extends JPlugin
{
	private $canRun = true;

	public function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);
		if (!JComponentHelper::isInstalled('com_marketingrocket') || !JComponentHelper::getComponent('com_marketingrocket', true)->enabled
            || !JComponentHelper::isInstalled('com_osmembership') || !JComponentHelper::getComponent('com_osmembership', true)->enabled
        )
			$this->canRun = false;

	}

    private function checkApiExist(){
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('a.id')->from('#__mrocket_api AS a')->innerJoin('#__mrocket_api_types AS b ON a.type = b.type')
            ->where('a.type = '.$db->q('osmembership'))
        ;

        $db->setQuery($query);
        $res = $db->loadResult();

        return $res;
    }

    public function onBeforeFormLoad(&$type){

        if($type == 'osmembership'){

            JForm::addFormPath(JPATH_PLUGINS.'/osmembership/marketingrocket/form');
            $lang = JFactory::getLanguage();
            $lang->load('plg_osmembership_marketingrocket', JPATH_PLUGINS.DS.'osmembership'.DS.'marketingrocket');

            if($this->canRun == false){
                JFactory::getApplication()->enqueueMessage(JText::_('PLG_OSMEMBERSHIP_MARKETINGROCKET_COMPONENT_IS_NOT_AVAILABE'), 'error');
                JFactory::getApplication()->redirect('index.php?option=com_marketingrocket&view=apilist');
            }
            $id = JFactory::getApplication()->input->getInt('id',0);
            if(empty($id)){
                $res = $this->checkApiExist();
                if(!empty($res)){
                    JFactory::getApplication()->enqueueMessage(JText::_('COM_MARKETINGROCKET_ONLY_ONE_CAN_BE_USED'), 'error');
                }
            }
        }

    }

    public function onMembershipActive($row)

    {

        if (!$this->canRun) {

            return;

        }

        $lang = JFactory::getLanguage();

        $langCode = JFactory::getApplication()->getLanguage()->getLocale();
        $langCode = $langCode[2];

        $lang->load('com_marketingrocket', JPATH_ADMINISTRATOR.'/components/com_marketingrocket', $langCode);


        $db = JFactory::getDbo();

        $q = $db->getQuery(true);

        $q->select('params')->from('#__mrocket_api')->where('type = "osmembership"');

        $db->setQuery($q);

        $params = $db->loadResult();

        $registry = new Registry;
        $registry->loadString($params);
        $apiData = $registry->toArray();

        $plan = JTable::getInstance('Osmembership', 'Plan');

        $plan->load($row->plan_id);

        $email = $row->email;

        JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_marketingrocket/tables');

        $leadTable = JTable::getInstance('Lead', 'MarketingrocketTable');

        $leadTable->load(array('email' => $email, 'is_temp' => 0));

        if(empty($leadTable->id)){
            $leadTable->email = $email;
            $leadTable->first_name = $row->first_name;
            $leadTable->last_name = $row->last_name;

            $leadTable->published = 1;
            $leadTable->is_temp = 0;
            $leadTable->store();


            $leadTable->addRefCode();

            $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
            $leadDetailsTable->landing_id = 0;
            $leadDetailsTable->lead_id = $leadTable->id;
            $leadDetailsTable->field_name = 'MR_form_name';
            $leadDetailsTable->value = 'Membership Pro Subscriber';
            $leadDetailsTable->store();

            $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
            $leadDetailsTable->landing_id = 0;
            $leadDetailsTable->lead_id = $leadTable->id;
            $leadDetailsTable->field_name = 'MR_submited_date';
            $leadDetailsTable->value = JFactory::getDate()->toSql();
            $leadDetailsTable->store();
        }

        foreach ($apiData['new_predefined_tags'] as $tagId){
            $leadTable->addTag($tagId);
        }

        if(!empty($apiData['new_tag'])){
            $tagName = trim($apiData['new_tag']);
            $tagName = str_replace('{%plan_name%}', $plan->title, $tagName);

            $tagTable = JTable::getInstance('Tag', 'MarketingrocketTable');
            $tagTable->load(array('title' => $tagName));

            if(empty($tagTable->id)){
                $tagTable->title = $tagName;
                $tagTable->published = 1;
                $tagTable->store();
            }

            $leadTable->addTag($tagTable->id);
        }


    }
    public function onMembershipExpire($row)
    {
        if (!$this->canRun) {

            return;

        }

        $lang = JFactory::getLanguage();

        $langCode = JFactory::getApplication()->getLanguage()->getLocale();
        $langCode = $langCode[2];

        $lang->load('com_marketingrocket', JPATH_ADMINISTRATOR.'/components/com_marketingrocket', $langCode);


        $db = JFactory::getDbo();

        $q = $db->getQuery(true);

        $q->select('params')->from('#__mrocket_api')->where('type = "osmembership"');

        $db->setQuery($q);

        $params = $db->loadResult();

        $registry = new Registry;
        $registry->loadString($params);
        $apiData = $registry->toArray();

        $plan = JTable::getInstance('Osmembership', 'Plan');

        $plan->load($row->plan_id);

        $email = $row->email;

        JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_marketingrocket/tables');

        $leadTable = JTable::getInstance('Lead', 'MarketingrocketTable');

        $leadTable->load(array('email' => $email, 'is_temp' => 0));
        if(empty($leadTable->id))
            return;

        foreach ($apiData['expire_predefined_tags'] as $tagId){
            $leadTable->addTag($tagId);
        }

        if(!empty($apiData['expire_tag'])){
            $tagName = trim($apiData['expire_tag']);
            $tagName = str_replace('{%plan_name%}', $plan->title, $tagName);

            $tagTable = JTable::getInstance('Tag', 'MarketingrocketTable');
            $tagTable->load(array('title' => $tagName));

            if(empty($tagTable->id)){
                $tagTable->title = $tagName;
                $tagTable->published = 1;
                $tagTable->store();
            }

            $leadTable->addTag($tagTable->id);
        }

        foreach ($apiData['expire_remove_tags'] as $tagId){
            $leadTagTable = JTable::getInstance('Leadtag', 'MarketingrocketTable');
            $leadTagTable->load(array('lead_id' => $leadTable->id, 'tag_id' => $tagId));
            if(!empty($leadTagTable->id))
                $leadTagTable->delete();
        }




    }
}

