<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketVirtuemartpayment extends JPlugin
{
    
    public $api = false;
    private static $type = 'virtuemartpayment';
    protected $autoloadLanguage = true;

    public function onBeforeFormLoad(&$type){
        if($type == self::$type){
            JModelLegacy::addIncludePath(JPATH_PLUGINS.'/marketingrocket/virtuemartpayment/models');
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/virtuemartpayment/form');

            if (!JComponentHelper::isInstalled('com_virtuemart') || !JComponentHelper::getComponent('com_virtuemart', true)->enabled)
            {
                JFactory::getApplication()->enqueueMessage('Virtuemart Component Is Not Found Or Its Disabled', 'error');
                JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&view=apilist', false));
            }

            if (!JPluginHelper::isEnabled('vmcustom', 'vmmarketingrocket'))
            {
                JFactory::getApplication()->enqueueMessage('Marketing Rocket Plugin For Virtue Mart not installed or its disabled', 'error');
                JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&view=apilist', false));
            }


        }

    }

    public function onLandingEditorDisplay(&$view){

        $db = JFactory::getDbo();
        $q = $db->getQuery(true);
        $q->select('id')->from($db->qn('#__mrocket_api', 'a'))->innerJoin($db->qn('#__mrocket_api_types', 'b').' ON '.$db->qn('a.type').' = '.$db->qn('b.type'))
            ->where($db->qn('a.type').' = '.$db->q(self::$type));
        $db->setQuery($q);
        $ids = $db->loadColumn();


        JFactory::getDocument()->addScriptDeclaration('jQuery(function($) {var virtueMartPaymentApis = ['.  implode(',', $ids).'];hiddenPriceValueArray.combine(virtueMartPaymentApis);})');
    }

    public function onBeforePayemtnFormCreation(&$jsonData, $item, $type){
        if($type == self::$type){

            $apiId = $item->paypal_account;
            $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
            $api = $apiModel->getItem($apiId);

            if(!empty($api->lead_choose)){
                JForm::addFieldPath(JPATH_PLUGINS.DIRECTORY_SEPARATOR.'marketingrocket'.DIRECTORY_SEPARATOR.'virtuemartpayment'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'fields');


                $obj = new stdClass();
                $obj->name = "vrituemart_producs";
                $obj->label = '';
                $obj->field_type = 'vrituemartproduct';
                $obj->attributes = array('products' => json_encode($api->products), 'currency' => $item->paypal_currency);
                $jsonData[] = $obj;

            }

            $obj = new stdClass();
            $obj->name = 'total_price';
            $obj->field_type = 'hidden';
            $jsonData[] = $obj;


        }
    }

    public function onValidateForm($form, $data, $type, &$ret)
    {
        if ($ret !== false && $type == self::$type) {
            $landingId = $data['landing_id'];
            $landingModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel');
            $landing = $landingModel->getItemById($landingId);

            $apiId = $landing->paypal_account;
            $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
            $api = $apiModel->getItem($apiId);


            $selectedProducts = array();
            if(!empty($api->lead_choose)){
                foreach ($api->products->product as $key => $product){
                    $id = (!empty($product)) ? $product : $api->products->product_id[$key];
                    if(!isset($data['vrituemart_producs'][$id]))
                        continue;

                    $selectedProducts[$id] = $data['vrituemart_producs'][$id];
                }
                if(empty($selectedProducts)){
                    JFactory::getApplication()->enqueueMessage('Select Some Product First', 'error');

                    $ret = false;
                    return false;
                }
            }


        }
    }

    public function onBeforeCreateOrder(&$saveFormData,  $data, &$landing, $type){
        if($type == self::$type){

            $apiId = $landing->paypal_account;
            $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
            $api = $apiModel->getItem($apiId);

            $selectedProducts = array();
            if(!empty($api->lead_choose)){
                foreach ($api->products->product as $key => $product){
                    $id = (!empty($product)) ? $product : $api->products->product_id[$key];
                    if(!isset($data['vrituemart_producs'][$id]))
                        continue;

                    $selectedProducts[$id] = $data['vrituemart_producs'][$id];
                }

            }
            else {
                foreach ($api->products->product as $key => $product){
                    $id = (!empty($product)) ? $product : $api->products->product_id[$key];

                    $selectedProducts[$id] = $api->products->product_id[$key];
                }
            }
            $price = 0;

            require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'helpers'.DS.'config.php';
            require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'helpers'.DS.'currencydisplay.php';
            $product_model = VmModel::getModel('product');


            foreach ($selectedProducts as $id => $qnt){
                $productRow = $product_model->getProduct($id, true,true,true,$qnt);

                $price += $productRow->prices['salesPriceTt'];
            }
            $landing->price = $price;
            $saveFormData = $selectedProducts;
        }

    }

    public function onCreateView(&$view , $item , $order, $type){
        if($type == self::$type){

            // TODO first register lead as User
            $lead = JTable::getInstance('Lead', 'MarketingrocketTable');
            $lead->load($order->lead_id);

            require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'helpers'.DS.'config.php';
            require_once JPATH_SITE.DS.'components'.DS.'com_virtuemart'.DS.'helpers'.DS.'cart.php';


            if(!JFactory::getUser()->guest){
                $user = JFactory::getUser();
            }
            else {
                $db = JFactory::getDbo();
                $q = $db->getQuery(true)
                    ->select('*')
                    ->from('#__users')
                    ->where($db->qn('email').' = '.$db->q($lead->email));
                $db->setQuery($q);
                $res = $db->loadObject();


                if(empty($res->id)){
                    JModelLegacy::addIncludePath(JPATH_SITE.DS.'components'.DS.'com_users'.DS.'models');
                    JForm::addFormPath(JPATH_SITE.DS.'components'.DS.'com_users'.DS.'models'.DS.'forms');
                    $registerModel	=  JModelLegacy::getInstance('Registration', 'UsersModel');
                    $data = array();
                    $requestData['name'] = (!empty($lead->first_name))?  $lead->first_name : $lead->email;
                    $requestData['username'] = $lead->email;
                    $requestData['email1'] = $lead->email;
                    $requestData['email2'] = $lead->email;
                    $requestData['password1'] = JUserHelper::genRandomPassword();
                    $return	= $registerModel->register($requestData);
                    if(empty($return)){
                        Zend_Debug::dump($registerModel->getErrors());
                        die;
                    }

                    $q = $db->getQuery(true)
                        ->select('*')
                        ->from('#__users')
                        ->where($db->qn('email').' = '.$db->q($lead->email));
                    $db->setQuery($q);
                    $res = $db->loadObject();


                }
                $user = JFactory::getUser($res->id);
            }





            $products = json_decode($order->params);

            $cart = new VirtueMartCart();
            $_POST['quantity'] = array();
            $i = 0;
            $ids = array();
            foreach ($products as $id => $qnt){
                $ids[] = $id;
                $_REQUEST['quantity'][] = $qnt;
                $i++;
            }
            $ret = $cart->add($ids);

            $session = JFactory::getSession();
            $s = $session->get('vmcart', '', 'vm');
            $s = json_decode($s);
            $s->marketing_rocket_order = 1;

            $model = new VmModel();
            $carts = $model->getTable('carts');
            $cartDataToStore = json_encode($s);

            $cObj = new StdClass();

            $cObj->virtuemart_user_id = (int) $user->id;
            $cObj->virtuemart_vendor_id = (int) $this->vendorId;
            $cObj->cartData = $cartDataToStore;
            $carts->bindChecknStore($cObj);

            if(!empty($cObj->virtuemart_cart_id)){
                JTable::addIncludePath(JPATH_PLUGINS.DS.'marketingrocket'.DS.'virtuemartpayment'.DS.'tables');
                $virtuOrderTable = JTable::getInstance('Virtuorders', 'MarketingrocketTable');
                if($virtuOrderTable instanceof MarketingrocketTableVirtuorders){
                    $virtuOrderTable->setCartId($cObj->virtuemart_cart_id);
                    $virtuOrderTable->setUserId($user->id);
                    $virtuOrderTable->setLeadId($lead->id);
                    $virtuOrderTable->setLandingId($order->landing_id);
                    $virtuOrderTable->setStatus(MarketingrocketTableVirtuorders::$status_cart_created);
                    $virtuOrderTable->store();
                }

            }

            JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_virtuemart&view=cart'));

        }
    }


}

