<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

class JFormFieldVrituemartproduct extends JFormField
{
    
    protected $products;
    protected $currency;
    protected $type = 'Checkbox';




    public function __get($name)
    {
        switch ($name)
        {
            case 'products':
            case 'currency':
                return $this->$name;
        }

        return parent::__get($name);
    }

    public function __set($name, $value)
    {
        switch ($name)
        {
                case 'products':
                case 'currency':
                    $this->$name = (string) $value;
                    break;
                default:
                    parent::__set($name, $value);
        }
    }

    public function setup(SimpleXMLElement $element, $value, $group = null)
    {
            $return = parent::setup($element, $value, $group);

            if ($return)
            {
                    $this->products   = $this->element['products'] ? json_decode((string) $this->element['products']) : '';
                    $this->currency  = $this->element['currency'] ? (string) $this->element['currency'] : '';
            }

            return $return;
    }
    
    protected function getInput() {
        $html = '<table class="table table-bordered table-striped">'
                . '<thead>'
                . '<tr>'
                . '<th>'.JText::_('PLG_SHOPIFYPAYMENT_PRODUCT_NAME').'</th>'
                . '<th>'.JText::_('PLG_SHOPIFYPAYMENT_PRODUCT_PRICE').'</th>'
                . '<th>'.JText::_('PLG_SHOPIFYPAYMENT_PRODUCT_QUANTITY').'</th>'
                . '</tr>'
                . '</thead>'
                . '<tbody>';
        require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'helpers'.DS.'config.php';
        require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'helpers'.DS.'currencydisplay.php';
        $product_model = VmModel::getModel('product');

        //finding currency Id
        $db = JFactory::getDbo();
        $q = $db->getQuery(true);
        $q->select('virtuemart_currency_id')
            ->from($db->qn('#__virtuemart_currencies'))
            ->where($db->qn('currency_code_3').' = '.$db->q($this->currency));
        $db->setQuery($q);
        $currencyId = $db->loadResult();
        $currency = CurrencyDisplay::getInstance($currencyId);

        foreach ($this->products->product as $key => $product){
            $id = (!empty($product)) ? $product : $this->products->product_id[$key];

            $productRow = $product_model->getProduct($id, true,true,true,$this->products->quntity[$key]);

            $html .= '<tr>'
                    . '<td>'.$productRow->product_name.'</td>'
                    . '<td>'.$currency->priceDisplay($productRow->prices['salesPrice'], $currencyId,$this->products->quntity[$key]).'</td>'
                    . '<td>'
                    . '<input type="number" class="span2" value="'.$this->products->quntity[$key].'" name="'.$this->name.'['.$id.']" />'
                    . '<a class="btn btn-danger remove-product" style="margin-left : 5px;"><i class="fa fa-times"></i></a>'
                    . '</td>'
                    . '</tr>'
                ;
        }
        $html .= '</tbody></table>'
                . '<script>jQuery(document).ready(function($){$("a.btn.remove-product").click(function(){'
                . 'var b = confirm("'.JText::_('PLG_SHOPIFYPAYMENT_ARE_YOU_SURE_ABOUT_DELETE', true).'");'
                . 'if(b){'
                . '$(this).parents("tr:first").fadeOut(500, function(){$(this).remove()})'
                . '}'
                . '})})</script>'
                . '';
        return $html;
    }

}
