<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketVirtuemart extends JPlugin
{
    
    public $api = false;
    private static $type = 'virtuemart';
    protected $autoloadLanguage = true;

    public function onBeforeFormLoad(&$type){
        if($type == self::$type){
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/virtuemart/form');
            JModelLegacy::addIncludePath(JPATH_PLUGINS.'/marketingrocket/virtuemart/models');

            $id = JFactory::getApplication()->input->getInt('id',0);
            if(empty($id)){
                $res = $this->checkApiExist();
                if(!empty($res)){
                    JFactory::getApplication()->enqueueMessage(JText::_('COM_MARKETINGROCKET_ONLY_ONE_CAN_BE_USED'), 'error');
                    JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&view=apilist', false));
                }
            }

            if (!JComponentHelper::isInstalled('com_virtuemart') || !JComponentHelper::getComponent('com_virtuemart', true)->enabled)
            {
                JFactory::getApplication()->enqueueMessage('Virtuemart Component Is Not Found Or Its Disabled', 'error');
                JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&view=apilist', false));
            }

            if (!JPluginHelper::isEnabled('vmcustom', 'vmmarketingrocket'))
            {
                JFactory::getApplication()->enqueueMessage('Marketing Rocket Plugin For Virtue Mart not installed or its disabled', 'error');
                JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&view=apilist', false));
            }

            if (!JPluginHelper::isEnabled('vmpayment', 'vmmarketingrocketpayment'))
            {
                JFactory::getApplication()->enqueueMessage('Marketing Rocket Payment Plugin For Virtue Mart not installed or its disabled', 'error');
                JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&view=apilist', false));
            }
        }

    }

    private function checkApiExist(){
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('a.id')->from('#__mrocket_api AS a')->innerJoin('#__mrocket_api_types AS b ON a.type = b.type')
            ->where('a.type = '.$db->q('virtuemart'))
        ;

        $db->setQuery($query);
        $res = $db->loadResult();

        return $res;
    }

    public function afterApiSaveForm($type, $data, $oldData, $id){
        if($type == self::$type){
            if($data['sync'] == 1){
                $db = JFactory::getDbo();
                $q = $db->getQuery(true)
                    ->select('*')
                    ->from($db->qn('#__virtuemart_orders', 'a'))
                    ->where($db->qn('virtuemart_order_id'). ' = (
		SELECT
			max('.$db->qn('virtuemart_order_id').') FROM '.$db->qn('#__virtuemart_orders').' WHERE '.$db->qn('virtuemart_user_id').' = '.$db->qn('a.virtuemart_user_id').'  
		GROUP BY '.$db->qn('virtuemart_user_id').'
)');
                $db->setQuery($q);
                $orders = $db->loadObjectList();
//                error_reporting(E_ALL);
//                ini_set('display_errors', 1);

                require_once JPATH_PLUGINS.DS.'vmcustom'.DS.'vmmarketingrocket'.DS.'handler.php';
                $emptyArray = array();
                $apiModel = JModelLegacy::getInstance('Api', 'MarketingRocketModel');
                handler::$api = $apiModel->getItem($id);
                foreach ($orders as $order){
                    handler::handleOrderChange($order, '');
                }

            }
        }
    }

    public function onApiLoadFormData($type, &$data){
        if($type == self::$type){
            unset($data['sync']);
        }
    }
}

