<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */
defined('_JEXEC') or die;
use Joomla\Registry\Registry;


class MarketingRocketModelVirtuemart extends JModelLegacy
{
    /**
     * 
     * @param array $options
     * @param JFormField $element
     * @param JForm $form
     */
    public function dynamicList(&$options, $element, $form){
        $db = JFactory::getDbo();
        $q = $db->getQuery(true);

        $q->select('*')
            ->from($db->qn('#__virtuemart_orderstates'));

        $db->setQuery($q);
        $res = $db->loadObjectList();

        $lang = JFactory::getLanguage();
        $extension = 'com_virtuemart_orders';
        $base_dir = JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_virtuemart';

        $language_tag = JFactory::getLanguage()->getTag();
        $reload = true;
        $lang->load($extension, $base_dir, $language_tag, $reload);


        foreach ($res as $row){
            $arr = array();
            $arr['text'] = JText::_($row->order_status_name);
            $arr['value'] = $row->order_status_code;
            $options[] = $arr;

        }

    }
    
}
