<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketVariablepricing extends JPlugin
{
    
    public $api = false;
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'variablepricing')
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/variablepricing/form');
         
    }
    
    public function onBeforePayemtnFormCreation(&$jsonData, $item, $type){
        if($type == 'variablepricing'){
            
            $apiId = $item->paypal_account;
            $api = $this->getApi($apiId);
            $targetType = $this->getApiTargetType($apiId);
            
            $obj = new stdClass();
            $obj->name = "variable_pricing";
            $obj->label = $api->field_label;
            $obj->field_type = 'list';
            
            $obj->field_options = new stdClass();
            $obj->field_options->options = array();
            foreach ($api->prices->price as $key => $priceRow){
                $rowObj = new stdClass();
                $rowObj->label = $api->prices->title[$key].' ('.number_format($priceRow, 2).' '.$item->paypal_currency.')';
                $rowObj->value = $priceRow;
                $obj->field_options->options[] = $rowObj;
            }
            
            $obj->required = true;
            if(!empty($api->field_description)){
                $obj->attributes['description'] = $api->field_description;
            }
            
            $jsonData[] = $obj;
            
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onBeforePayemtnFormCreation', array(&$jsonData, $item, $targetType) );
            
        }
    }
    public function onValidateForm($form, $data, $type, &$ret){
        if($ret !== false && $type === 'variablepricing'){
            $landingId = $data['landing_id'];
            $landingModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel');
            $landing = $landingModel->getItemById($landingId);
            
            $targetType = $this->getApiTargetType($landing->paypal_account);
            
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onValidateForm', array($form, $data, $targetType, &$ret));
                
        }
    }
    
    public function onBeforeCreateOrder(&$saveFormData,  $validData, &$landing, $type){
        if($type == 'variablepricing'){
            $landing->price = $validData['variable_pricing'];
            
            $apiId = $landing->paypal_account;
            $targetType = $this->getApiTargetType($apiId);
            
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onBeforeCreateOrder', array(&$saveFormData,  $validData, &$landing, $targetType));
            
        }
    }
    
    public function onIpnCall($landing, $order , $type, &$isValid, &$email , &$data){
        if($type == 'variablepricing'){
            
            $apiId = $landing->paypal_account;
            $targetType = $this->getApiTargetType($apiId);
            $api = $this->getApi($apiId);
            $landing->paypal_account = $api->payment_api;
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onIpnCall', array($landing, $order , $targetType, &$isValid, &$email , &$data));
            
            if($isValid){
                $api = $this->getApi($apiId);
                
                foreach ($api->prices->price as $key => $priceRow){
                    if($priceRow == $order->price){
                        $tag_id = $api->prices->tag_id[$key];
                        require_once JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables'.DIRECTORY_SEPARATOR.'lead.php';
                        $lead = JTable::getInstance('Lead', 'MarketingrocketTable');
                        $lead->load($order->lead_id);
                        $lead->addTag($tag_id);
                        break;
                    }
                }
            }
        }
        
    }
    
    public function onPaymentComplete($landing, $order,$type){
        if($type == 'variablepricing'){
            $apiId = $landing->paypal_account;
            $targetType = $this->getApiTargetType($apiId);
            
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onPaymentComplete', array($landing, $order,$targetType));
        }
    }
    
    public function onLandingFormValidate(&$ret, $form, &$data){
        if($data['have_paypal'] == 1){
            $this->api = null;
           
            $id = $data['paypal_account'];
            $api = $this->getApi($id);
            
            if($api->type == 'variablepricing'){
                $data['paypal_account'] = $api->payment_api;
                   
                $dispatcher = JDispatcher::getInstance();
                $dispatcher->trigger('onLandingFormValidate', array(&$ret, $form, &$data));
                $data['paypal_account'] = $id;
            }
        }
    }
    
    public function onCreateView(&$view , $item , $order, $type){
        if($type == 'variablepricing'){
            $apiId = $item->paypal_account;
            
            $api = $this->getApi($apiId);
            
            $productName = $item->paypal_product_name;
            foreach ($api->prices->price as $key => $priceRow){
                if($priceRow == $order->price){
                    $productName = $api->prices->title[$key];
                }
            }
            
            $item->paypal_product_name = $productName;
            
            $targetType = $this->getApiTargetType($apiId);
            $item->paypal_account = $api->payment_api;
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onCreateView', array(&$view , $item , $order, $targetType));
        }
    }
    
    private function getApi($apiId){
        if(!empty($this->api))
            return $this->api;
        require_once JPATH_COMPONENT_SITE.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'api.php';
        $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
        $this->api = $apiModel->getItem($apiId);
        
        return $this->api;
    }
    private function getApiTargetType($apiId){
        $api = $this->getApi($apiId);
        
        $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
        $targetType = $apiModel->getType($api->payment_api);
        if(empty($targetType))
            throw new Exception('Target Payment Plugin Not Found');
        return $targetType;
    }
}

