<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-gb" lang="en-gb" dir="ltr">
<head>
        <meta http-equiv="content-type" content="text/html; charset=utf-8" />
</head>
<body style="margin: 0px;">
    <div style="width: 600px;margin: 0px auto;text-align: center;padding-top: 100px">
        <img src="<?php echo JURI::base().'plugins/marketingrocket/stripe/assets/ajax-loader.gif' ?>" alt="loading" />
        <br /><br />
        <span id="status">Opening Stripe Checkout, Please Wait...</span>
        <br /><br /><br /><br />
        <img src="<?php echo JURI::base().'plugins/marketingrocket/stripe/assets/stripe-logo.png' ?>" alt="stripe" />
        <br />
        <a id="checkout-activate" style="color: #464c96;font-size: 18px;display: block;margin-top: 16px;" href="javascript::void(0)" onclick="openCheckout()">Should the Checkout popup appear in a timely fashion, please click here</a>
    </div>
    <script src="https://checkout.stripe.com/checkout.js"></script>
    <script>
        var purchased = false;
        var handler = StripeCheckout.configure({
          key: '<?php echo $this->fields['key'];?>',
          image: 'https://stripe.com/img/documentation/checkout/marketplace.png',
          locale: 'auto',
          currency: '<?php echo $this->fields['currency'];?>',
          email: '<?php echo $this->fields['email'];?>',
          bitcoin: <?php echo $this->fields['allow_bitcoin'];?> ? true : false,
          token: function(token) {
            purchased = true;
            var return_url = '<?php echo $this->fields['return'];?>';
            window.location.href = '<?php echo $this->fields['notify_url'];?>&token_id=' + token.id ;
          },
          closed: function(){
            if (!purchased) {
                document.getElementById('status').innerHTML = 'Checkout canceled. Redirecting...';
                document.getElementById('checkout-activate').style.display = 'none';
                window.location.href = '<?php echo $this->fields['cancel_return'];?>';
            } else {
                window.location.href = return_url;
            }
          }
        });

        function openCheckout() {
          handler.open({
            name: '<?php echo $this->fields['label'];?>',
            description: '<?php echo $this->fields['description'];?>',
            amount: <?php echo (int)($this->fields['amount'] * 100);?>
          });
        };

        window.onload = openCheckout;
        // Close Checkout on page navigation:
        window.addEventListener('popstate', function() {
          handler.close();
        });
        </script>
</body>
<?php die; ?>
