<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketStripe extends JPlugin
{   
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'stripe')
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/stripe/form');   
    }
    
    public function onCreateView(&$view , $item , $order, $type){
        if($type == 'stripe'){
            JModelLegacy::addIncludePath(JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models');
            $model = JModelLegacy::getInstance('Landing', 'MarketingrocketModel', array('ignore_request' => true));
            $leadModel = JModelLegacy::getInstance('Lead', 'MarketingrocketModel', array('ignore_request' => true));
            
            require_once JPATH_PLUGINS.'/marketingrocket/stripe/stripe.class.php';
            JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models');
            $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel', array('ignore_request' => true));
            $api = $apiModel->getItem($item->paypal_account);

            if(empty($api)){
                throw new Exception('Api Not Found', 404);
            }
            
            $p = new stripe_class;
            
            require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';
            $baseUrl = MRRoute::createFrontRoute('index.php?option=com_marketingrocket');

            $leadInfo = $leadModel->getLeadByRefCode($order->ref_code);
                        
            $view->fields = [
                'key' => $api->publishable_key,
                'label' => $api->stripe_payment_label,
                'description' => $item->paypal_product_name,
                'email' => $leadInfo->email,
                'currency' => $item->paypal_currency,
                'amount' => $order->price,
                'locale' => 'auto',
                'allow_bitcoin' => $api->allow_bitcoin,
                'return' => $baseUrl.'&task=payment.success&ref='.$order->ref_code.'&order='.$order->id,
                'cancel_return' => $baseUrl.'&task=payment.cancel&ref='.$order->ref_code.'&order='.$order->id,
                'notify_url' => $baseUrl.'&task=payment.ipn&ref='.$order->ref_code.'&order='.$order->id,
            ];
            
            $view->addTemplatePath( JPATH_PLUGINS.'/marketingrocket/stripe/tmpl' );
            $view->templates[] = 'stripe';
            
        }
    }
    
    public function onIpnCall($item, $order , $type, &$isValid, &$email , &$data){
        $jinput = JFactory::getApplication()->input;
        $token_id = $jinput->get('token_id', '', 'filter');
    
        if($type == 'stripe'){
            JModelLegacy::addIncludePath(JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models');
            $leadModel = JModelLegacy::getInstance('Lead', 'MarketingrocketModel', array('ignore_request' => true));

            $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel', array('ignore_request' => true));
            $api = $apiModel->getItem($item->paypal_account);
            if(empty($api)){
                throw new Exception('Api Not Found', 404);
            }

            require_once JPATH_PLUGINS.'/marketingrocket/stripe/stripe.class.php';
            $p = new stripe_class;             // initiate an instance of the class

            $leadInfo = $leadModel->getLeadByRefCode($order->ref_code);

            if($p->apply_charge($token_id, $item, $order, $leadInfo->email, $api)) {
                $isValid = true;
                $email = $leadInfo->email;
            }
            else {
                
                $db = JFactory::getDbo();
                $q = $db->getQuery(true);
                $q->update('#__mrocket_payments')->set('status = -1')->where('id = '.$db->q($order->id));
                $db->setQuery($q);
                $db->execute();
                
                $isValid = false;
            }
            
            
        }
    }

    public function onPaymentComplete($item, $order,$type){
        if($type == 'stripe'){
            if($order->status == 1){
                JFactory::getApplication()->redirect(JRoute::_(
                    'index.php?option=com_marketingrocket&task=payment.success&order_id='.$order->id.'&ref='.$order->ref_code , false
                ));
            }
            else {
                JFactory::getApplication()->redirect(JRoute::_(
                    'index.php?option=com_marketingrocket&task=payment.cancel&order_id='.$order->id.'&ref='.$order->ref_code , false
                ));
            }

        }
    }
}

