<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;
use Joomla\Registry\Registry;
jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketSparkpost extends JPlugin
{
    
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'sparkpost'){
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/sparkpost/form');
        }
    }
    
    public function onAfterFormLoad(&$type, &$form, $loadData){
        if($type == 'sparkpost'){
            $id = JFactory::getApplication()->input->getInt('id', 0);
            $setId = JComponentHelper::getParams('com_marketingrocket')->get('send_mail_by');
            if(!empty($id) && $id == $setId){
                $form->removeField('set_default');
            }
        }
    }
    
    public function onApiLoadFormData(&$type, &$data){
         if($type == 'sparkpost'){
            $id = JFactory::getApplication()->input->getInt('id', 0);
            $data['set_default'] = 0;
            if($id == 0){
                $data['set_default'] = 1;
            }
         }
    }
    public function onViewForm(&$type, &$buttons){
        if($type == 'sparkpost'){
            $selectOption = JComponentHelper::getParams('com_marketingrocket')->get('send_mail_by');
            $id = JFactory::getApplication()->input->getInt('id', 0);
            if($selectOption == 0 || $id == $selectOption) // default is not set yet or this one is default
                return;
            
            $doc = JFactory::getDocument();
            
            $doc->addScript(JURI::root().'/plugins/marketingrocket/sparkpost/assets/sparkpost.js', 'text/javascript', true );
    
        }
    }
    
    public function onWebHookCall(&$type, $api){
        if($type == 'sparkpost'){
            $content = file_get_contents('php://input');
            
            
//            if($_SERVER['HTTP_X_MESSAGESYSTEMS_WEBHOOK_TOKEN'] == sha1($api->api)){
                
                $content = json_decode($content);
                JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables');
                foreach ($content as $row){
                    $tag = $row->msys->track_event->rcpt_tags[0];
                    $leadCrons = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
                    $leadCrons->load(array('ref' => $tag));
                    if(!empty($leadCrons->id)){
                        $leadCrons->is_show = 1;
                        if($row->msys->track_event->type == 'click')
                        {
                            $leadCrons->is_clicked = 1;
                        }
                        $leadCrons->store();
                    }
                    
                }
                
//            }
            
        }
    }
    
    public function sendEmail(&$type, $api, $body, $subject, $fromEmail, $fromName, $emails, $ref, $row, $attachments, &$res){
        if($type == 'sparkpost'){

            $sendAsTransactional = false;
            $canSend = true;

            // check for Suppression List
            if(count($emails) == 1 && !empty($row->form_data)) { //its normal email

                if(!empty($row->form_data['is_in_sparkpost_suppression_list'])){
                    if($row->type == 'invoice'){
                        $sendAsTransactional = true;
                    }
                    else {
                        $canSend = false;
                    }
                }
            }
            
            foreach ($emails as $email){
                    if(empty($email) || trim($email) == '')
                    {
                        continue;
                    }
                    $url = 'https://api.sparkpost.com/api/v1/transmissions';
                    $ch = $this->getCurl($url,$api->api);

                    //set the url, number of POST vars, POST data
                    $sendOption = array(
                        'options' => array(
                            'open_tracking' => true,
                            'click_tracking' => true
                        ),
                        'recipients' => array(
                            array('address' => array('email' => $email))
                        ),
                        'content' => array(
                            'from' => array(
                                'name' => $fromName,
                                'email' => $fromEmail,

                            ),
                            'subject' => $subject,
                            'text' => strip_tags($body),
                            'html' => $body
                        ),

                    );
                    
                    //if($row->type == 'pre' || ($row->type == 'invoice' && $sendOption['content']['from']['email'] == 'test@test.com'))
					if(isset($row->type) && ($row->type == 'pre' || ($row->type == 'invoice' && $sendOption['content']['from']['email'] == 'test@test.com'))){ // notification or system emails 
                        $defaultConfigEmail = JFactory::getApplication()->getCfg('mailfrom');
                        if(!empty($api->email)){
                            $sendOption['content']['from']['email'] = $api->email;
                        }
                        else if(!empty ($defaultConfigEmail)){
                            $sendOption['content']['from']['email'] = $defaultConfigEmail;
                        }
                        else {
                            $urlPatch = JUri::getInstance();
                            $domain = $urlPatch->getHost();
                            $domain = str_replace('www.', '', $domain);

                            $sendOption['content']['from']['email'] = 'info@'.$domain;
                        }
                    } 

                    if(!empty($row->sequence_id)){
                            $sendOption['recipients'][0]['tags'] = array($ref);
                    }
                    foreach ($attachments as $attachment){
                        $array = array();
                        $array['name'] = $attachment->orginal_file_name;

                        $array['data'] = base64_encode(file_get_contents(JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'com_marketingrocket'.
                           DIRECTORY_SEPARATOR.'attachments'.DIRECTORY_SEPARATOR.$attachment->file_name));
                        $array['type'] = PHPMailer::filenameToType($attachment->orginal_file_name);

                        $sendOption['content']['attachments'][] = $array;
                   }

                   if($canSend){

                       if($sendAsTransactional){
                           $sendOption['options']['transactional'] = true;
                       }

                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch,CURLOPT_POSTFIELDS, json_encode($sendOption));
                        //execute post
                        $result = curl_exec($ch);
                        $result = json_decode($result);
                   }

                    //if($canSend == false || $result->errors){
					if($canSend == false || isset($result->errors)){	
                        if($canSend == false || $result->errors[0]->code == '1902' || $result->errors[0]->message == 'Message generation rejected'
                            || $result->errors[0]->source == 'Spam Complaint' || $result->errors[0]->source == 'Bounce Rule'
                            || $result->errors[0]->source == 'List Unsubscribe'
                        ){
                            if(!empty($row->cron_id)){
                                JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
                                $leadCrons = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
                                $leadCrons->load($row->cron_id);

                                $leadCrons->is_done = 1;

                                $leadCrons->body = $body;

                                $leadCrons->store();
                            }
                            if($canSend != false){
                                JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_marketingrocket/tables');
                                $leadDetailTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');

                                $leadDetailTable->lead_id = $row->lead_id;
                                $leadDetailTable->field_name = 'is_in_sparkpost_suppression_list';
                                $leadDetailTable->label = 'Is In Sparkpost Suppression List';
                                $leadDetailTable->value = 1;
                                $leadDetailTable->store();

                                $leadTable = $row->lead_detail;

                                $note = $leadTable->note;
                                if(!empty($leadTable->note))
                                    $note .= PHP_EOL;
                                $note .= JText::_('PLG_SPARKPOST_USER_ADDED_TO_BLACKLIST').PHP_EOL.$result->errors[0]->source;
                                $leadTable->note = $note;
                                $leadTable->store();

                            }

                            
                        }
                        try {
                            curl_close($ch);

                        }
                        catch (Exception $e){

                        }
                        if($canSend){

                            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
                            $findingUnreadMessage = JTable::getInstance('Messages', 'MarketingrocketTable');
                            $findingUnreadMessage->load(array('message_id' => '-9999', 'read_status' => 0));
                            if(empty($findingUnreadMessage->id)){
                                $findingUnreadMessage->message_id = '-9999';
                                $findingUnreadMessage->is_system = 1;
                                $findingUnreadMessage->published = 1;
                                $findingUnreadMessage->description = JText::_('PLG_MARKETINGROCKET_SPARKPOST_LEAD_ADDED_TO_BLACKLIST_DESC').'<ol></ol>';
                                $findingUnreadMessage->title = JText::plural('PLG_MARKETINGROCKET_SPARKPOST_LEAD_ADDED_TO_BLACKLIST', 0);
//                                $findingUnreadMessage->store();
                            }

                            preg_match('/\d+/', $findingUnreadMessage->title, $oldNumber);

                            $oldNumber = (int) $oldNumber[0];

                            $newNumber = $oldNumber+1;

                            $userData = $email;
                            if(!empty($row->first_name))
                                $userData .= ' ( '.$row->first_name.' '.$row->last_name.')';

                            $findingUnreadMessage->description = str_replace('</ol>', '<li><a href="index.php?option=com_marketingrocket&task=lead.edit&id='.$row->lead_id.'">'.$userData.'</a></li></ol>', $findingUnreadMessage->description);


                            $findingUnreadMessage->title = JText::plural('PLG_MARKETINGROCKET_SPARKPOST_LEAD_ADDED_TO_BLACKLIST', $newNumber);
                            $findingUnreadMessage->store();

                        }


                        return;
                    }


                    $curlData = curl_getinfo($ch);

                    $error = curl_error($ch);
                    curl_close($ch);
                    if(!empty($error)){
                         throw new Exception($result->errors[0]->message);
                    }
            }
            
            
            
            
            
            
            
            
        }
    }
    
    public function afterApiSaveForm(&$type, $data, $oldData, $id){
        if($type == 'sparkpost'){
            
            if(!empty($data['set_default'])){
                $params = JComponentHelper::getParams('com_marketingrocket');
                $params->set('send_mail_by', $id);

                $db = JFactory::getDBO();
                $query = $db->getQuery(true);

                // Build the query
                $query->update('#__extensions AS a');
                $query->set('a.params = ' . $db->quote((string)$params));
                $query->where('a.element = "com_marketingrocket"');

                // Execute the query
                $db->setQuery($query);
                $db->execute();
            }
           
            
            if(!empty($data['id'])){
                
                $newCh = $this->getCurl('https://api.sparkpost.com/api/v1/webhooks/'.$oldData->hook_id, $data['api']);
                if($data['api'] != $oldData->api){ // delete the old one
                    curl_setopt($newCh, CURLOPT_CUSTOMREQUEST, "DELETE");
                    $result = curl_exec($newCh);
                    curl_close($newCh);
                }
                else { // update and return
                    $sendOption = array(
                        'name' => $data['title'],
                    );
                    curl_setopt($newCh, CURLOPT_CUSTOMREQUEST, "PUT");
                    curl_setopt($newCh,CURLOPT_POSTFIELDS, json_encode($sendOption));
                    $result = curl_exec($newCh);
                    curl_close($newCh);
                    
                    $res = json_decode($result);
                    if($res->results){
                        $this->_saveNewParam($res, $data, $id);
                    }
                    return true;
                }
            }
            $ch = $this->getCurl('https://api.sparkpost.com/api/v1/webhooks', $data['api']);
            
            require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';
            $sendOption = array(
                'name' => $data['title'],
                'target' => MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=cron.getstat&id='.$id),
                'auth_token' => sha1($data['api']),
                'events' => array('open', 'click'),
            );
             
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch,CURLOPT_POSTFIELDS, json_encode($sendOption));
            
            //execute post
            $result = curl_exec($ch);
            $error = curl_error($ch);
            if(!empty($error)){
                throw new Exception($error);
            }
            
            $res = json_decode($result);
            if($res->results){
                $this->_saveNewParam($res, $data, $id);
                
            }
            else if($res->errors){
                throw new Exception($res->errors[0]->message);
            }
            
            curl_close($ch);
        }
    }
    private function _saveNewParam($res, $data, $id){
        $res = $res->results;
        $data['id'] = $id;
        JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');
        $newData = $data;
        unset($newData['id']);
        unset($newData['params']);
        $newData['hook_id'] = $res->id;
        $data['params'] = json_encode($newData);
        $table = JTable::getInstance('Api', 'MarketingrocketTable');
        $table->bind($data);
        $table->store();
    }
    public function onDeleteApi(&$type, $item){
        if($type == 'sparkpost'){
            $ch = $this->getCurl('https://api.sparkpost.com/api/v1/webhooks/'.$item->hook_id, $item->api);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
            $result = curl_exec($ch);
            curl_close($ch);
        }
    }
    
    private function getCurl($url , $api){
        

        //open connection
        $ch = curl_init();

        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
//                CURLOPT_HEADER         => true,
//            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_ENCODING       => "",
            CURLOPT_AUTOREFERER    => true,
            CURLOPT_CONNECTTIMEOUT => 120,
            CURLOPT_TIMEOUT        => 120,
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTPHEADER => array(
                                        'Content-Type: application/json',
                                        'Authorization: '.$api
                                        )
        );

        curl_setopt_array( $ch, $options );
        return $ch;
    }
}

