<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;
use Joomla\Registry\Registry;
jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketShopifypayment extends JPlugin
{
    
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'shopifypayment'){
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/shopifypayment/form');
            JModelLegacy::addIncludePath(JPATH_PLUGINS.'/marketingrocket/shopifypayment/models');
        }
    }
    /*
     * 
     */
    public function onAfterFormLoad(&$type, JForm &$form, $loadData){
        if($type == 'shopifypayment'){
            $id = JFactory::getApplication()->input->getInt('id', 0);
            if($id == 0){
                $form->removeField('products');
                $form->removeField('payment_api');
                
            }
        }
    }
    
    public function onApiFormValidate(&$ret, $form, &$data){
        if($ret && $ret['type'] == 'shopifypayment' && $ret['id'] > 0){
            
            $products = json_decode($ret['products']);
            
            $ch = $this->getCurl('http://shopify.marketing-rocket.com/api.php');
            curl_setopt ($ch, CURLOPT_POST, true);
            
            $params = array(
                'api' => $data['api'],
                'shop' => $data['shop'],
                'action' => 'getVariant',
                'id' => ''
            );
            $products->price = array();
            foreach ($products->product as $key => $product){
                
                $params['id'] = (!empty($product)) ? $product : $products->product_id[$key];
                @curl_setopt ($ch, CURLOPT_POSTFIELDS, $params);
                $response = curl_exec($ch);
                if($response == false){
                     throw new Exception(curl_error($ch));
                }
               
                $resault = json_decode($response);
                if(empty($resault) || empty($resault->data))
                {
                    JFactory::getApplication()->enqueueMessage(JText::_('PLG_SHOPIFYPAYMENT_PRODUCT_IS_NOT_AVAILABE'), 'error');
                    
                    $this->handleError(sprintf('Shopify : The product with id "%s" is not availabe', $params['id']), sprintf('Shopify : The product with id "%s" is not availabe', $params['id']));
                    
                    $ret = false;
                    return false;
                }
                if($resault->data->inventory_management == 'shopify' && $resault->data->inventory_quantity < $products->quntity[$key] && $resault->data->inventory_policy == 'deny'){
                    JFactory::getApplication()->enqueueMessage(JText::_('PLG_SHOPIFYPAYMENT_PRODUCT_IS_NOT_AVAILABE'), 'error');
                    
                    $this->handleError(sprintf('Shopify : the remaining quantity of Variant "%s" is lower than requested', $resault->data->title), sprintf('Shopify : the remaining quantity of Variant "%s" is lower than requested', $resault->data->title));
                    
                    $ret = false;
                    return false;
                }
                
                $rowParam = $params;
                $rowParam['action'] = 'getProduct';
                $rowParam['id'] = $resault->data->product_id;
                @curl_setopt ($ch, CURLOPT_POSTFIELDS, $rowParam);
                $productResp = curl_exec($ch);
                if($productResp == false){
                     throw new Exception(curl_error($ch));
                }
                
                $productRes = json_decode($productResp);
                $products->price[$key] = $resault->data->price;
                
                $variantName = ($resault->data->title == 'Default Title') ? '' : ' - '.$resault->data->title;
                
                $products->title[$key] = $productRes->data->title.$variantName;
                
                if(isset($resault->error)){
                    throw new Exception($resault->message, $resault->code);
                }
                
                
            }
            $ret['products'] = json_encode($products);
        }
    }
    
     public function onLandingEditorDisplay(&$view){
        
        $db = JFactory::getDbo();
        $q = $db->getQuery(true);
        $q->select('id')->from($db->qn('#__mrocket_api', 'a'))->innerJoin($db->qn('#__mrocket_api_types', 'b').' ON '.$db->qn('a.type').' = '.$db->qn('b.type'))
                ->where($db->qn('a.type').' = '.$db->q('shopifypayment'));
        $db->setQuery($q);
        $ids = $db->loadColumn();
                
        
        JFactory::getDocument()->addScriptDeclaration('jQuery(function($) {var shopifyPaymentApis = ['.  implode(',', $ids).'];hiddenPriceValueArray.combine(shopifyPaymentApis);})');
    }
    
        
    public function onBeforePayemtnFormCreation(&$jsonData, $item, $type){
        if($type == 'shopifypayment'){
            $apiId = $item->paypal_account;
            $api = $this->getApi($apiId);
            $targetType = $this->getApiTargetType($apiId);
            
            // check to see first name added to form or not , if its added , then last name field will be added , otherwise the full name filed will be added
            $nameAdded = false;
            foreach ($jsonData as $row){
                if($row->name == 'first-name' || $row->name == 'name'){
                    $nameAdded = true;
                    break;
                }
            }
            if($nameAdded == false){
                $obj = new stdClass();
                $obj->name = "name";
                $obj->label = 'PLG_SHOPIFYPAYMENT_FULL_NAME';
                $obj->field_type = 'text';
                $obj->required = true;
                array_unshift($jsonData, $obj);
            }
            else {
                $obj = new stdClass();
                $obj->name = "last-name";
                $obj->label = 'PLG_SHOPIFYPAYMENT_LAST_NAME';
                $obj->field_type = 'text';
                $obj->required = true;
                
                array_splice( $jsonData, 1, 0, array($obj));
            }
            
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onBeforePayemtnFormCreation', array(&$jsonData, $item, $targetType) );
            
             if($targetType != 'paypalpro'){
                
                $addressAdded = false;
                foreach ($jsonData as $row){
                    if($row->field_type == 'address'){
                        $addressAdded = true;
                    }
                }
                if($addressAdded == false){
                    $obj = new stdClass();
                    $obj->label = 'PLG_SHOPIFYPAYMENT_BILLING_ADDRESS';
                    $obj->field_type = 'section_break';
                    $jsonData[] = $obj;
                    
                    
                    $obj = new stdClass();
                    $obj->field_type = 'address';
                    $jsonData[] = $obj;
                }
                
            }
            
            $obj = new stdClass();
            $obj->label = 'PLG_SHOPIFYPAYMENT_SHIPPING_ADDRESS';
            $obj->field_type = 'section_break';
            $jsonData[] = $obj;

            $obj = new stdClass();
            $obj->name = "sameaddress";
            $obj->label = 'PLG_SHOPIFYPAYMENT_SHIPPING_SAME_BILLING';
            $obj->attributes = array('default' => '0');
            $obj->field_type = 'checkbox';

            $jsonData[] = $obj;
            
            
            $obj = new stdClass();
            $obj->field_type = 'address';
            $obj->address_prefix = 'shipping_';
            
            $input = JFactory::getApplication()->input;
            $data = $input->post->get('jform', array(), 'array');
            if(!empty($data) && empty($data['sameaddress']))
                $obj->is_required = true;
            else if(empty ($data))
                $obj->is_required = true;
            else 
                $obj->is_required = false;
            $jsonData[] = $obj;
            
            if(!empty($api->lead_choose)){
                JForm::addFieldPath(JPATH_PLUGINS.DIRECTORY_SEPARATOR.'marketingrocket'.DIRECTORY_SEPARATOR.'shopifypayment'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'fields');
                
                
                $obj = new stdClass();
                $obj->name = "shopify_product";
                $obj->label = '';
                $obj->field_type = 'shopifyproduct';
                $obj->attributes = array('products' => json_encode($api->products), 'currency' => $item->paypal_currency);
                $jsonData[] = $obj;
                
            }
            
            $obj = new stdClass();
            $obj->name = 'total_price';
            $obj->field_type = 'hidden';
            $jsonData[] = $obj;
            
            
            JFactory::getDocument()->addScript(JURI::base().'/plugins/marketingrocket/shopifypayment/assets/js/script.js' , 'text/javascript', true);
        }
    }
    public function onValidateForm($form, $data, $type, &$ret){
        if($ret !== false && $type === 'shopifypayment'){
            $landingId = $data['landing_id'];
            $landingModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel');
            $landing = $landingModel->getItemById($landingId);
            
            $api = $this->getApi($landing->paypal_account);
            $targetType = $this->getApiTargetType($landing->paypal_account);
            
            if($data['sameaddress']){
                $addressFileds = array('address', 'address2', 'city', 'state', 'zipcode', 'country', 'phone');
                foreach ($addressFileds as $addressFiled)
                    $ret['shipping_'.$addressFiled] = $data[$addressFiled];
            }
            
            // check product availablity
            $ch = $this->getCurl('http://shopify.marketing-rocket.com/api.php');
            curl_setopt ($ch, CURLOPT_POST, true);
                
            $params = array(
                'api' => $api->api,
                'shop' => $api->shop,
                'action' => 'getVariant',
                'id' => ''
            );
            if(!isset($data['shopify_product']))
                $ret['shopify_product'] = array();
            
            $totalPrice = 0;
            foreach ($api->products->product as $key => $product){
                $params['id'] = (!empty($product)) ? $product : $api->products->product_id[$key];
                $quantity = $api->products->quntity[$key];
                if(!empty($api->lead_choose)){
                    if(!isset($data['shopify_product'][$params['id']])){
                        continue;
                    }
                    $quantity = intval($data['shopify_product'][$params['id']]);
                    if($quantity < 1)
                        continue;
                }
                @curl_setopt ($ch, CURLOPT_POSTFIELDS, $params);
                $response = curl_exec($ch);
                if($response == false){
                     throw new Exception(curl_error($ch));
                }
               
                $resault = json_decode($response);
                if(empty($resault) || empty($resault->data))
                {
                    JFactory::getApplication()->enqueueMessage('PLG_SHOPIFYPAYMENT_PRODUCT_IS_NOT_AVAILABE', 'error');
                    
                    $this->handleError(sprintf('Shopify : The product with id "%s" is not availabe', $params['id']), sprintf('Shopify : The product with id "%s" is not availabe', $params['id']));
                    
                    $ret = false;
                    return false;
                }
                if($resault->data->inventory_management == 'shopify' && $resault->data->inventory_quantity < $quantity && $resault->data->inventory_policy == 'deny'){
                    JFactory::getApplication()->enqueueMessage('PLG_SHOPIFYPAYMENT_PRODUCT_IS_NOT_AVAILABE', 'error');
                    
                    $this->handleError(sprintf('Shopify : the remaining quantity of Variant "%s" is lower than requested', $resault->data->title), sprintf('Shopify : the remaining quantity of Variant "%s" is lower than requested', $resault->data->title));
                    
                    $ret = false;
                    return false;
                }
                
                if(isset($resault->error)){
                    throw new Exception($resault->message, $resault->code);
                }
                
                $ret['shopify_product'][$params['id']] = $quantity;
                
                $rowPrice= $api->products->price[$key]*$quantity;
                $totalPrice += $rowPrice;
            }
            if($ret){
                $ret['total_price'] = $totalPrice;
            }
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onValidateForm', array($form, $data, $targetType, &$ret));
                
                    
        }
    }
    
    public function onBeforeCreateOrder(&$saveFormData,  $validData, &$landing, $type){
        if($type == 'shopifypayment'){
            
            $landing->price = $validData['total_price'];
            
            $apiId = $landing->paypal_account;
            $targetType = $this->getApiTargetType($apiId);
            
            
            
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onBeforeCreateOrder', array(&$saveFormData,  $validData, &$landing, $targetType));
            
        }
    }
    public function onCreateView(&$view , $item , $order, $type){
        if($type == 'shopifypayment'){
            
            if($order->price == 0){
                require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';
                $url = MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=payment.ipn&ref='.$order->ref_code.'&order='.$order->id);
            
                file_get_contents($url);
                JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&task=payment.success&ref='.$order->ref_code));
            }
            
            $apiId = $item->paypal_account;
            $targetType = $this->getApiTargetType($apiId);
            $api = $this->getApi($apiId);
            $item->paypal_account = $api->payment_api;
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onCreateView', array(&$view , $item , $order, $targetType));
        }
    }
    
    public function onIpnCall($landing, $order , $type, &$isValid, &$email , &$data){
        if($type == 'shopifypayment'){
            $apiId = $landing->paypal_account;
            $targetType = $this->getApiTargetType($apiId);
            $api = $this->getApi($apiId);
            
            if($order->price == 0 && $order->status == 0){
                $isValid = true;
                $this->validPayment($apiId, $order);
            }
            else {
                $landing->paypal_account = $api->payment_api;
                $dispatcher = JDispatcher::getInstance();
                $dispatcher->trigger('onIpnCall', array($landing, $order , $targetType, &$isValid, &$email , &$data));

                if($isValid){
                    $this->validPayment($apiId, $order);
                }
            }
            
        }
        
    }
    
    private function validPayment($apiId, $order){
        $api = $this->getApi($apiId);
                
        $ch = $this->getCurl('http://shopify.marketing-rocket.com/api.php');
        curl_setopt ($ch, CURLOPT_POST, true);

        require_once JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables'.DIRECTORY_SEPARATOR.'lead.php';
        $lead = JTable::getInstance('Lead', 'MarketingrocketTable');
        $lead->load($order->lead_id);
        $formData = $lead->getFormData();

        if(!isset($formData['last-name'])){
            $fullName = explode(' ', $formData['name']);
            $formData['first-name'] = array_shift($fullName);
            $formData['last-name'] = implode(' ', $fullName);
            if(empty($formData['last-name']))
                $formData['last-name'] = $formData['first-name'];
        }

        if(!empty($api->lead_choose)){
            $products = json_decode($formData['shopify_product'], true);
            foreach ($products as $id => $quantity){
                $row = array('variant_id' => $id, 'quantity' => $quantity);
                $items[] = $row;
            }
        }
        else {
            $items = array();
            foreach ($api->products->product as $key => $product){
                $id = (!empty($product)) ? $product : $api->products->product_id[$key];

                $row = array('variant_id' => $id, 'quantity' => $api->products->quntity[$key]);
                $items[] = $row;

            }
        }


        $params = array(
            'api' => $api->api,
            'shop' => $api->shop,
            'action' => 'createOrder',
            'params' => array(
                'line_items' => $items,
                'customer' => array(
                    'first_name' => $formData['first-name'],
                    'last_name' => $formData['last-name'],
                    'email' => $formData['email']
                ),
                'billing_address' => array(
                    'first_name' => $formData['first-name'],
                    'last_name' => $formData['last-name'],
                    'address1' => $formData['address'],
                    'address2' => @$formData['address2'],
                    'phone' => $formData['phone'],
                    'city' => $formData['city'],
                    'province' => @$formData['state'],
                    'country_code' => $formData['country'],
                    'zip' => $formData['zipcode'],
                ),
                'shipping_address' => array(
                    'first_name' => $formData['first-name'],
                    'last_name' => $formData['last-name'],
                    'address1' => $formData['shipping_address'],
                    'address2' => @$formData['shipping_address2'],
                    'phone' => $formData['shipping_phone'], 
                    'city' => $formData['shipping_city'],
                    'province' => @$formData['shipping_state'],
                    'country_code' => $formData['shipping_country'],
                    'zip' => $formData['shipping_zipcode'],
                ),
                'email' => $formData['email'],
                'financial_status' =>  'paid',
                'inventory_behaviour' =>  'decrement_ignoring_policy'

            )
        );
        $this->http_build_query_for_curl($params, $post); 
        @curl_setopt ($ch, CURLOPT_POSTFIELDS, $post);

        $response = curl_exec($ch);
        if($response == false){
//                     throw new Exception(curl_error($ch));
        }
        curl_close($ch);
        $resault = json_decode($response);
        if(isset($resault->error)){
//                    throw new Exception($resault->message, $resault->code);
        }
    }
    
    private function getApi($apiId){
        if(!empty($this->api))
            return $this->api;
        require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'api.php';
        $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
        $this->api = $apiModel->getItem($apiId);
        
        return $this->api;
    }
    private function getApiTargetType($apiId){
        $api = $this->getApi($apiId);
        
        $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
        $targetType = $apiModel->getType($api->payment_api);
        if(empty($targetType))
            throw new Exception('Target Payment Plugin Not Found');
        return $targetType;
    }


    private function getCurl($url){
        

        //open connection
        $ch = curl_init();

        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
//                CURLOPT_HEADER         => true,
//            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_ENCODING       => "",
            CURLOPT_AUTOREFERER    => true,
            CURLOPT_CONNECTTIMEOUT => 120,
            CURLOPT_TIMEOUT        => 120,
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_SSL_VERIFYPEER => false
        );

        curl_setopt_array( $ch, $options );
        return $ch;
    }
    
    private function handleError($title, $message){
        require_once JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';
        MarketingrocketHelper::sendSystemMessage($title, $message);
        
        $mailer = JFactory::getMailer();
        // Build email message format.
        $mailer->IsHTML();
        $mailer->setSender(array(JFactory::getApplication()->getCfg('mailfrom'), JFactory::getApplication()->getCfg('fromname')));
        $mailer->setSubject('Marketing Rocket Error :'.$title);
        $mailer->setBody($message);

        $mailer->addRecipient(JFactory::getApplication()->getCfg('mailfrom'));
        $mailer->SetFrom(JFactory::getApplication()->getCfg('mailfrom'));
        $mailer->Send();
    }
    
    private function http_build_query_for_curl( $arrays, &$new = array(), $prefix = null ) {

        if ( is_object( $arrays ) ) {
            $arrays = get_object_vars( $arrays );
        }

        foreach ( $arrays AS $key => $value ) {
            $k = isset( $prefix ) ? $prefix . '[' . $key . ']' : $key;
            if ( is_array( $value ) OR is_object( $value )  ) {
                $this->http_build_query_for_curl( $value, $new, $k );
            } else {
                $new[$k] = $value;
            }
        }
    }
    
    
}

