<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */
defined('_JEXEC') or die;
use Joomla\Registry\Registry;
class ShopifyModelShopify extends JModelLegacy
{
    /**
     * 
     * @param array $options
     * @param JFormField $element
     * @param JForm $form
     */
    public function dynamicList(&$options, $element, $form){
        
        $id = JFactory::getApplication()->input->getInt('id',0);
        if($id == 0)
            return;
        
        $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
        $item = $apiModel->getItem($id);
        
        $ch = $this->getCurl('http://shopify.marketing-rocket.com/api.php');
        curl_setopt ($ch, CURLOPT_POST, true);
        
        $params = array(
            'api' => $item->api,
            'shop' => $item->shop,
            'action' => 'getPorductList'
        );
        
        @curl_setopt ($ch, CURLOPT_POSTFIELDS, $params);
        
        $response = curl_exec($ch);
        if($response == false){
             throw new Exception(curl_error($ch));
        }
        curl_close($ch);
        $resault = json_decode($response);
        if(isset($resault->error)){
            JFactory::getApplication()->enqueueMessage($resault->message, 'error');
            return;
        }
        $products = $resault->data;
        foreach ($products as $product){
            foreach ($product->variants as $variant){
                $arr = array();
                $arr['text'] = $product->title.' ('.$variant->title.')'.' '.$variant->price;
                if($variant->inventory_management == 'shopify'){
                    $arr['text'] .= ' ('.$variant->inventory_quantity.')';
                }
                $arr['value'] = $variant->id;
                $options[] = $arr;
            }
            
        }
        
        
    }
    
    private function getCurl($url){
        

        $ch = curl_init();

        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => "",
            CURLOPT_AUTOREFERER    => true,
            CURLOPT_CONNECTTIMEOUT => 120,
            CURLOPT_TIMEOUT        => 120,
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_SSL_VERIFYPEER => false
        );

        curl_setopt_array( $ch, $options );
        return $ch;
    }
    
    
    
}
