<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;
use Joomla\Registry\Registry;
jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketShopify extends JPlugin
{
    
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'shopify')
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/shopify/form');
         
    }
    
    public function onApiLoadFormData(&$type,&$data){
        if($type == 'shopify'){
            $checkData = JFactory::getApplication()->getUserState('com_marketingrocket.edit.api.data', array());
            if(empty($checkData) && empty($data->id)){
                $data['new_tag'] = 'PURCHASED: %product_name% PRODUCT NAME';
            }
            require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';
            $data['webhook_url'] = MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=api.webhook&plugin=shopify');
            
        }
    }
    
    public function onWebhook(&$type){
        if($type == 'shopify'){
            $data = json_decode(file_get_contents('php://input'));
//            $data = json_decode(file_get_contents('data.json'));
//            Zend_Debug::dump($data);
            if(empty($data->email) || empty($data->line_items)){
                return true;
            }
            $db = JFactory::getDbo();
                
            $q = $db->getQuery(true);
            
            $q->select('params')->from('#__mrocket_api')->where('type = "shopify"');
            if($data->financial_status == 'pending'){
                $q->where($db->qn('params').' LIKE '.$db->q('%"event":"order_creation"%'));
            }
            else {
                $q->where($db->qn('params').' LIKE '.$db->q('%"event":"payment"%'));
            }
            
            $db->setQuery($q);

            $params = $db->loadResult();
            if(empty($params))
                return true;

            $registry = new Registry;
            $registry->loadString($params);
            $apiData = $registry->toArray();
            $secret = $apiData['signature'];
            $hmac_header = $_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'];
            
            $verified = $this->verify_webhook(file_get_contents('php://input'), $hmac_header, $secret);
            if($verified && !empty($hmac_header)){
                JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');
                $leadTable = JTable::getInstance('Lead', 'MarketingrocketTable');
                
                $leadTable->load(array('email' => $data->email, 'is_temp' => 0));
                
                if(empty($leadTable->id)){
                    $leadTable->email = $data->email;
                    if(!empty($data->customer->first_name))
                        $leadTable->first_name = $data->customer->first_name;
                    if(!empty($data->customer->last_name))
                        $leadTable->last_name = $data->customer->last_name;
                    
                    
                    $leadTable->published = 1;
                    $leadTable->is_temp = 0;
                    $leadTable->store();
                    
                    
                    $leadTable->addRefCode();
                    
                    $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
                    $leadDetailsTable->landing_id = 0;
                    $leadDetailsTable->lead_id = $leadTable->id;
                    $leadDetailsTable->field_name = 'MR_form_name';
                    $leadDetailsTable->value = 'Shopify Customer';
                    $leadDetailsTable->store();

                    $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
                    $leadDetailsTable->landing_id = 0;
                    $leadDetailsTable->lead_id = $leadTable->id;
                    $leadDetailsTable->field_name = 'MR_submited_date';
                    $leadDetailsTable->value = JFactory::getDate()->toSql();
                    $leadDetailsTable->store();
                }
                if(!is_array($apiData['predefined_tags'])){
                    $apiData['predefined_tags'] = json_decode($apiData['predefined_tags']);
                }
                foreach ($apiData['predefined_tags'] as $tagId){
                    $leadTable->addTag($tagId);
                }
                
                if(!empty($apiData['new_tag'])){
                    
                    foreach ($data->line_items as $product){
                        $tagName = trim($apiData['new_tag']);
                        $tagName = str_replace('%product_name%', $product->name, $tagName);
                        
                        $tagTable = JTable::getInstance('Tag', 'MarketingrocketTable');
                        $tagTable->load(array('title' => $tagName));

                        if(empty($tagTable->id)){
                            $tagTable->title = $tagName;
                            $tagTable->published = 1;
                            $tagTable->store();
                        }
                        
                        $leadTable->addTag($tagTable->id);
                    }
                    
                    
                }
                
            }
        }
        
    }
    
    public function verify_webhook($data, $hmac_header, $secret)
    {
      $calculated_hmac = base64_encode(hash_hmac('sha256', $data, $secret, true));
      return ($hmac_header == $calculated_hmac);
    }
    
    public function onViewForm(&$type, &$buttons){
        if($type == 'shopify'){
            $buttons = array(
                'jform[predefined_tags][]' => array(
                    'type' => 'tag',
                ),
            );
        }
    }
    
}

