<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;
use Joomla\Registry\Registry;
jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketSendgrid extends JPlugin
{
    
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'sendgrid'){
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/sendgrid/form');
        }
    }
    
    public function onAfterFormLoad(&$type, &$form, $loadData){
        if($type == 'sendgrid'){
            $id = JFactory::getApplication()->input->getInt('id', 0);
            $setId = JComponentHelper::getParams('com_marketingrocket')->get('send_mail_by');
            if(!empty($id) && $id == $setId){
                $form->removeField('set_default');
            }
        }
    }
    
    public function onApiLoadFormData(&$type,&$data){
        if($type == 'sendgrid'){
            require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';
            if(!empty($data['id']))
                $data['webhook_url'] =  MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=cron.getstat&id='.$data['id']);
            
            $id = JFactory::getApplication()->input->getInt('id', 0);
            $data['set_default'] = 0;
            if($id == 0){
                $data['set_default'] = 1;
            }
            
        }
    }
    
    public function onViewForm(&$type, &$buttons){
        if($type == 'sendgrid'){
            $selectOption = JComponentHelper::getParams('com_marketingrocket')->get('send_mail_by');
            $id = JFactory::getApplication()->input->getInt('id', 0);
            if($selectOption == 0 || $id == $selectOption) // default is not set yet or this one is default
                return;
            
            $doc = JFactory::getDocument();
            
            $doc->addScript(JURI::root().'/plugins/marketingrocket/sendgrid/assets/sendgrid.js', 'text/javascript', true );
    
        }
    }
    
    public function afterApiSaveForm(&$type, $data, $oldData, $id){
        if($type == 'sendgrid'){
            if(!empty($data['set_default'])){
                $params = JComponentHelper::getParams('com_marketingrocket');
                $params->set('send_mail_by', $id);

                $db = JFactory::getDBO();
                $query = $db->getQuery(true);

                // Build the query
                $query->update('#__extensions AS a');
                $query->set('a.params = ' . $db->quote((string)$params));
                $query->where('a.element = "com_marketingrocket"');

                // Execute the query
                $db->setQuery($query);
                $db->execute();
            }
        }
    }
    
    public function onWebHookCall(&$type, $api){
        if($type == 'sendgrid'){
            $content = file_get_contents('php://input');
            $content = json_decode($content);
            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables');
            foreach ($content as $row){
                $tag = $row->category;
                $leadCrons = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
                $leadCrons->load(array('ref' => $tag));
                if(!empty($leadCrons->id)){
                    $leadCrons->is_show = 1;
                    if($row->event == 'click')
                    {
                        $leadCrons->is_clicked = 1;
                    }
                    $leadCrons->store();
                }

            }
        }
    }
    
    public function sendEmail(&$type, $api, $body, $subject, $fromEmail, $fromName, $emails, $ref, $row, $attachments, &$res){
        if($type == 'sendgrid'){
//            error_reporting(E_ALL);
        
//            ini_set('display_errors',1);
            
            
            foreach ($emails as $email){
                $ch =  $this->getCurl('https://api.sendgrid.com/api/mail.send.json');
                $params = array(
                    'api_user' => $api->user,
                    'api_key'   => $api->password,
                    'to' => $email,
                    'subject' => $subject,
                    'html' => $body,
                    'from' => $fromEmail,
                    'fromname' => $fromName
                );


                if(!empty($row->sequence_id)){
                    $json_string = array(
                       'to' => array(
                         $email
                       ),
                       'category' => $ref
                     );
                    $params['x-smtpapi'] = json_encode($json_string);
                }
//                $params['attachments'] = array();
                foreach ($attachments as $attachment){
                    $params['files['.$attachment->orginal_file_name.']'] = file_get_contents(JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'com_marketingrocket'.
                       DIRECTORY_SEPARATOR.'attachments'.DIRECTORY_SEPARATOR.$attachment->file_name);
               }
               
               
               
                curl_setopt ($ch, CURLOPT_POST, true);
                curl_setopt ($ch, CURLOPT_POSTFIELDS, $params);

                $response = curl_exec($ch);
                
                if($response == false){
                     throw new Exception(curl_error($ch));
                }
                curl_close($ch);
                $resault = json_decode($response);
                if(isset($resault->errors)){
                      throw new Exception(curl_error($resault->errors));
                }
            }
          
        }
    }
    
    private function getCurl($url){
        

        //open connection
        $ch = curl_init();

        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER         => false,
//            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_ENCODING       => "",
            CURLOPT_AUTOREFERER    => true,
            CURLOPT_CONNECTTIMEOUT => 120,
            CURLOPT_TIMEOUT        => 120,
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_SSL_VERIFYPEER => false,
//            CURLOPT_SSLVERSION => CURL_SSLVERSION_TLSv1_2,
        );

        curl_setopt_array( $ch, $options );
        return $ch;
    }
   
}

