<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketPaypalpro extends JPlugin
{
    
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'paypalpro')
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/paypalpro/form');
         
    }
    
    public function onBeforePayemtnFormCreation(&$jsonData, $item, $type){
        if($type == 'paypalpro'){
            $tmpJson = $jsonData;
            $jsonData = array();
            $addressAdded = false;
            foreach ($tmpJson as $row){
                if($row->field_type != 'address'){
                    $jsonData[] = $row;
                }
                else {
                    $addressAdded = true;
                    $this->_addFields($jsonData);
                    $jsonData[] = $row;
                }
                
            }
            if($addressAdded == false){
                $this->_addFields($jsonData);
                
                $obj = new stdClass();
                $obj->field_type = 'address';
                $jsonData[] = $obj;
        
                
            }
//           
//            
//            
//            Zend_Debug::dump($jsonData);
//            die;
        }
    }
    private function _addFields(&$jsonData){
        $obj = new stdClass();
        $obj->label = 'PLG_MARKETINGROCKET_PAYMENT_DETAIL';
        $obj->field_type = 'section_break';
        $jsonData[] = $obj;

        $obj = new stdClass();
        $obj->label = 'PLG_MARKETINGROCKET_FIRST_NAME';
        $obj->name = "pay_first_name";
        $obj->field_type = 'text';
        $obj->required = true;
        $jsonData[] = $obj;

        $obj = new stdClass();
        $obj->name = "pay_last_name";
        $obj->label = 'PLG_MARKETINGROCKET_LAST_NAME';
        $obj->field_type = 'text';
        $obj->required = true;
        $jsonData[] = $obj;

        $obj = new stdClass();
        $obj->label = 'PLG_MARKETINGROCKET_CREDIT_CARD_TYPE';
        $obj->name = "pay_creditcard_type";
        $obj->field_type = 'list';
        $obj->required = true;
        $obj->field_options = new stdClass();
        $obj->field_options->options = array();

        $option = new stdClass();
        $option->value = "Visa";
        $option->label = "Visa";

        $obj->field_options->options[] = $option;

        $option = new stdClass();
        $option->value = "MasterCard";
        $option->label = "MasterCard";

        $obj->field_options->options[] = $option;

        $option = new stdClass();
        $option->value = "Discover";
        $option->label = "Discover";

        $obj->field_options->options[] = $option;

        $option = new stdClass();
        $option->value = "Amex";
        $option->label = "American Express";
        $obj->field_options->options[] = $option;

        $jsonData[] = $obj;

        $obj = new stdClass();
        $obj->name = "pay_creditcard_number";
        $obj->label = 'PLG_MARKETINGROCKET_CREDITCARD_NUMBER';
        $obj->field_type = 'text';
        $obj->required = true;
        $jsonData[] = $obj;

        $obj = new stdClass();
        $obj->name = "pay_expite_date";
        $obj->label = 'PLG_MARKETINGROCKET_EXPITE_DATE';
        $obj->field_type = 'text';
        $obj->hint = '05/2015';
        $obj->pattern="^(0[1-9]|1[0-2])\/?([0-9]{4}|[0-9]{2})$";
        $obj->required = true;
        $jsonData[] = $obj;

        $obj = new stdClass();
        $obj->name = "cvv2_number";
        $obj->label = 'PLG_MARKETINGROCKET_CARD_VERIFICATION_NUMBER';
        $obj->field_type = 'text';
        $obj->required = true;
        $jsonData[] = $obj;



        $obj = new stdClass();
        $obj->label = 'PLG_MARKETINGROCKET_BILLING_ADDRESS';
        $obj->field_type = 'section_break';
        $jsonData[] = $obj;
        
        
    }
    
    public function onValidateForm($form, $data, $type, &$ret){
        if($ret !== false && $type === 'paypalpro'){
            if(!preg_match('/^(0[1-9]|1[0-2])\/?([0-9]{4}|[0-9]{2})$/', $data['pay_expite_date'])){
                $app = JFactory::getApplication();
                $app->enqueueMessage(JText::_('PLG_MARKETINGROCKET_EXPIRE_DATE_FORMAT_IS_WRONG'), 'error');
                $ret = false;
            }
                    
        }
    }
    
    public function onBeforeCreateOrder(&$saveFormData,  $validData, &$landing, $type){
        if($type == 'paypalpro'){
            $fieldsArray = array('pay_first_name', 'pay_last_name', 'pay_creditcard_type', 'pay_creditcard_number', 'pay_expite_date', 'cvv2_number',
                    'address', 'city', 'state', 'zipcode', 'country' , 'address2', 'phone'
                );
            
            $session = JFactory::getSession();
            $sessionData = new stdClass();
            foreach($fieldsArray as $name){
                $sessionData->$name = $validData[$name];
            }
            
            $session->set('MR_payaplpr_data', $sessionData);
            
            
        }
    }
    
    public function onCreateView(&$view , $item , $order, $type){
        if($type == 'paypalpro'){
            
            $session = JFactory::getSession();
            
            $orderDetail = $session->get('MR_payaplpr_data');
            if(empty($orderDetail))
                throw new Exception('Session Is Expired', 500);
            
            require_once('merchant-sdk-php-master/PPBootStrap.php');
            
            $address = new AddressType();
            $address->Name = $orderDetail->pay_first_name.' '.$orderDetail->pay_last_name;
            $address->Street1 = $orderDetail->address;
            $address->Street2 =  $orderDetail->address2;
            $address->CityName = $orderDetail->city;
            $address->StateOrProvince = $orderDetail->state;
            $address->PostalCode = $orderDetail->zipcode;
            $address->Country = $orderDetail->country;
            $address->Phone = $orderDetail->phone;

            $paymentDetails = new PaymentDetailsType();
            $paymentDetails->ShipToAddress = $address;
            
            $paymentDetails->OrderTotal = new BasicAmountType($item->paypal_currency, $item->price);
            
            
            
            $personName = new PersonNameType();
            $personName->FirstName = $orderDetail->pay_first_name;
            $personName->LastName = $orderDetail->pay_last_name;

            //information about the payer
            $payer = new PayerInfoType();
            $payer->PayerName = $personName;
            $payer->Address = $address;
            $payer->PayerCountry = $orderDetail->country;

            $cardDetails = new CreditCardDetailsType();
            $cardDetails->CreditCardNumber = $orderDetail->pay_creditcard_number;
            
            $expDate = $orderDetail->pay_expite_date;
            $expDate = explode('/', $expDate);
            
            $cardDetails->CreditCardType = $orderDetail->pay_creditcard_type;
            $cardDetails->ExpMonth = $expDate[0];
            $cardDetails->ExpYear = $expDate[1];
            $cardDetails->CVV2 = $orderDetail->cvv2_number;
            $cardDetails->CardOwner = $payer;

            $ddReqDetails = new DoDirectPaymentRequestDetailsType();
            $ddReqDetails->CreditCard = $cardDetails;
            $ddReqDetails->PaymentDetails = $paymentDetails;
            $ddReqDetails->PaymentAction = 'Sale';

            $doDirectPaymentReq = new DoDirectPaymentReq();
            $doDirectPaymentReq->DoDirectPaymentRequest = new DoDirectPaymentRequestType($ddReqDetails);
            
            require_once JPATH_COMPONENT.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'api.php';
            $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
            
            $apiDetail = $apiModel->getItem($item->paypal_account);
            
            $mode = ($apiDetail->use_sandbox == 1) ? 'sandbox' : 'live';
            
            $config = array(
                "mode" => $mode,
                'log.LogEnabled' => false,
                'log.FileName' => '../PayPal.log',
                'log.LogLevel' => 'FINE',
                "acct1.UserName" => $apiDetail->username,
                "acct1.Password" => $apiDetail->password,
                "acct1.Signature" => $apiDetail->signature,
            );
            
            
            $paypalService = new PayPalAPIInterfaceServiceService($config);
            try {
                    /* wrap API method calls on the service object with a try catch */
                    $doDirectPaymentResponse = $paypalService->DoDirectPayment($doDirectPaymentReq);
            } catch (Exception $ex) {
                    throw $ex;
                    exit;
            }
            
            $ack = strtoupper($doDirectPaymentResponse->Ack);
            require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'payment.php';
            require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables'.DIRECTORY_SEPARATOR.'payment.php';
            $paymentModel = JModelLegacy::getInstance('Payment', 'MarketingrocketModel');
            $dataStore = new stdClass();
            $dataStore->cardType = $orderDetail->pay_creditcard_type;
            $dataStore->lastPartCardNumber = substr($orderDetail->pay_creditcard_number, strlen($orderDetail->pay_creditcard_number)-4);
            
            $dataStore->response = $doDirectPaymentResponse;
            
            if(empty($doDirectPaymentResponse->TransactionID))
            {
                
                $dataStore->CORRELATIONID = $view->CORRELATIONID = $doDirectPaymentResponse->CorrelationID;
                $dataStore->ACK = $view->ACK = $doDirectPaymentResponse->Ack;

                $view->addTemplatePath( JPATH_PLUGINS.'/marketingrocket/paypalpro/tmpl' );

                $view->templates[] = 'payapalpro';
                
                $paymentModel->updateParams($order->id, $dataStore);
                
                $session->clear('MR_payaplpr_data');
            }
            else {
                
                $dataStore->ACK = $doDirectPaymentResponse->Ack;
                $dataStore->CORRELATIONID = $doDirectPaymentResponse->TransactionID;
                $paymentModel = JModelLegacy::getInstance('Payment', 'MarketingrocketModel');
                
                $paymentModel->updateParams($order->id, $dataStore);
                
                $session->clear('MR_payaplpr_data');
                JFactory::getApplication()->redirect(JRoute::_(
                    'index.php?option=com_marketingrocket&task=payment.ipn&order_id='.$order->id.'&ref='.$order->ref_code , false
                ));
            }
            
        }
    }
    
    public function onIpnCall($item, $order , $type, &$isValid, &$email , &$data){
        if($type == 'paypalpro'){
            $params = json_decode($order->params);
            if(!empty($params->ACK)){
                $isValid = true;
            }
            else 
                $isValid = false;
        }
        
    }
    
    public function onPaymentComplete($item, $order,$type){
        if($type == 'paypalpro'){
            JFactory::getApplication()->redirect(JRoute::_(
                'index.php?option=com_marketingrocket&task=payment.success&order_id='.$order->id.'&ref='.$order->ref_code , false
            ));
        }
    }
    
    public function onLandingFormValidate(&$ret, $form, &$data){
        if($data['have_paypal'] == 1){
            $id = $data['paypal_account'];
            $apiTable = JTable::getInstance('Api', 'MarketingrocketTable');
            $apiTable->load($id);
            if($apiTable->type == 'paypalpro'){
                if(!in_array($data['paypal_currency'], array('USD', 'GBP', 'CAD', 'EUR', 'JPY'))){
                    JFactory::getApplication()->enqueueMessage(JTEXT::_('PLG_MARKETINGROCKET_SUPPORTED_CURRENCIES'), 'error');
                    $ret = false;
                }
            }
        }
    }
}

