<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

use PayPal\CoreComponentTypes\BasicAmountType;
use PayPal\EBLBaseComponents\AddressType;
use PayPal\EBLBaseComponents\BillingAgreementDetailsType;
use PayPal\EBLBaseComponents\PaymentDetailsItemType;
use PayPal\EBLBaseComponents\PaymentDetailsType;
use PayPal\EBLBaseComponents\SetExpressCheckoutRequestDetailsType;
use PayPal\PayPalAPI\SetExpressCheckoutReq;
use PayPal\PayPalAPI\SetExpressCheckoutRequestType;
use PayPal\Service\PayPalAPIInterfaceServiceService;

use PayPal\PayPalAPI\GetExpressCheckoutDetailsReq;
use PayPal\PayPalAPI\GetExpressCheckoutDetailsRequestType;

use PayPal\EBLBaseComponents\DoExpressCheckoutPaymentRequestDetailsType;
use PayPal\PayPalAPI\DoExpressCheckoutPaymentReq;
use PayPal\PayPalAPI\DoExpressCheckoutPaymentRequestType;

class plgMarketingrocketPaypalexpress extends JPlugin
{

    protected $autoloadLanguage = true;

    public function onBeforeFormLoad(&$type)
    {
        if ($type == 'paypalexpress')
            JForm::addFormPath(JPATH_PLUGINS . '/marketingrocket/paypalexpress/form');

    }
    public function onCreateView(&$view , $item , $order, $type)
    {
        if ($type == 'paypalexpress') {

            JModelLegacy::addIncludePath(JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models');
            $leadModel = JModelLegacy::getInstance('Lead', 'MarketingrocketModel', array('ignore_request' => true));

            require_once 'PPBootStrap.php';
            require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';

            $baseUrl = MRRoute::createFrontRoute('index.php?option=com_marketingrocket');

            $returnUrl = $baseUrl.'&task=payment.ipn&ref='.$order->ref_code.'&order='.$order->id;
            $cancelUrl = $baseUrl.'&task=payment.cancel&ref='.$order->ref_code.'&order='.$order->id;
            $currencyCode = $item->paypal_currency;

            $address = new AddressType();

            $leadInfo = $leadModel->getLeadByRefCode($order->ref_code);
            $address->Name = $leadInfo->first_name;

            $formData = unserialize($leadInfo->form_data);
            if(!empty($formData[0]['address'])){
                $address->CityName = $formData[0]['city'];
                $address->Street1 = $formData[0]['address'];
                $address->StateOrProvince = $formData[0]['state'];
                $address->PostalCode = $formData[0]['zip'];
                $address->Country = $formData[0]['country'];
            }

            $paymentDetails = new PaymentDetailsType();


            $itemAmount = new BasicAmountType($currencyCode, $order->price);
            $itemDetails = new PaymentDetailsItemType();
            $itemDetails->Name = $item->paypal_product_name;
            $itemDetails->Description = $item->paypal_product_name;
            $itemDetails->Amount = $itemAmount;
            $itemDetails->Quantity = 1;


            $paymentDetails->PaymentDetailsItem[] = $itemDetails;
			
			$paymentDetails->OrderDescription = $item->paypal_product_name;

            $paymentDetails->ItemTotal = new BasicAmountType($currencyCode, $order->price);
            $paymentDetails->TaxTotal = new BasicAmountType($currencyCode, 0);
            $paymentDetails->OrderTotal = new BasicAmountType($currencyCode, $order->price);

            $setECReqDetails = new SetExpressCheckoutRequestDetailsType();
            $setECReqDetails->PaymentDetails[0] = $paymentDetails;

            $setECReqDetails->CancelURL = $cancelUrl;

            $setECReqDetails->ReturnURL = $returnUrl;
            $setECReqDetails->NoShipping = true;
            $setECReqDetails->AllowNote = 0;

            $setECReqType = new SetExpressCheckoutRequestType();
            $setECReqType->SetExpressCheckoutRequestDetails = $setECReqDetails;
            $setECReq = new SetExpressCheckoutReq();
            $setECReq->SetExpressCheckoutRequest = $setECReqType;

            $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel', array('ignore_request' => true));
            $api = $apiModel->getItem($item->paypal_account);
            if(empty($api)){
                throw new Exception('Api Not Found', 404);
            }


            $paypalService = new PayPalAPIInterfaceServiceService(array(
                "mode" => ($api->use_sandbox) ? 'sandbox' : 'live',
                "acct1.UserName" => $api->username,
                "acct1.Password" => $api->password,
                "acct1.Signature" => $api->signature,
            ));
            $setECResponse = $paypalService->SetExpressCheckout($setECReq);
            if(isset($setECResponse)) {
                if($setECResponse->Ack =='Success') {
                    $token = $setECResponse->Token;
                    $url = 'https://www.paypal.com/webscr?cmd=_express-checkout&token=' . $token;
                    if ($api->use_sandbox == 1) {
                        $url = 'https://www.sandbox.paypal.com/webscr?cmd=_express-checkout&token=' . $token;
                    }
                    $payPalURL = $url;

                    $view->payUrl = $payPalURL;

                    $view->addTemplatePath(JPATH_PLUGINS . '/marketingrocket/paypalexpress/tmpl');
                    $view->templates[] = 'paypalexpress';
                    return;
                }
            }
            throw new Exception('Error There is A problem !');
        }
    }

    public function onIpnCall($item, $order , $type, &$isValid, &$email , &$data){
        if($type == 'paypalexpress'){

            $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel', array('ignore_request' => true));
            $api = $apiModel->getItem($item->paypal_account);
            if(empty($api)){
                throw new Exception('Api Not Found', 404);
            }

            require_once JPATH_COMPONENT_SITE.DS.'tables'.DS.'payment.php';
            $orderRow = JTable::getInstance('Payment','MarketingrocketTable');
            $orderRow->load($order->id);
            if(empty($orderRow->id) || $orderRow->status != '0')
            {
                $isValid = false;
                return;
            }

            require_once 'PPBootStrap.php';
            $token =urlencode( $_REQUEST['token']);
            $payerId=urlencode(  $_REQUEST['PayerID']);

            $paymentAction = urlencode(  $_REQUEST['paymentAction']);
            $getExpressCheckoutDetailsRequest = new GetExpressCheckoutDetailsRequestType($token);

            $getExpressCheckoutReq = new GetExpressCheckoutDetailsReq();
            $getExpressCheckoutReq->GetExpressCheckoutDetailsRequest = $getExpressCheckoutDetailsRequest;
            /*
            Configuration::getAcctAndConfig() returns array that contains credential and config parameters
            */
            $paypalService = new PayPalAPIInterfaceServiceService(array(
                "mode" => ($api->use_sandbox) ? 'sandbox' : 'live',
                "acct1.UserName" => $api->username,
                "acct1.Password" => $api->password,
                "acct1.Signature" => $api->signature,
            ));


            $paypalService = new PayPalAPIInterfaceServiceService($paypalService);
            try {
                /* wrap API method calls on the service object with a try catch */
                $getECResponse = $paypalService->GetExpressCheckoutDetails($getExpressCheckoutReq);
            } catch (Exception $ex) {

                throw $ex;
            }
            /*
 * The total cost of the transaction to the buyer. If shipping cost (not applicable to digital goods) and tax charges are known, include them in this value. If not, this value should be the current sub-total of the order. If the transaction includes one or more one-time purchases, this field must be equal to the sum of the purchases. Set this field to 0 if the transaction does not include a one-time purchase such as when you set up a billing agreement for a recurring payment that is not immediately charged. When the field is set to 0, purchase-specific fields are ignored.
*/
            $orderTotal = new BasicAmountType();
            $orderTotal->currencyID = $item->paypal_currency;
            $orderTotal->value = $order->price;
            $paymentDetails= new PaymentDetailsType();
            $paymentDetails->OrderTotal = $orderTotal;
            /*
             * Your URL for receiving Instant Payment Notification (IPN) about this transaction. If you do not specify this value in the request, the notification URL from your Merchant Profile is used, if one exists.
             */
            if(isset($_REQUEST['notifyURL']))
            {
                $paymentDetails->NotifyURL = $_REQUEST['notifyURL'];
            }
            $DoECRequestDetails = new DoExpressCheckoutPaymentRequestDetailsType();
            $DoECRequestDetails->PayerID = $payerId;
            $DoECRequestDetails->Token = $token;
            $DoECRequestDetails->PaymentAction = $paymentAction;
            $DoECRequestDetails->PaymentDetails[0] = $paymentDetails;
            $DoECRequest = new DoExpressCheckoutPaymentRequestType();
            $DoECRequest->DoExpressCheckoutPaymentRequestDetails = $DoECRequestDetails;
            $DoECReq = new DoExpressCheckoutPaymentReq();
            $DoECReq->DoExpressCheckoutPaymentRequest = $DoECRequest;
            try {
                /* wrap API method calls on the service object with a try catch */
                $DoECResponse = $paypalService->DoExpressCheckoutPayment($DoECReq);
            } catch (Exception $ex) {
                throw $ex;
            }
            if(isset($DoECResponse)) {


                if(strtolower($DoECResponse->Ack) == 'success' || "SUCCESSWITHWARNING" == strtoupper($DoECResponse->ACK)){
                    $isValid = true;
                    $param = array(
                        'token' => $DoECResponse->DoExpressCheckoutPaymentResponseDetails->Token,
                        'PayerID' => $payerId,
                    );
                    if(isset($DoECResponse->DoExpressCheckoutPaymentResponseDetails->PaymentInfo)) {
                        $param['TransactionID'] = $DoECResponse->DoExpressCheckoutPaymentResponseDetails->PaymentInfo[0]->TransactionID;
                    }

                    $orderRow->params = json_encode($param);
                    $orderRow->store();
                    return;
                }
                else {
                    $orderRow->status = $getECResponse->Ack;
                    if($orderRow->status == 0)
                        $orderRow->status = -1;
                    $param = array('token' => $getECResponse->DoExpressCheckoutPaymentResponseDetails->Token);
                    $orderRow->params = json_encode($param);
                    $orderRow->store();
                    $isValid = false;
                    return;
                }
            }

            $isValid = false;
            return;




        }
    }
    public function onPaymentComplete($item, $order,$type){
        if($type == 'paypalexpress'){
            if($order->status == 1){
                JFactory::getApplication()->redirect(JRoute::_(
                    'index.php?option=com_marketingrocket&task=payment.success&order_id='.$order->id.'&ref='.$order->ref_code , false
                ));
            }
            else {
                JFactory::getApplication()->redirect(JRoute::_(
                    'index.php?option=com_marketingrocket&task=payment.cancel&order_id='.$order->id.'&ref='.$order->ref_code , false
                ));
            }

        }
    }

}

