<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketPaypal extends JPlugin
{
    
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'paypal')
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/paypal/form');
         
    }
    
    public function onCreateView(&$view , $item , $order, $type){
        if($type == 'paypal'){
            JModelLegacy::addIncludePath(JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models');
            $model = JModelLegacy::getInstance('Landing', 'MarketingrocketModel', array('ignore_request' => true));
            $leadModel = JModelLegacy::getInstance('Lead', 'MarketingrocketModel', array('ignore_request' => true));
            
            require_once JPATH_PLUGINS.'/marketingrocket/paypal/paypal.class.php';
            JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models');
            
            $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel', array('ignore_request' => true));
            $api = $apiModel->getItem($item->paypal_account);
            if(empty($api)){
                throw new Exception('Api Not Found', 404);
            }
            
            $p = new paypal_class;             // initiate an instance of the class
            if($api->use_sandbox == 1){
                 $p->paypal_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';   // testing paypal url
            }
            else {
                 $p->paypal_url = 'https://www.paypal.com/cgi-bin/webscr';   // testing paypal url
            }
            
            require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';
            $baseUrl = MRRoute::createFrontRoute('index.php?option=com_marketingrocket');
            
//            $p->add_field('cmd', '_xclick');
//            $p->add_field('redirect_cmd', '_cart');
            $p->add_field('business', $api->api);
//            $p->add_field('receiver_email', $api->api);
//            $p->add_field('test_ipn', 0);
            
//            $p->add_field('undefined_quantity', 0);
            
            
//            $p->add_field('invoice', $order->id);
            
            $p->add_field('return', $baseUrl.'&task=payment.success&ref='.$order->ref_code.'&order='.$order->id);
            $p->add_field('cancel_return', $baseUrl.'&task=payment.cancel&ref='.$order->ref_code.'&order='.$order->id);
            $p->add_field('notify_url', $baseUrl.'&task=payment.ipn&ref='.$order->ref_code.'&order='.$order->id);
            
            $p->add_field('item_name', $item->paypal_product_name);
            $p->add_field('amount', $order->price);
            
            
            
            


            $leadInfo = $leadModel->getLeadByRefCode($order->ref_code);

            $formData = unserialize($leadInfo->form_data);
            if(!empty($formData[0]['address'])){
                @$p->add_field('address1', $formData[0]['address']);
                @$p->add_field('zip', $formData[0]['zip']);
                @$p->add_field('city', $formData[0]['city']);
                @$p->add_field('state', $formData[0]['state']);
                @$p->add_field('country', $formData[0]['country']);
            }

            $p->add_field('currency_code', $item->paypal_currency);
            $p->add_field('no_shipping', 1);
            $p->add_field('no_note', 1);

            $symbols = array(
                'AUD' => '$',
                'BRL' => 'R$',
                'CAD' => '$',
                'EUR' => '€',
                'GBP' => '£',
                'JPY' => '¥',
                'USD' => '$',
                'NZD' => '$',
                'CHF' => 'CHF',
                'HKD' => '元',
                'SGD' => '$',
                'SEK' => 'kr',
                'DKK' => 'kr',
                'PLN' => 'zł',
                'NOK' => 'kr',
                'HUF' => 'Ft',
                'CZK' => 'Kč',
                'MXN' => '$',
                'MYR' => 'RM',
                'PHP' => '₱',
                'TWD' => 'NT$',
                'THB' => '฿',
                'ILS' => '₪',
                'TRY' => 'YTL',
            );

            $view->viewForm = $p->submit_paypal_post();
//            $view->name = $orderDetail['name'];
//            $view->price = $orderDetail['price']; 
            $view->paypal_currency = $item->paypal_currency; 
            $view->currencySymbol = $symbols[$item->paypal_currency];
            
            $view->addTemplatePath( JPATH_PLUGINS.'/marketingrocket/paypal/tmpl' );
            $view->templates[] = 'payapal';
            
        }
    }
    
    public function onIpnCall($item, $order , $type, &$isValid, &$email , &$data){
        if($type == 'paypal'){
            $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel', array('ignore_request' => true));
            $api = $apiModel->getItem($item->paypal_account);
            if(empty($api)){
                throw new Exception('Api Not Found', 404);
            }

            require_once JPATH_PLUGINS.'/marketingrocket/paypal/paypal.class.php';
            $p = new paypal_class;             // initiate an instance of the class
//            $p->ipn_log = true;
            if($api->use_sandbox == 1){
                 $p->paypal_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';   // testing paypal url
            }
            else {
                 $p->paypal_url = 'https://www.paypal.com/cgi-bin/webscr';   // testing paypal url
            }
            $paypal = $api->api;
            if($p->validate_ipn() && $_POST['business'] == $paypal) {
                $isValid = true;
                $email = $p->ipn_data;
                
            }
            else {
                
                $db = JFactory::getDbo();
                $q = $db->getQuery(true);
                $q->update('#__mrocket_payments')->set('status = -1')->where('id = '.$db->q($order->id));
                $db->setQuery($q);
                $db->execute();
                
                $isValid = false;
            }
            
            
        }
    }
}

