<?php

/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

class PlgMarketingrocketMandrillInstallerScript
{
	function install($parent) 
	{
            try {
                $db = JFactory::getDbo();
                $query = $db->getQuery(true);
                
                $query->delete('#__mrocket_api_types')->where($db->qn('type').' = '.$db->q('mandrill'));
                $db->setQuery($query);
                $db->execute();
                
                $query = $db->getQuery(true);
                $query->insert('#__mrocket_api_types')->set($db->qn('type').' = '.$db->q('mandrill'));
                        $query->set($db->qn('title') . ' = '.$db->q('Mandrill'));
                        $query->set($db->qn('desc') . ' = '.$db->q('Api for sending system emails through Mandrill'));
                        $query->set($db->qn('category') . ' = '.$db->q('marketing_email'));
                        $query->set($db->qn('icon') . ' = '.$db->q('<img src="../plugins/marketingrocket/mandrill/assets/mandrill.png"  />'));
                        $query->set($db->qn('plugin'). ' = '.$db->q('plg_marketingrocket_mandrill'))
                ;
                $db->setQuery($query);
                $db->execute();
                
                
                $query = $db->getQuery(true);
                $query->update('#__extensions')->set('enabled = 1')->where('name = '.$db->q('plg_marketingrocket_mandrill'));
                $db->setQuery($query);
                $db->execute();
                
                /**
                 * fix for old installation
                 */
                
                $query = $db->getQuery(true);
                $query->select('*')->from('#__mrocket_api')->where($db->qn('type').' = '.$db->q('mandrill'));
                $db->setQuery($query);
                $res = $db->loadObject();
                if(!empty($res)){
                    
                    @unlink(JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'Mindrill.class.php');
                    
                    require 'mandrill.php';
                    $dispatcher = JEventDispatcher::getInstance();
                    $api = new plgMarketingrocketMandrill($dispatcher);
                    $type = 'mandrill';
                    $api->onDeleteApi($type, $res);
                    
                    
                    $data = array('api' => $res->api);
                    $oldData = array();
                    $api->afterApiSaveForm($type, $data, $oldData, $res->id);
                }
                
                
            }
            catch(Exception $e){
                
            }
            
	}
 
	function uninstall($parent) 
	{
             try {
                $db = JFactory::getDbo();
                $query = $db->getQuery(true);
                $query->delete('#__mrocket_api_types')->where($db->qn('type').' = '.$db->q('mandrill'));

                $db->setQuery($query);
                $db->execute();
             }
             catch(Exception $e){
                
            }
            
	}
        
        function update($parent) 
	{
            $this->install($parent);
	}
}