<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;
use Joomla\Registry\Registry;
jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketMandrill extends JPlugin
{
    
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'mandrill'){
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/mandrill/form');
        }
    }
    
    public function onAfterFormLoad(&$type, &$form, $loadData){
        if($type == 'mandrill'){
            $id = JFactory::getApplication()->input->getInt('id', 0);
            $setId = JComponentHelper::getParams('com_marketingrocket')->get('send_mail_by');
            if(!empty($id) && $id == $setId){
                $form->removeField('set_default');
            }
        }
    }
    public function onApiLoadFormData(&$type, &$data){
         if($type == 'mandrill'){
            $id = JFactory::getApplication()->input->getInt('id', 0);
            $data['set_default'] = 0;
            if($id == 0){
                $data['set_default'] = 1;
            }
           
         }
    }
    public function onViewForm(&$type, &$buttons){
        if($type == 'mandrill'){
            $selectOption = JComponentHelper::getParams('com_marketingrocket')->get('send_mail_by');
            $id = JFactory::getApplication()->input->getInt('id', 0);
            if($selectOption == 0 || $id == $selectOption) // default is not set yet or this one is default
                return;
            
            $doc = JFactory::getDocument();
            
            $doc->addScript(JURI::root().'/plugins/marketingrocket/mandrill/assets/mandrill.js', 'text/javascript', true );
    
        }
    }
    
    
     
    public function onWebHookCall(&$type, $api){
        if($type == 'mandrill'){
            $postData = json_decode($_POST['mandrill_events']);
            if(!empty($postData)){
                $postData = $postData[0];
                
                JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables');
                $leadCrons = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
                $leadCrons->load(array('ref' => $postData->msg->tags[0]));

                if(!empty($leadCrons->id)){
                    $leadCrons->is_show = 1;
                    if($postData->event == 'click')
                    {
                        $leadCrons->is_clicked = 1;
                    }
                    $leadCrons->store();
                }
            }
        }
    }
    
    public function sendEmail(&$type, $api, $body, $subject, $fromEmail, $fromName, $emails, $ref, $row, $attachments, &$res){
        if($type == 'mandrill'){
            require_once JPATH_PLUGINS.DIRECTORY_SEPARATOR.'marketingrocket'.DIRECTORY_SEPARATOR.'mandrill'.DIRECTORY_SEPARATOR.'Mindrill.class.php';
            
            $mandrill = new Mindrill($api->api);
            $param = array();
            $param['html'] = $body;
            $param['subject'] = $subject;
            $param['from_email'] = $fromEmail;
            $param['from_name'] = $fromName;
            $param['to'] = array();
            
            foreach ($emails as $email){
                $param['to'][] = array('email' => $email, 'type' => 'to');
            }
           

            if(!empty($row->sequence_id)){
                $param['tags'] = array($ref);
            }
            $param['attachments'] = array();
            foreach ($attachments as $attachment){
                $array = array();
                $array['name'] = $attachment->orginal_file_name;

                $array['content'] = base64_encode(file_get_contents(JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'com_marketingrocket'.
                   DIRECTORY_SEPARATOR.'attachments'.DIRECTORY_SEPARATOR.$attachment->file_name));
                $array['type'] = PHPMailer::filenameToType($attachment->orginal_file_name);

                $param['attachments'][] = $array;
           }
            
            $return = $mandrill->call('/messages/send', array('message' => $param));
            if(!is_object($return) && !is_array($return)){
                throw new Exception('Mandrill Send Error'.$return, 500);
            }
        }
    }
    
    public function afterApiSaveForm(&$type, $data, $oldData, $id){
        if($type == 'mandrill'){
            
            
            if(!empty($data['set_default'])){
                $params = JComponentHelper::getParams('com_marketingrocket');
                $params->set('send_mail_by', $id);

                $db = JFactory::getDBO();
                $query = $db->getQuery(true);

                // Build the query
                $query->update('#__extensions AS a');
                $query->set('a.params = ' . $db->quote((string)$params));
                $query->where('a.element = "com_marketingrocket"');

                // Execute the query
                $db->setQuery($query);
                $db->execute();
            }
            require_once JPATH_PLUGINS.DIRECTORY_SEPARATOR.'marketingrocket'.DIRECTORY_SEPARATOR.'mandrill'.DIRECTORY_SEPARATOR.'Mindrill.class.php';
            
            if(!empty($data['id'])){
                
                if($data['api'] != $oldData->api){ // delete the old one
                    $this->_deleteHook($oldData);
                }
                else { 
                    return true;
                }
            }
            
            $mandrill = new Mindrill($data['api']);
            
            
            require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';
            $url = MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=cron.getstat&id='.$id);
            
            $ret = $mandrill->call(
                    '/webhooks/add',
                    array(
                        'url' => $url ,
                        'description' => 'Marketing Rocket Stats '.$id,
                        'events' => array(
                            'open',
                            'click'
                            )
                        )
                    );
            if($ret->status == 'error'){
                throw new Exception($ret->message);
            }
        }
    }
    
    public function onDeleteApi(&$type, $item){
        if($type == 'mandrill'){
            $this->_deleteHook($item);
        }
    }
    
    private function _deleteHook($api){
        require_once JPATH_PLUGINS.DIRECTORY_SEPARATOR.'marketingrocket'.DIRECTORY_SEPARATOR.'mandrill'.DIRECTORY_SEPARATOR.'Mindrill.class.php';
        try {
                   $mandrill = new Mindrill($api->api);
                   $ret = $mandrill->call(
                              '/webhooks/list'
                           );
                  foreach ($ret as $row){
                      if($row->description === 'Marketing Rocket Stats '.$api->id || $row->description === 'Marketing Rocket Stats'){ // second confition is for deleting old ones, this will call in install and will fix problem
                          $id = $row->id;
                          $mandrill->call(
                              '/webhooks/delete',
                              array('id' => $id)
                           );       
                      }
                  }
        }
        catch (Exception $e){

        }
   }
   
}

