<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;
use Joomla\Registry\Registry;
jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketMailchimp extends JPlugin
{
    
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'mail_chimp'){
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/mailchimp/form');
        }
    }
    
    public function onAfterFormLoad(&$type, &$form, $loadData){
        if($type == 'mail_chimp'){

        }
    }

    public function onGetResponders(&$type, $campaignId, $apiId, &$list){
        if($type == 'mail_chimp'){
            $model = JModelLegacy::getInstance("Api", "MarketingrocketModel");
            $item = $model->getItem($apiId);


            $server = explode('-', $item->api);
            if(count($server) == 1)
                throw new Exception('Api Is Wrong');

            $url = 'https://'.$server[1].'.api.mailchimp.com/3.0/lists?fields=lists';

            $ch = $this->getCurl($url, $item->api);

            $result = curl_exec($ch);
            if(empty($result)){
                $error = curl_error($ch);
                throw new Exception($error);
            }
            $result = json_decode($result);


            if(!isset($result->lists)){
                throw new Exception($result->title);
            }

            foreach ($result->lists as $row) {
                $list[$row->id] = $row->name;
            }
        }
    }
    public function onAddToResponder(&$type, $api, $leadEmail, $leadId, $landing){
        if($type == 'mail_chimp'){

            $server = explode('-', $api->api);
            if(count($server) == 1)
                throw new Exception('Api Is Wrong');


            $url = 'https://'.$server[1].'.api.mailchimp.com/3.0/lists/'.$landing->responder_sequence_id.'/members';

            $data = array('email_address' => $leadEmail, 'status' => 'subscribed');
            $ch = $this->getCurl($url, $api->api);

            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch,CURLOPT_POSTFIELDS, json_encode($data));


            $result = curl_exec($ch);

            if(empty($result)){
                $error = curl_error($ch);
                throw new Exception('Mail Chimp : '.$error);
            }
            $result = json_decode($result);

            if(!isset($result->id)){
                throw new Exception('Mail Chimp : '.$result->title);
            }





        }
    }
    public function onRemoveFromResponder(&$type, $api, $leadEmail, $leadId, $respinderId){
        if($type == 'mail_chimp'){

            $server = explode('-', $api->api);

            if(count($server) == 1)
                throw new Exception('Api Is Wrong');

            $email = md5(strtolower($leadEmail));
            $url = 'https://'.$server[1].'.api.mailchimp.com/3.0/lists/'.$respinderId.'/members/'.$email;

            $ch = $this->getCurl($url, $api->api);


            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");

            $result = curl_exec($ch);

//            if(empty($result)){
//                $error = curl_error($ch);
//                throw new Exception('Mail Chimp : '.$error);
//            }
//            $result = json_decode($result);
//
//            if(!isset($result->id)){
//                throw new Exception('Mail Chimp : '.$result->title);
//            }




        }
    }

    /**
     *
     * @param MarketingrocketViewLanding $item
     */
    public function onLandingEditorDisplay(&$view){

        $db = JFactory::getDbo();
        $q = $db->getQuery(true);
        $q->select('id')->from($db->qn('#__mrocket_api', 'a'))->innerJoin($db->qn('#__mrocket_api_types', 'b').' ON '.$db->qn('a.type').' = '.$db->qn('b.type'))
            ->where($db->qn('a.type').' = '.$db->q('mail_chimp'));
        $db->setQuery($q);
        $ids = $db->loadColumn();


        JFactory::getDocument()->addScriptDeclaration('
        jQuery(function($) {
            $("#jform_responder_type").change(function(){
            
                if($(this).val() == "mail_chimp"){
                    $("#jform_responder_sequence_id-lbl").text("'.JText::_("PLG_MARKETINGROCKET_MAILCHIMP_SELECT_RESPONDER", true).'")
                    .attr("data-original-title", "'.JText::_("PLG_MARKETINGROCKET_MAILCHIMP_SELECT_RESPONDER_TOOLTIP", true).'");
                    ;
                }
                else {
                    $("#jform_responder_sequence_id-lbl").text("'.JText::_("COM_MARKETINGROCKET_SEQUENCE", true).'").attr("data-original-title", "'.JText::_("COM_MARKETINGROCKET_SEQUENCE", true).'");
                }
            })
        })');
    }




    /**
     * @param String $url
     * @param String $api
     * @return resource a cURL handle on success, false on errors.
     */
    private function getCurl($url , $api){
        

        //open connection
        $ch = curl_init();

        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => "",
            CURLOPT_AUTOREFERER    => true,
            CURLOPT_CONNECTTIMEOUT => 120,
            CURLOPT_TIMEOUT        => 120,
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_USERPWD => 'MarketingRocket:'.$api,
            CURLOPT_HTTPHEADER => array(
                'user: MarketingRocket:'.$api
            )
        );

        curl_setopt_array( $ch, $options );
        return $ch;
    }
}

