<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;
use Joomla\Registry\Registry;
jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketLanding extends JPlugin
{
    
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'landing'){
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/landing/form');
            
            $id = JFactory::getApplication()->input->getInt('id',0);
            if(empty($id)){
                $res = $this->checkApiExist();
                if(!empty($res)){
                    JFactory::getApplication()->enqueueMessage(JText::_('COM_MARKETINGROCKET_ONLY_ONE_CAN_BE_USED'), 'error');
                }
            }
            
           
            
        }
    }
    
    private function checkApiExist(){
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('a.id')->from('#__mrocket_api AS a')->innerJoin('#__mrocket_api_types AS b ON a.type = b.type')
            ->where('a.type = '.$db->q('landing'))
                ;

        $db->setQuery($query);
        $res = $db->loadResult();
        
        return $res;
    }
    
    public function onApiLoadFormData(&$type, &$data){
        if($type == 'landing'){
            require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';
            $data['url'] = MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=api.webhook&plugin=landing');
        }
    }
    
    public function onApiFormValidate(&$ret, $form, &$data){
        if($data['type'] == 'landing'){
            $id = JFactory::getApplication()->input->getInt('id', 0);
            if(empty($id)){
                $res = $this->checkApiExist();
                if(!empty($res)){
                    $ret = false;
                    return;
                }
                $ret['api'] = uniqid('MR_LANDING_PUB_');
                $ret['private_key'] = uniqid('MR_LANDING_PRI_');
            }
        }
    }
    
    public function onWebhook(&$plugin){
        if($plugin == 'landing'){
            $input = JFactory::getApplication()->input;
            $action = $input->post->get('action', 'def');
                
            if($action == 'def'){
                try {

                    $laindingId = $input->getInt('landing');
                    $key = $input->getString('key');

                    require_once JPATH_COMPONENT.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'api.php';
                    $api = MarketingrocketModelApi::getApiByKey($key, 'landing');
                    if(empty($api))
                        throw new Exception('Api Not Found');

                    $refer = $_SERVER['HTTP_REFERER'];
                    $website = parse_url($refer);

//                    $domain = $website['scheme'].$website['host'];
                    $domain = $website['host']; // MR-320 wants to dont need to check scheme
                    $domain = str_replace('www.', '', $domain);
                    $allowed = true;
                    
                    $allowedWebsite = parse_url($api->websites);
//                    $allowedWebsite = $allowedWebsite['scheme'].$allowedWebsite['host'];
                    $allowedWebsite = $allowedWebsite['host']; // MR-320 wants to dont need to check scheme
                    $allowedWebsite = str_replace('www.', '', $allowedWebsite);
                    
                    
                    if($domain != $allowedWebsite){
                        $allowed = false;
                    }
                    
                    if($allowed == false){
                        throw new Exception('This WebSite Is Not Allowed');
                    }

                    $landingModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel');
                    $landingModel->getState();
                    $landingModel->setState('landing.foundby', 'id');
                    $landing = $landingModel->getItem($laindingId);

//                    $url = JUri::root();
                    require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';
                    $script = '';
                    header('Content-Type: application/javascript');
                    if($landing->form_or_cta == 'form'){
                        $formAction = MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=landing.savelead');
                        $token = JSession::getFormToken(true);

                        $script = 'jQuery(document).ready(function($){$("#token_holder").find("input").attr("name", "'.$token.'");$("#front-landing-form,#exit-landing-form").attr("action", "'.$formAction.'");$("#jform_landing_id").val('.$laindingId.')});';


                    }
                    else if($landing->form_or_cta == 'cta'){

                        $catUrl = $landingModel->returnNextStepUrl($landing, '');
                        $session =  @JSession::getInstance();
                        $session->set('cta_link', $catUrl[1], 'com_marketingrocket');
                        $session->set('landing_id', $landing->id, 'com_marketingrocket');  

                        $script = 'jQuery(document).ready(function($){window.callCta = function(){'
                                . 'canClosePage = true;
        location.href = \''.MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=redirect.cta').'\';
        return false;'
                                . '}})';
                   }

                    echo $script;
                    die;

                }
                catch (Exception $e){
                    header('Content-Type: application/javascript');
                    echo 'alert("'.JText::_($e->getMessage(), true).'")';
                    die;
                }
            }
            else if(in_array ($action, array('poplandinglist', 'landinglist', 'landinghtml', 'pophtml', 'buttonlist'))){
                try {
                    $privateKey = $input->post->getString('private_key', '');
                    if(empty($privateKey)){
                        throw new Exception('Private Key Is Required', 403);
                    }
                    
                    $key = $input->post->getString('key');

                    require_once JPATH_COMPONENT.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'api.php';
                    $api = MarketingrocketModelApi::getApiByKey($key, 'landing');
                    if(empty($api))
                        throw new Exception('Api Not Found', 403);
                    
                    if($api->private_key != $privateKey)
                        throw new Exception('Private Key Is Wrong', 403);
                    
                    
                    if($action == 'landinglist' || $action == 'poplandinglist'){
                        $db = JFactory::getDbo();
                        $q = $db->getQuery(true);

                        $q->select(array(
                                    $db->qn('a.id'),
                                    $db->qn('a.title'),
                                    $db->qn('a.campaign_id'),
                                    $db->qn('b.name', 'campaign_name')
                                ))
                                ->from($db->qn('#__mrocket_landings', 'a'))
                                ->innerJoin($db->qn('#__mrocket_campaign', 'b').' ON a.campaign_id = b.id')
                                ->where($db->qn('a.published') .' = '.$db->q('1'))
                                ->where($db->qn('a.public_accsess') .' = '.$db->q('1'))
                                ->order($db->qn('a.campaign_id').' ASC')
                        ;
                        if($action == 'poplandinglist'){
                            $q->where($db->qn('a.form_or_cta').' = '.$db->q('form'));
                        }

                        $db->setQuery($q);
                        $res = $db->loadAssocList();

                        echo new JResponseJson($res);
                    }
                    else if($action == 'landinghtml'){
                        
                         $id = $input->post->getInt('id', 0);
                         if(empty($id))
                             throw new Exception('Landing Id Is Empty');
                        
                         JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables');
                         $table = JTable::getInstance('Landing', 'MarketingrocketTable');
                         $table->load($id);
                         
                         if(empty($table->id))
                             throw new Exception('Landing Id Is Empty');
                         
                        $registry = new Registry;
                        $registry->loadObject($table);
                        $data = $registry->toArray();
                        
                        require_once JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'controllers'.DIRECTORY_SEPARATOR.'landing.php';
                        $controller = new MarketingrocketControllerLanding(array());
                        $controller->handleExportJob($table, $data);
                        
                        $data['landing_id'] = $id;
                        
                        $tempTable = JTable::getInstance('Temp', 'MarketingrocketTable');
                        $tempTable->bind($data);
                        $tempTable->store();
                        
                        $pageOptions = json_decode($tempTable->page_option, true);
                        if(is_array($pageOptions)){
                            foreach ($pageOptions as $key => $option){
                                $tempTable->$key = $option;
                            }
                        }
                       
                        
                        JModelLegacy::addIncludePath(JPATH_COMPONENT.DIRECTORY_SEPARATOR.'models');
                        $landingModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel');
                        
                        $landingModel->getState('landing.alias');
                        $landingModel->setState('landing.alias', $id);
                        $landingModel->setState('landing.foundby', 'id');
                        
                        require_once JPATH_COMPONENT.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';
                        $html = MarketingrocketFrontHelper::exportHtml($tempTable, $api->api, $landingModel);
                        echo new JResponseJson($html);
                    }
                    else if($action == 'buttonlist'){
                        
                        require_once JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'controllers'.DIRECTORY_SEPARATOR.'landing.php';
                        $controller = new MarketingrocketControllerLanding(array());
                        $controller->atags();
                    }
                    else if($action == 'pophtml'){
                         $id = $input->post->getInt('id', 0);
                         if(empty($id))
                             throw new Exception('Landing Id Is Empty');
                         
                        $css = array(
                            JURI::root().'/components/com_marketingrocket/assets/css/jquery.remodal.css',
                            JURI::root().'/components/com_marketingrocket/assets/css/style.css'
                        );
                        
                        $js = array(
                            JURI::root().'/media/system/js/core.js',
                            JURI::root().'/media/system/js/punycode.js',
                            JURI::root().'/media/system/js/validate.js',
                            JURI::root().'/components/com_marketingrocket/assets/js/countdown.js',
                            JURI::root().'/components/com_marketingrocket/assets/js/jquery.remodal.min.js',
                        );
                        
                        require_once JPATH_SITE.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'mod_marketingrocketfront'.DIRECTORY_SEPARATOR.'helper.php';
                        $params = new JObject();
                        $params->set('landing_id', $id);
                        $params->set('custom_css', 1);
                        $params->set('def', '#'.$input->post->get('button'));
                        
                        $list  = ModMarketingRocketHelper::getList($params);
                        
                        $html = $list[2];
                        
                        require_once JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'controllers'.DIRECTORY_SEPARATOR.'landing.php';
                        $controller = new MarketingrocketControllerLanding(array());
                        
                      
                        
                        $inlieCss = $list[3];
                        $inlieCss = $controller->replaceUrl($inlieCss, null, null, false);
                        
                        $inlieCss .= '#front-landing-form {
    margin: 0 0 18px;
}';
            
                        
			ob_start();

                        require JModuleHelper::getLayoutPath('mod_marketingrocketfront', $params->get('layout', 'default'));
                        
                        $html = ob_get_contents();
			ob_end_clean();
                        
                        $html = $controller->replaceSrcImages($html);
                        $html = $controller->replaceLinkUrl($html);
                        
                        require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';
                        $url = MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=api.webhook&plugin=landing&landing=landingId&key=MR_LANDING_KEY');
            
                        $url = str_replace('landingId', "'+landingId+'", $url);
                        $url = str_replace('MR_LANDING_KEY', "'+MR_LANDING_KEY", $url);
                        
                        $html .= '<script type="text/javascript">var MR_LANDING_KEY = "'.JText::_($api->api , true).'"; var landingId = '.$id.';var s = document.createElement(\'script\');'
                    . 's.setAttribute(\'src\', \''.$url.');'
                    . 'document.head.appendChild(s);</script>';
                        
                         echo new JResponseJson(array(
                             'css' => $css,
                             'js' => $js,
                             'button' => $list[0],
                             'inline_css' => $inlieCss,
                             'html' => $html,
                         ));
                        
                        die;
                    }
                    
                  
                    
                }
                catch (Exception $e){
                    echo new JResponseJson(null, $e->getCode().' '.$e->getMessage(),true);
                }
                
            }
            
        }
    }
}

