<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;
use Joomla\Registry\Registry;
jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketImageslideshow extends JPlugin
{
    
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'imageslideshow'){
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/imageslideshow/form');
        }
    }
    
    public function onLandingEditorElementsRender(&$buttons){
        if(JFactory::getApplication()->input->get('editor_type', 'landing') == 'landing')
            $buttons[] = array('type' => 'imageslideshow', 'icon' => 'fa fa-lg fa-picture-o', 'text' => JText::_('PKG_IMAGESLIDESHOW'));
    }
    
    public function onLandingEditorDisplay(&$view){
        if(JFactory::getApplication()->input->get('editor_type', 'landing') == 'landing')
            JFactory::getDocument()->addScriptVersion( JURI::root(true) . '/plugins/marketingrocket/imageslideshow/assets/imageslideshow.js', '1', "text/javascript" , true );
    }
    
    public function onLandingEditorPropertyForm($view, &$out){
        if(JFactory::getApplication()->input->get('editor_type', 'landing') == 'landing'){
            $db = JFactory::getDbo();
            $q = $db->getQuery(true);

            $q->select('*')->from($db->qn('#__mrocket_api'))
                    ->where($db->qn('type') .' = '.$db->q('imageslideshow'));
            $db->setQuery($q);
            $apis = $db->loadObjectList();

            ob_start();

            include JPATH_PLUGINS.DS.'marketingrocket'.DS.'imageslideshow'.DS.'tmpl'.DS.'form.php';
            $out .= ob_get_contents();
            ob_end_clean();
        }
        
    }
    
}

