intialize.push('imageslideshow');
MR_landing.prototype.imageslideshowDropped = function(parent, className){
    var $t = this;
    var $ = jQuery;
    
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'imageslideshow').addClass('imageslideshow complex-item').attr('id', $t.randString(6));
    
    var div = $($t.ce('div'));
    var id = $t.randString(6);
    div.attr('id', id).appendTo(box).addClass('carousel slide');
    
    $t.createCssObj(id, '');
    
    $t.inlineCss[id].styles['margin-top'] = '0px !important';
    
    $t.writeCss();
    
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-picture-o', $t.lang('Choose Api'));
    
    $t.imageslideshowFunctions(box);
    
    $t.addToParent(box, parent, className);
    $(box).find('.MR_Custom').click();
};

MR_landing.prototype.imageslideshowFunctions = function(box){
    var $t = this;
    var $ = jQuery;
    
    $(box).find('.MR_Custom').click(function(){
        $t.activeEl = $(box);
        $t.beforeShowPopUpImageslideshow();
        $t.modal('#imageslideshow-setting-template','show');
    });
};
MR_landing.prototype.beforeShowPopUpImageslideshow = function(){
    var $t = this;
    var $ = jQuery;
    
    if($t.activeEl.find('div.carousel').data('silderid'))
        $('#imageslideshow-api').val($t.activeEl.find('div.carousel').data('silderid')).chosen('destroy').chosen();
    
    if($t.activeEl.find('div.carousel').data('template'))
        $('#imageslideshow-template').val($t.activeEl.find('div.carousel').data('template')).chosen('destroy').chosen();
  
};
MR_landing.prototype.imageslideshow = function(){
    var $t = this;
    var $ = jQuery;
    
    $('#imageslideshow-api').change(function(){
        var firstDiv = $t.activeEl.find('div.carousel');
        var val = $(this).val();
        firstDiv.html('').attr('data-silderid', val);
        
        if(imageslideshow_data[val] == undefined)
            return;
        
        $t.imageslideshowCreateTemplate($('#imageslideshow-template').val(), firstDiv, val);
        
        $t.imageslideshowCreateScript(firstDiv);
        
        
    });
    
    $('#imageslideshow-template').change(function(){
       
        var firstDiv = $t.activeEl.find('div.carousel');
        var val = $(this).val();
       
        if(firstDiv.data('template') == val)
            return true;
        
        firstDiv.html('');
        
        $t.imageslideshowCreateTemplate(val, firstDiv, $('#imageslideshow-api').val());
        
        $t.imageslideshowCreateScript(firstDiv);
        
    });
    
    $('#imageslideshow_reload').click(function(){
        $('#imageslideshow-api').change();
    });
};
MR_landing.prototype.imageslideshowCreateScript = function(firstDiv){
    var $t = this;
    var $ = jQuery;
    
    if(firstDiv.find('script').length == 0){
        var script = $t.ce('script');
        var st = 'jQuery(document).ready(function(){jQuery("#'+firstDiv.attr('id')+'").carousel().on(\'slide\', function(){'+
            'var el = jQuery(this);setTimeout(function(){if(!el.parent().hasClass("imageslideshow")){el.removeAttr(\'style\').insertBefore(el.parent());el.next().remove()}},150);'+
            'var active = el.find(".item.active").index();'+
            'el.find(".carousel-indicators li.active").removeClass("active");'+
            'el.find(".carousel-indicators li").eq(active+1).addClass("active");'+
            'if(el.find(".carousel-indicators li").eq(active+1).length == 0)'+
            'el.find(".carousel-indicators li").eq(0).addClass("active");'+
        '});});';
        $(script).html(st).appendTo(firstDiv);
    }
}
MR_landing.prototype.imageslideshowCreateTemplate = function(template, firstDiv, val){ 
    var $t = this;
    var $ = jQuery;
    
     var oldClass = firstDiv.data('template');
     firstDiv.removeClass('template-'+oldClass).addClass('template-'+template).attr('data-template', template).data('template', template);
    
    if(template == 1){
        var ol = $($t.ce('ol'));
        ol.addClass('carousel-indicators').appendTo(firstDiv);

        var div = $t.ce('div');
        $(div).addClass('carousel-inner').appendTo(firstDiv);

        var arr = imageslideshow_data[val];
        for(var i = 0;i < arr.length;i++){
            var row = arr[i];
            var li = $($t.ce('li'));
            li.attr('data-slide-to', i).appendTo(ol);


            var item = $($t.ce('div'));
            item.addClass('item').appendTo(div);

            var img = $($t.ce('img'));
            img.attr('src', $t.fixImageSrc(row.image)).attr('alt', row.title).appendTo(item);

            var caption = $($t.ce('div'));
            caption.addClass('carousel-caption').appendTo(item);

            var title = $.trim(row.title);
            if(title != ''){
                var titleEl = $($t.ce('h4'));
                titleEl.text(title).appendTo(caption);
            }


            var desc = $.trim(row.desc);
            if(desc != ''){
                var desceEl = $($t.ce('p'));
                desceEl.html(desc).appendTo(caption);
            }

            if(i == 0){
                li.addClass('active');
                item.addClass('active');
            }


        }
        firstDiv.append('<a class="carousel-control left" href="'+'#'+firstDiv.attr('id')+'" data-slide="prev">&lsaquo;</a>'+
        '<a class="carousel-control right" href="'+'#'+firstDiv.attr('id')+'" data-slide="next">&rsaquo;</a>');

        
    }
    else if(template == 2){
        var row = $t.ce('div');
        $(row).addClass('row-fluid haschild').appendTo(firstDiv);
        
        var firstCol = $t.ce('div');
        $(firstCol).addClass('span5 text-center carousel-inner').appendTo(row);
        
        var secondCol = $t.ce('div');
        $(secondCol).addClass('span7').appendTo(row);
        
        $t.isChildAdded = true;
        var articleBox = $t.articleboxDropped(secondCol, '');
        $(articleBox).find('.content').html('<h1>'+$('#imageslideshow-api').find('option:selected').text()+'</h1>');
        $t.isChildAdded = false;
        
        var ul = $($t.ce('ul'));
        ul.addClass('carousel-indicators').appendTo(secondCol);
        var arr = imageslideshow_data[val];
        for(var i = 0;i < arr.length;i++){
            var row = arr[i];
            var li = $($t.ce('li'));
            li.attr('data-slide-to', i).appendTo(ul);
            
            var iEl = $t.ce('i');
            $(iEl).addClass('fa fa-2x pull-left').text(i+1).appendTo(li);

            var span = $t.ce('span');
            $(span).text($.trim(row.title)).appendTo(li);
            
            var div = $t.ce('div');
            $(div).addClass('clearfix').appendTo(li);

            var item = $($t.ce('div'));
            item.addClass('item').appendTo(firstCol);

            var img = $($t.ce('img'));
            img.attr('src', $t.fixImageSrc(row.image)).attr('alt', row.title).appendTo(item);

            if(i == 0){
                li.addClass('active');
                item.addClass('active');
            }


        }
        
        
        
    }
    
   
};
