<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;
use Joomla\Registry\Registry;
jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketHikashop extends JPlugin
{
    
    protected $autoloadLanguage = true;

    public function onBeforeFormLoad(&$type){
        if($type == 'hikashop') {
            JForm::addFormPath(JPATH_PLUGINS . '/marketingrocket/hikashop/form');

            $lang = JFactory::getLanguage();
            $extension = 'com_hikashop';
            $base_dir = JPATH_SITE;
            $language_tag = JFactory::getLanguage()->getName();
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);

            if (!JComponentHelper::isInstalled('com_hikashop') || !JComponentHelper::getComponent('com_hikashop', true)->enabled)
            {
                JFactory::getApplication()->enqueueMessage('HikaShop Component Is Not Found Or Its Disabled', 'error');
                JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&view=apilist', false));
            }



            if (!JPluginHelper::isEnabled('hikashop', 'marketingrocket'))
            {
                JFactory::getApplication()->enqueueMessage('Marketing Rocket Plugin For Hikashop not installed or its disabled', 'error');
                JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&view=apilist', false));
            }
        }

    }

    public function onApiLoadFormData(&$type,&$data){
        if($type == 'hikashop'){
            $checkData = JFactory::getApplication()->getUserState('com_marketingrocket.edit.api.data', array());
            if(empty($checkData) && empty($data->id) && empty($data['id'])){
                $data['new_tag'] = 'PURCHASED: %product_name% PRODUCT NAME';
            }


        }
    }

    public function onViewForm(&$type, &$buttons){
        if($type == 'hikashop'){
            $buttons = array(
                'jform[predefined_tags][]' => array(
                    'type' => 'tag',
                ),
            );
        }
    }

    public function onApiFormValidate(&$ret, $form, &$data){
        if($data['type'] == 'hikashop'){
            $id = JFactory::getApplication()->input->getInt('id', 0);
            if(empty($id)){
                $res = $this->checkApiExist($id, $data['event']);
                if(!empty($res)){
                    $ret = false;
                    JFactory::getApplication()->enqueueMessage(JText::_('PLG_HIKASHOP_ONLY_ONE_TYPE'), 'error');
                    return;
                }
            }
        }
    }

    private function checkApiExist($id, $type){
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('a.*')->from('#__mrocket_api AS a')->innerJoin('#__mrocket_api_types AS b ON a.type = b.type')
            ->where('a.type = '.$db->q('hikashop'))
            ->where('a.id != '.$db->q($id))
        ;

        $db->setQuery($query);
        $rows = $db->loadObjectList();
        foreach ($rows as $row) {
            $registry = new Registry;
            $registry->loadString($row->params);
            $row->params = $registry->toArray();

            if(!empty($row->params)){
                foreach ($row->params as $key => $val){
                    $row->$key = $val;
                }
            }

            if($row->event == $type){
                return true;
            }
        }

        return false;
    }


}

