<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketDonate extends JPlugin
{
    
    public $api = false;
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'donate')
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/donate/form');
         
    }
    
    public function onAfterFormLoad(&$type, &$form, $loadData){
        if($type == 'donate'){
            $form->setFieldAttribute('field_label', 'default', JText::_('PLG_DONATE_VALUE'));
        }
    }
    
    public function onBeforePayemtnFormCreation(&$jsonData, $item, $type){
        if($type == 'donate'){
            
            $apiId = $item->paypal_account;
            $api = $this->getApi($apiId);
            $targetType = $this->getApiTargetType($apiId);
            
            $obj = new stdClass();
            $obj->name = "donate_value";
            $obj->label = str_replace('{%currency%}',$item->paypal_currency,$api->field_label);
            $obj->field_type = 'number';
            $obj->default = $item->price;
            $obj->required = true;
            $obj->attributes = array('min' => $api->min);
            if(!empty($api->max)){
                $obj->attributes['max'] = $api->max;
            }
            if(!empty($api->field_description)){
                $obj->attributes['description'] = $api->field_description;
            }
            
            $jsonData[] = $obj;
            
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onBeforePayemtnFormCreation', array(&$jsonData, $item, $targetType) );
            
        }
    }
    public function onValidateForm($form, $data, $type, &$ret){
        if($ret !== false && $type === 'donate'){
            $value = (float) $data['donate_value'];
            $landingId = $data['landing_id'];
            $landingModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel');
            $landing = $landingModel->getItemById($landingId);
            
            $api = $this->getApi($landing->paypal_account);
            $targetType = $this->getApiTargetType($landing->paypal_account);
            
            if($value < $api->min || (!empty($api->max) && $value > $api->max)){
                $app = JFactory::getApplication();
                $app->enqueueMessage(JText::_('PLG_DONATE_VALUE_IS_NOT_VALID'), 'error');
                $ret = false;
            }
            else {
               $dispatcher = JDispatcher::getInstance();
               $dispatcher->trigger('onValidateForm', array($form, $data, $targetType, &$ret));
                
            }
                    
        }
    }
    
    public function onBeforeCreateOrder(&$saveFormData,  $validData, &$landing, $type){
        if($type == 'donate'){
            $landing->price = $validData['donate_value'];
            
            $apiId = $landing->paypal_account;
            $targetType = $this->getApiTargetType($apiId);
            
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onBeforeCreateOrder', array(&$saveFormData,  $validData, &$landing, $targetType));
            
        }
    }
    
    public function onIpnCall($landing, $order , $type, &$isValid, &$email , &$data){
        if($type == 'donate'){
            
            $apiId = $landing->paypal_account;
            $targetType = $this->getApiTargetType($apiId);
            $api = $this->getApi($apiId);
            
            $landing->paypal_account = $api->payment_api;
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onIpnCall', array($landing, $order , $targetType, &$isValid, &$email , &$data));
            
            if($isValid){
                $api = $this->getApi($apiId);
                if(!empty($api->tag_template)){
                    $tag = str_replace('{%value%}', $order->price, $api->tag_template);
                    require_once JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables'.DIRECTORY_SEPARATOR.'tag.php';
                    $tagTable = JTable::getInstance('Tag', 'MarketingrocketTable');
                    $tagTable->load(array('title' => $tag));
                    if(empty($tagTable->id)){
                        $tagTable->title = $tag;
                        $tagTable->published = 1;
                        $tagTable->store();
                    }
                    
                    require_once JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables'.DIRECTORY_SEPARATOR.'lead.php';
                    $lead = JTable::getInstance('Lead', 'MarketingrocketTable');
                    $lead->load($order->lead_id);
                    
                    $lead->addTag($tagTable->id);
                }
            }
        }
        
    }
    
    public function onPaymentComplete($landing, $order,$type){
        if($type == 'donate'){
            $apiId = $landing->paypal_account;
            $targetType = $this->getApiTargetType($apiId);
            
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onPaymentComplete', array($landing, $order,$targetType));
        }
    }
    
    public function onLandingFormValidate(&$ret, $form, &$data){
        if($data['have_paypal'] == 1){
            $this->api = null;
           
            $id = $data['paypal_account'];
            $api = $this->getApi($id);
            
            if($api->type == 'donate'){
                $data['paypal_account'] = $api->payment_api;
                   
                $dispatcher = JDispatcher::getInstance();
                $dispatcher->trigger('onLandingFormValidate', array(&$ret, $form, &$data));
                $data['paypal_account'] = $id;
            }
        }
    }
    
    public function onCreateView(&$view , $item , $order, $type){
        if($type == 'donate'){
            $apiId = $item->paypal_account;
            $targetType = $this->getApiTargetType($apiId);
            $api = $this->getApi($apiId);
            $item->paypal_account = $api->payment_api;
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onCreateView', array(&$view , $item , $order, $targetType));
        }
    }
    
    private function getApi($apiId){
        if(!empty($this->api))
            return $this->api;
        require_once JPATH_COMPONENT_SITE.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'api.php';
        $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
        $this->api = $apiModel->getItem($apiId);
        
        return $this->api;
    }
    private function getApiTargetType($apiId){
        $api = $this->getApi($apiId);
        
        $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
        $targetType = $apiModel->getType($api->payment_api);
        if(empty($targetType))
            throw new Exception('Target Payment Plugin Not Found');
        return $targetType;
    }
}

