<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;
use Joomla\Registry\Registry;
jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketCrmapi extends JPlugin
{
    
    protected $autoloadLanguage = true;
    
    public function onBeforeFormLoad(&$type){
        if($type == 'crmapi'){
            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/crmapi/form');
            $id = JFactory::getApplication()->input->getInt('id',0);
            if(empty($id)){
                $res = $this->checkApiExist();
                if(!empty($res)){
                    JFactory::getApplication()->enqueueMessage(JText::_('COM_MARKETINGROCKET_ONLY_ONE_CAN_BE_USED'), 'error');
                }
            }
            
        }
    }
    private function checkApiExist(){
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('a.id')->from('#__mrocket_api AS a')->innerJoin('#__mrocket_api_types AS b ON a.type = b.type')
            ->where('a.type = '.$db->q('crmapi'))
                ;

        $db->setQuery($query);
        $res = $db->loadResult();
        
        return $res;
    }
    
    public function onApiFormValidate(&$ret, $form, &$data){
        if($data['type'] == 'crmapi'){
            $id = JFactory::getApplication()->input->getInt('id', 0);
            if(empty($id)){
                $ret['api'] = uniqid('MR_CRM_API_');
            }
        }
    }
    
    public function onApiLoadFormData(&$type,&$data){
        if($type == 'crmapi'){
            require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'mr_route.php';
            $data['url'] =  MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=api.webhook&plugin=crmapi');
        }
    }
    
    public function onWebhook(&$plugin){
        if($plugin == 'crmapi'){
            $query_string = file_get_contents('php://input');
            
            $input = JFactory::getApplication()->input;
            $postData = json_decode($query_string, true);
            foreach ($postData as $key => $val){
                $input->post->set($key, $val);
            }
            $action = $input->post->getString('action', 'def');
            $key = $input->post->getString('key');
            try {
                require_once JPATH_COMPONENT.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'api.php';
                $api = MarketingrocketModelApi::getApiByKey($key, 'crmapi');
                if(empty($api))
                    throw new Exception('Api Not Found');
                
                if(!empty($api->ip)){
                    if($api->ip != $_SERVER ['REMOTE_ADDR'])
                        throw new Exception('IP Is Not Allowed');
                }
                
                switch ($action){
                    case 'getCampaignsList':
                        $this->getCampaignsList();
                        break;
                    case 'getResponderSequenceList':
                        $this->getResponderSequenceList();
                        break;
                    case 'getTagsList':
                        $this->getTagsList();
                        break;
                    case 'getLeadsList' : 
                        $this->getLeadsList();
                        break;
                    case 'getLeadDetail':
                        $this->getLeadDetail();
                        break;
                    case 'addLead':
                        $this->addLead();
                        break;
                    case 'addLeadToCampaign':
                        $this->addLeadToCampaign();
                        break;
                    case 'addTagToLead':
                        $this->addTagToLead();
                        break;
                    case 'addLeadToResponderSequence':
                        $this->addLeadToResponderSequence();
                        break;
                    default :
                        throw new Exception('Action Is Not Valid');
                }
                
            }
            catch (Exception $e){
                header ( 'Content-type: application/json' );
                echo json_encode(array('error' => true , 'message' => $e->getMessage()));
                die;
            }
            
        }
    }
    
    private function _getCampaign($id){
        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables');
        $campaign = JTable::getInstance('Campaign', 'MarketingrocketTable');
        $campaign->load($id);
        if(empty($campaign->id))
            throw new Exception ('Campaign Not Found', 500);
        
        return $campaign;
        
    }
    
    private function _getSequence($id){
        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables');
        $sequence = JTable::getInstance('Sequence', 'MarketingrocketTable');
        $sequence->load($id);
        if(empty($sequence->id))
            throw new Exception ('Sequence Not Found', 500);
        
        return $sequence; 
    }
    
    
    private function getCampaignsList(){
        $db = JFactory::getDbo();
        $q = $db->getQuery(true);
        $q->select(array(
                $db->qn('id'),
                $db->qn('name')
            )
        )
        ->from($db->qn('#__mrocket_campaign'))
            ;
        $db->setQuery($q);
        $res = $db->loadObjectList();
        
        header ( 'Content-type: application/json' );
        echo json_encode(array('data' => $res));
        die;
        
    }
    
    private function getResponderSequenceList(){
        $campaignId = JFactory::getApplication()->input->post->getInt('campaign_id', 0);
        if(empty($campaignId))
            throw new Exception ('campaign_id filed is required for geting responder list', 500);
        
        $this->_getCampaign($campaignId);
        
        $db = JFactory::getDbo();
        $q = $db->getQuery(true);
        $q->select(array(
                $db->qn('id'),
                $db->qn('name')
            )
        )
        ->from($db->qn('#__mrocket_reponders_sequences'))
            ;
        $db->setQuery($q, 0 , 1000);
        $res = $db->loadObjectList();
        
        header ( 'Content-type: application/json' );
        echo json_encode(array('data' => $res));
        die;
        
    }
    private function getTagsList(){
        $db = JFactory::getDbo();
        $q = $db->getQuery(true);
        $q->select(array(
                $db->qn('id'),
                $db->qn('title'),
                $db->qn('published')
            )
        )
        ->from($db->qn('#__mrocket_tags'))
            ;
        $db->setQuery($q, 0, 2000);
        $res = $db->loadObjectList();
        
        header ( 'Content-type: application/json' );
        echo json_encode(array('data' => $res));
        die;
    }
    private function getLeadsList(){
        $db = JFactory::getDbo();
        $q = $db->getQuery(true);
        $q->select(array(
                $db->qn('id'),
                $db->qn('first_name'),
                $db->qn('last_name'),
                $db->qn('email'),
            )
        )
        ->from($db->qn('#__mrocket_leads'))
                ->where($db->qn('is_temp').' = 0')
            ;
        $db->setQuery($q, 0, 1000);
        $res = $db->loadObjectList();
        
        header ( 'Content-type: application/json' );
        echo json_encode(array('data' => $res));
        die;
    }
    private function getLeadDetail(){
        
        $lead = $this->_getLead();
        
        $data = array();
        $data['first_name'] = $lead->first_name;
        $data['last_name'] = $lead->last_name;
        $data['email'] = $lead->email;
        $data['id'] = $lead->id;
        
        $data['form_date'] = $lead->getFormData();
        header ( 'Content-type: application/json' );
        echo json_encode(array('data' => $data));
        die;
        
    }
    
    private function _getLead(){
        $leadId = JFactory::getApplication()->input->post->getInt('lead_id', 0);
        $leadEmail = JFactory::getApplication()->input->post->getHtml('email', null);
        if(empty($leadId) && empty($leadEmail)){
             throw new Exception ('Set lead_id Or email', 500);
        }
        
        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables');
        $lead = JTable::getInstance('Lead','MarketingrocketTable');
        if(!empty($leadId))
            $lead->load($leadId);
        else 
            $lead->load(array('email' => $leadEmail));
        
        if(empty($lead->id)){
            throw new Exception ('Lead Is Not Exist', 500);
        }
        
        return $lead;
    }
    
    private function addLead(){
        $postData = JFactory::getApplication()->input->post->get('data', array(), 'array');
        if(empty($postData)){
            throw new Exception ('Data Is Required', 500);
        }
        if(empty($postData['email'])){
            throw new Exception ('Email Is Required', 500);
        }
        
        require_once JPATH_COMPONENT_SITE.DIRECTORY_SEPARATOR.'libs'.DIRECTORY_SEPARATOR.'Zend'.DIRECTORY_SEPARATOR.'Validate'.DIRECTORY_SEPARATOR.'EmailAddress.php';
        try {
            if(JComponentHelper::getParams('com_marketingrocket')->get('mx_check', 1) == 1){
                $validate = new Zend_Validate_EmailAddress(array('mx' => true, 'deep' => true));
            }
            else {
                $validate = new Zend_Validate_EmailAddress(array('deep' => true));
            }
        }
        catch (Exception $e){ // maybe mx check is not available in this host
            $validate = new Zend_Validate_EmailAddress(array('deep' => true));
        } 
        $email = trim($postData['email']);
        if (!$validate->isValid($email)) {
            throw new Exception ('"'.$postData['email'].'" Is Not A Valid Email', 500);
        }
        
        
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id')->from($db->qn('#__mrocket_leads'))
                ->where('email = '.$db->q($email))->where('is_temp = 0');
        $db->setQuery($query);
        $res = $db->loadResult();
        if(!empty($res))
            throw new Exception ('Lead With Email :'.$postData['email'].' Already Exist', 500);
        
        $data = array(
            'first_name' => $postData['first_name'],
            'email' => $email,
            'published' => 1,
            'is_temp' => 0
        );

        if(!empty($postData['last_name'])){
            $data['last_name'] = $postData['last_name'];
        }
        
        JModelLegacy::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'models');
        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables');
        $model = JModelLegacy::getInstance('Lead', 'MarketingrocketModel');
        
        if($model->save($data)){
            
            unset($postData['email']);
            unset($postData['first_name']);
            unset($postData['last_name']);
            
            $lead_id =  $model->getState('lead.id');
            $table = $model->getTable();
            $table->reset();
            $table->bind(array('id' => $lead_id));
//                        
            $table->addRefCode();

            foreach ($postData as $key => $val){
                $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
                $leadDetailsTable->landing_id = 0;
                $leadDetailsTable->lead_id = $lead_id;
                $leadDetailsTable->field_name = $key;
                $leadDetailsTable->value = $val;
                $leadDetailsTable->label = $key;
                $leadDetailsTable->store();
            }

            $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
            $leadDetailsTable->landing_id = 0;
            $leadDetailsTable->lead_id = $lead_id;
            $leadDetailsTable->field_name = 'MR_form_name';
            $leadDetailsTable->value = 'Imported From Api';
            $leadDetailsTable->store();


            $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
            $leadDetailsTable->landing_id = 0;
            $leadDetailsTable->lead_id = $lead_id;
            $leadDetailsTable->field_name = 'MR_submited_date';
            $leadDetailsTable->value = JFactory::getDate()->toSql();

            $leadDetailsTable->store();
            
            header ( 'Content-type: application/json' );
            echo json_encode(array('data' => $lead_id));
            die;
        }
        else {
            throw new Exception($model->getError());
        }
    }
    
    
    private function addLeadToCampaign(){
        $lead = $this->_getLead();
        
        $campaignId = JFactory::getApplication()->input->post->getInt('campaign_id', 0);
        $this->_getCampaign($campaignId);
        
        $lead->addToCampaign($campaignId);
        
        header ( 'Content-type: application/json' );
        echo json_encode(array('data' => 1));
        die;
    }
    
    private function addTagToLead(){
        $lead = $this->_getLead();
        $tagId = JFactory::getApplication()->input->post->getInt('tag_id', 0);
        if(empty($tagId)){
             throw new Exception ('Tag Id Is Required', 500);
        }
        $campaignId = JFactory::getApplication()->input->getInt('campaign_id', 0);
        if(!empty($campaignId)){
            $this->_getCampaign($campaignId);
        }
        
        $tagTable = JTable::getInstance('Tag','MarketingrocketTable');
        $tagTable->load($tagId);
        
        if(empty($tagTable->id)){
            throw new Exception ('Tag Not Found', 500);
        }
        
        $lead->addTag($tagId, $campaignId);
        
        header ( 'Content-type: application/json' );
        echo json_encode(array('data' => 1));
        die;
        
    }
    
    private function addLeadToResponderSequence(){
        $lead = $this->_getLead();
        $sequenceId = JFactory::getApplication()->input->post->getInt('sequence_id', 0);
        
        $sequence = $this->_getSequence($sequenceId);
        
        
        require JPATH_SITE.'/components/com_marketingrocket/models/landing.php';

        $landingModel = JModelLegacy::getInstance('landing', 'MarketingrocketModel', array('ignore_request' => true));
                
        $item = new stdClass();
        $item->responder_type = 'default';
        $item->responder_sequence_id = $sequenceId;
        $landingModel->_addResponderToLead($lead->id, '', $item);
        
        header ( 'Content-type: application/json' );
        echo json_encode(array('data' => 1));
        die;
        
    }
    
    
}

