<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);
defined('JPATH_PLATFORM') or die;
require_once JPATH_PLUGINS.'/marketingrocket/bounce/IMAP/IMAP.php';
require_once JPATH_PLUGINS.'/marketingrocket/bounce/IMAP/POP3.php';
require_once JPATH_PLUGINS.'/marketingrocket/bounce/IMAP/Mail.php';
require_once JPATH_PLUGINS.'/marketingrocket/bounce/IMAP/Mail/AbstractMail.php';
require_once JPATH_PLUGINS.'/marketingrocket/bounce/IMAP/Mail/POP3Mail.php';
require_once JPATH_PLUGINS.'/marketingrocket/bounce/IMAP/Mail/IMAPMail.php';
require_once JPATH_PLUGINS.'/marketingrocket/bounce/IMAP/Contact.php';
require_once JPATH_PLUGINS.'/marketingrocket/bounce/IMAP/RowSet.php';
require_once JPATH_PLUGINS.'/marketingrocket/bounce/IMAP/Iterator/POP3Iterator.php';
require_once JPATH_PLUGINS.'/marketingrocket/bounce/IMAP/Iterator/IMAPIterator.php';
use Joomla\Registry\Registry;

jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgMarketingrocketBounce extends JPlugin
{
    
    protected $autoloadLanguage = true;

    public function onBeforeFormLoad(&$type){
        if($type == 'bounce'){

            if(!function_exists('imap_open')){
                JFactory::getApplication()->enqueueMessage('IMAP is not installed !', 'error');
            }

            JForm::addFormPath(JPATH_PLUGINS.'/marketingrocket/bounce/form');

            $api = false;
            $selectOption = JComponentHelper::getParams('com_marketingrocket')->get('send_mail_by');
            if(!empty($selectOption)){
                //require_once 'api.php';
				//require_once JPATH_COMPONENT_SITE.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'api.php';
                $paiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
                $api = $paiModel->getItem($selectOption);
            }

            if(!empty($api)){
                JFactory::getApplication()->enqueueMessage(JText::_('PLG_MARKETINGROCKET_BOUNCE_DEFAULT_WARNING'), 'error');

            }

            $id = JFactory::getApplication()->input->getInt('id',0);
            if(!empty($id)){
                JFactory::getApplication()->enqueueMessage(JText::_('PLG_MARKETINGROCKET_BOUNCE_CHANGE_WARNING'), 'error');
            }

        }
    }

    public function onCronCall(){

        require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'api.php';
        $rows = MarketingrocketModelApi::getAllInstanceOfApiType('bounce');

        require_once JPATH_COMPONENT_ADMINISTRATOR.DIRECTORY_SEPARATOR.'tables'.DIRECTORY_SEPARATOR.'api.php';


        foreach ($rows as $row){



            if(is_array($row->rules))
                foreach ($row->rules['search'] as $k => $ruleRow){
                    if(empty($ruleRow))
                        continue;
                    $readyRules[] = array(
                        'search' => $ruleRow,
                        'execute_on' => $row->rules['execute_on'][$k],
                        'action' => $row->rules['action'][$k]
                    );
                }
            else
            {
                foreach ($row->rules->search as $k => $ruleRow){
                    if(empty($ruleRow))
                        continue;
                    $readyRules[] = array(
                        'search' => $ruleRow,
                        'execute_on' => $row->rules->execute_on[$k],
                        'action' => $row->rules->action[$k]
                    );
                }
            }

            if(empty($readyRules))
                continue;

            try {
                $config = array(
                    'server' => $row->server,
                    'port' => $row->port,
                    'secure_mode' => $row->secure_mode,
                    'validate_cert' => 1,
                    'username' => $row->username,
                    'password' => $row->password,
                );
                if($row->connection == 'IMAP'){
                    $config['validate_cert'] = 0;
                    $imap = new \SilverPHP\IMAP($config);
                }
                else
                    $imap = new \SilverPHP\POP3($config);

                $lastFetchid = $startFetch = (int) $row->last_fetch_id;

                $mails = $imap->getNewMessages($lastFetchid);
                for($i = 0; $i < $mails->count();$i++){
                    $mail = $mails->getRow($i);
                    foreach ($readyRules as $readyRule){
                        if(in_array('subject', $readyRule['execute_on'])){
                            if($this->isRegex($readyRule['search']) && preg_match($readyRule['search'], $mail->getSubject()))
                            {

                                $this->applyAction($readyRule, $mail);
                                continue;
                            }
                            else if(stripos($mail->getSubject(), $readyRule['search']) !== false){
                                $this->applyAction($readyRule, $mail);
                                continue;
                            }
                        }
                        if(in_array('body', $readyRule['execute_on'])){
                            if($this->isRegex($readyRule['search']) && preg_match($readyRule['search'], $mail->getBody()))
                            {
                                $this->applyAction($readyRule, $mail);
                                continue;
                            }
                            else if(stripos($mail->getBody(), $readyRule['search']) !== false){
                                $this->applyAction($readyRule, $mail);
                                continue;
                            }
                        }
                    }
                }

                $row->last_fetch_id = $lastFetchid+$i;
                $api = JTable::getInstance('Api', 'MarketingrocketTable');
                $api->load($row->id);

                $api->params = str_replace('"last_fetch_id":"'.$startFetch.'"',
                    '"last_fetch_id":"'.$row->last_fetch_id.'"',
                    $api->params);
                $api->store();


            }
            catch (Exception $e){
                continue;
            }

        }



    }

    private function applyAction(array $rule, \SilverPHP\AbstractMail $email){
        $body = $email->getBody();
        preg_match_all('/(redirect\.counter)(&|&amp;)(ref=)([a-f0-9]{32}){1}"{1}/', $body, $matches);
        if(empty($matches) || empty($matches[4]))
            return false;
        $ref = $matches[4][0];


        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_marketingrocket'.DS.'tables');
        $leadCron = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
        $leadCron->load(array('ref' => $ref));
        if(empty($leadCron->id))
            return false;

        $lead = JTable::getInstance('Lead', 'MarketingrocketTable');
        $lead->load($leadCron->lead_id);
        if(empty($lead->id))
            return false;
        foreach ($rule['action'] as $action)
        {
            if($action == 'delete_email'){
                $email->delete();
                continue;
            }

            if(empty($lead->id)){
                continue;
            }
            if($action == 'delete_lead'){
                $lead->delete();
                continue;
            }
            if($action == 'blacklist'){
                $lead->recieve_email = 0;
                $lead->store();
                continue;
            }
            if($action == 'unsubscribe_lead'){

                $responder = JTable::getInstance('Responder', 'MarketingrocketTable');
                $responder->load($leadCron->responder_id);
                $lead->removeResponderFromLead($responder->sequence_id);
                continue;
            }
        }

    }
    private function isRegex($str0) {
        $regex = "/^\/[\s\S]+\/$/";
        return preg_match($regex, $str0);
    }
}

