<?php

/**

 * @package	HikaShop for Joomla!

 * @version	2.6.3

 * @author	hikashop.com

 * @copyright	(C) 2010-2016 HIKARI SOFTWARE. All rights reserved.

 * @license	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html

 */

defined('_JEXEC') or die('Restricted access');

?><?php
use Joomla\Registry\Registry;
class plgHikashopMarketingrocket extends JPlugin{

    function onAfterOrderCreate(&$order,&$send_email){
        return $this->onAfterOrderUpdate($order, $send_email);
    }

    function onAfterOrderUpdate(&$order,&$send_email)
    {

        $db = JFactory::getDbo();
        $q = $db->getQuery(true);

        $q->select('a.*')->from('#__mrocket_api AS a')->innerJoin('#__mrocket_api_types AS b ON a.type = b.type')
            ->where('a.type = '.$db->q("hikashop"));

        $db->setQuery($q);
        $res = $db->loadObjectList();
        $selectedRow = null;
        foreach ($res as $row){
            $registry = new Registry;
            $registry->loadString($row->params);
            $row->params = $registry->toArray();

            if(!empty($row->params)){
                foreach ($row->params as $key => $val){
                    $row->$key = $val;
                }
            }

            if($row->event == $order->order_status){
                $selectedRow = $row;
                break;
            }


        }
        if(empty($selectedRow))
            return true;

        $orderClass = hikashop_get('class.order');

        $newOrder = $orderClass->get($order->order_id);
        $orderClass->loadProducts($newOrder);

        $lang = JFactory::getLanguage();
        $extension = 'com_marketingrocket';
        $base_dir = JPATH_SITE.'/components/com_marketingrocket/';
        $language_tag = JFactory::getLanguage()->getName();
        $reload = true;
        $lang->load($extension, $base_dir, $language_tag, $reload);

        $this->addLead($newOrder, $selectedRow);


    }

    private function addLead($order, $api){

        $class = hikashop_get('class.user');
        $productClass = hikashop_get('class.product');
        if(!$class instanceof hikashopUserClass || !$productClass instanceof hikashopProductClass){
            return;
        }

        $user = $class->get($order->order_user_id);

        $email = $user->user_email;
        $name = $user->name;
        $userId = $user->user_cms_id;


        JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');
        $leadTable = JTable::getInstance('Lead', 'MarketingrocketTable');

        $leadTable->load(array('email' => $email, 'is_temp' => 0));

        if(empty($leadTable->id)){
            $leadTable->email = $email;
            if(!empty($name))
                $leadTable->first_name = $name;

            $leadTable->published = 1;
            $leadTable->is_temp = 0;

            if(!empty($userId))
                $leadTable->user_id = $userId;

            $leadTable->store();


            $leadTable->addRefCode();

            $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
            $leadDetailsTable->landing_id = 0;
            $leadDetailsTable->lead_id = $leadTable->id;
            $leadDetailsTable->field_name = 'MR_form_name';
            $leadDetailsTable->value = 'Hikashop Customer';
            $leadDetailsTable->store();

            $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
            $leadDetailsTable->landing_id = 0;
            $leadDetailsTable->lead_id = $leadTable->id;
            $leadDetailsTable->field_name = 'MR_submited_date';
            $leadDetailsTable->value = JFactory::getDate()->toSql();
            $leadDetailsTable->store();

            $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
            $leadDetailsTable->landing_id = 0;
            $leadDetailsTable->lead_id = $leadTable->id;
            $leadDetailsTable->field_name = 'email';
            $leadDetailsTable->value = $email;
            $leadDetailsTable->label = 'Email';
            $leadDetailsTable->store();

            if(!empty($name)){
                $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
                $leadDetailsTable->landing_id = 0;
                $leadDetailsTable->lead_id = $leadTable->id;
                $leadDetailsTable->field_name = 'first-name';
                $leadDetailsTable->value = $name;
                $leadDetailsTable->label = 'Name';
                $leadDetailsTable->store();
            }
        }
        if(!empty($api->predefined_tags)) {

            foreach ($api->predefined_tags as $tagId) {
                $leadTable->addTag($tagId);
            }
        }

        if(!empty($api->new_tag)){


            foreach ($order->products as $product){
                $tagName = trim($api->new_tag);
                $productName = strip_tags($product->order_product_name);
                $productName = trim($productName);
                if($api->variant_included != 1){
                    $product = $productClass->get($product->product_id);
                    if($product->product_type == 'variant'){
                        $product = $productClass->get($product->product_parent_id);
                        $productName = $product->product_name;
                    }
                }

                $tagName = str_replace('%product_name%', $productName, $tagName);

                $tagTable = JTable::getInstance('Tag', 'MarketingrocketTable');
                $tagTable->load(array('title' => $tagName));

                if(empty($tagTable->id)){
                    $tagTable->title = $tagName;
                    $tagTable->published = 1;
                    $tagTable->store();
                }

                $leadTable->addTag($tagTable->id);
            }


        }
    }



}

