<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('JPATH_PLATFORM') or die;

jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

class plgExtensionMarketingrocket extends JPlugin
{
    public function onExtensionBeforeUpdate($type , $manifest){
        if($type == 'package'){
            $xml = $manifest->asXML();
            $dom = new DOMDocument();
            $dom->loadXML($xml);
            
            $packageName = $dom->getElementsByTagName('packagename')->item(0)->nodeValue;
            if($packageName != 'marketingrocket')
                return true;
            
            $childs = $dom->getElementsByTagName('file');
             foreach ($childs as $child){
                $id =  $child->getAttribute('id');
                $client = false;
                
                if($child->hasAttribute('client'))
                    $client = $child->getAttribute('client');
                
                switch ($child->getAttribute('type')){
                    case 'template' :
                        $target = JPATH_SITE.DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.$id;
                        if(!file_exists($target)){
                            $this->extract($child->getAttribute('type'), $client, $target, $id);
                        }
                        break;
                    case 'plugin' : 
                        $group = $child->getAttribute('group');
                        $target = JPATH_SITE.DIRECTORY_SEPARATOR.'plugins'.DIRECTORY_SEPARATOR.$group.DIRECTORY_SEPARATOR.$id;
                        if(!file_exists($target) || !file_exists($target.DIRECTORY_SEPARATOR.$id.'.xml')){
                            $this->extract($child->getAttribute('type'), $client, $target, $id);
                        }
                        break;
                    case 'module' :
                        if($client == 'site')
                            $target = JPATH_SITE.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.$id;
                        else 
                            $target = JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.$id;
                        if(!file_exists($target)){
                            $this->extract($child->getAttribute('type'), $client, $target, $id);
                        }
                        break;
                }
            }
        }
    }
    
    private function extract($type, $client, $target, $id){
        $string = '<?xml version="1.0" encoding="utf-8"?>
<extension type="'.$type.'" version="3"';
        if(!empty($client)){
            $string .= ' client="'.$client.'"';
        }
	$string .= ' method="upgrade"></extension>';
        
        mkdir($target);
        $fp = fopen($target.DIRECTORY_SEPARATOR.$id.'.xml', 'w');
        fwrite($fp, $string);
        fclose($fp);
    }
}
