<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */


defined('_JEXEC') or die;
JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_marketingrocket/tables');
JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_marketingrocket/models', 'MarketingrocketModel');

abstract class ModMarketingRocketHelper
{
	public static function getList(&$params)
	{
            
            $app = JFactory::getApplication('site');
            $defId = $app->input->get('id');
            
            $app->input->set('id', $params->get('landing_id'));
            
            
            
            $model = JModelLegacy::getInstance('Landing', 'MarketingrocketModel');
            $model->setState('landing.id', $params->get('landing_id'));
            
            $defLoad = $app->input->get('load', null);
            $app->input->set('load', 'id');
            try {
                $landing = $model->getItem($params->get('landing_id'), 'id');
                $dom = new DOMDocument();
            
                $html = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
               <html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /></head><body>'.$landing->page_html.'</body></html>';

               @$dom->loadHtml($html);

               $element = $dom->getElementById(substr($params->get('def'), 1));
               if(!empty($element))
                   $element = @$dom->saveHTML($element);
               else 
                   $element = '';

               $form = $model->getForm();


               $cssObj = json_decode($landing->hidden_css);

               $css = '';
               foreach ($cssObj as $i => $cssRow){
                   if(empty($cssRow))
                       continue;
   //                if($i == substr($params->get('def'), 1)){
                       $css .= '#'.$i.' {';
                       foreach ($cssRow->styles as $s => $style){
                           $css .= $s.' : '.$style.';';
                       }
                       $css .= '}';

                       $css .= '#'.$i.':hover {';
                       foreach ($cssRow->hover as $s => $style){
                          $css .= $s.' : '.$style.';';
                       }
                       $css .= '}';

                       $css .= '#'.$i.' > i {';
                       foreach ($cssRow->iconStyle as $s => $style){
                           $css .= $s.' : '.$style.';';
                       }
                       $css .= '}';

                       $css .= '#'.$i.':hover > i {';
                       foreach ($cssRow->iconStyleHover as $s => $style){
                           $css .= $s.' : '.$style.';';
                       }
                       $css .= '}';

   //                }
               }

               if($params->get('custom_css') == 1){
                   $css .= str_replace('#MarketingRocket ', '', $landing->css);
               }

               $css .= '.form-modal-holder {
                   margin: 10px;
                 } #MR_form_submit {
                 display:inline-block}#MarketingRocket .chzn-container-single .chzn-single, #MarketingRocket .chzn-container-active.chzn-with-drop .chzn-single,
   #MR_Modal_View .chzn-container-single .chzn-single, #MR_Modal_View .chzn-container-active.chzn-with-drop .chzn-single
   {
       padding: 4px 5px 4px 8px;
       background: white;
       border: 1px solid #d5d5d5;
       box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
   }
   #MarketingRocket .chzn-container .chzn-drop, #MR_Modal_View .chzn-container .chzn-drop {
       border: 1px solid #d5d5d5;
   }
   #MarketingRocket .chzn-container-single .chzn-single div b, #MR_Modal_View .chzn-container-single .chzn-single div b {
       background-position: 0px 7px;
   }

   #MarketingRocket .chzn-container-active.chzn-with-drop .chzn-single div b, #MR_Modal_View .chzn-container-active.chzn-with-drop .chzn-single div b  {
       background-position: -18px 6px;
   }

   #MarketingRocket .chzn-container-single .chzn-single abbr, #MR_Modal_View .chzn-container-single .chzn-single abbr {
       top: 11px;
   }

   .hidden-label .control-label {
       display: none;
   }
   .hidden-label .control-label.show{
       display: block;
   }


   #MR_Modal_View label {
       font-size: inherit;
       font-weight: inherit;
       line-height: inherit;

   }
   #MR_Modal_View .form-vertical .control-label {
       text-align:inherit;
   }

   ';


                if($params->get('layout', 'default') == 'default' || $params->get('layout', 'default') == '_:default'){
                    $modal = $landing->modal_body;
                }
               else {
                   
                   $formHolder = $dom->getElementById('MR_form_holder');
                   if(empty($formHolder)){ // get from modal
                       $newDom = new DOMDocument();
            
                        $html = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                       <html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /></head><body>'.$landing->modal_body.'</body></html>';
                       @$newDom->loadHtml($html);
                       $button = $newDom->getElementById('MR_form_submit');
                       if(empty($button)){
                           return array();
                       }
                       
                       $holderDom = $newDom->createElement('div');
                       $holderDom->setAttribute('id', 'MR_form_holder');
                       
                       
                       $parent = $button->parentNode;
                       
                       $parent->insertBefore($holderDom, $button);
                       
                       $modal = @$newDom->saveHTML($parent);
                       $modal = str_replace('{placeholder}', '', $modal);
                   }
                   else {
                        $formHolder = $formHolder->parentNode;
                        $modal = $dom->saveHTML($formHolder);
                   }
               }

               $app->input->set('id', $defId);

               $app->input->set('load', $defLoad);

               return array($element, $form , $modal, $css);
            }
            catch (Exception $e){
                return array();
            }
            
            
           
	}
}
