<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewPreview extends JViewLegacy
{
	protected $item;

	protected $params;

	protected $print;

	protected $state;

	protected $user;

	public function display($tpl = null)
	{
                $this->viewType = 'preview';
            
		JFactory::getApplication()->input->setVar('tmpl', 'component');
// 		if(!JSession::checkToken( 'get' ) )
// 			return JError::raiseError(404, JText::_('COM_MARKETINGROCKET_ERROR_NOT_FOUND'));
		
		$model = JModelLegacy::getInstance('Landing', 'MarketingrocketModel', array('ignore_request' => true));
			
		$this->item  = $model->getTemp();
                
                $app = JFactory::getApplication();
                
		if(!$app->input->get->get(JComponentHelper::getParams('com_marketingrocket')->get('salt'), '', 'alnum'))
			return JError::raiseError(404, JText::_('COM_MARKETINGROCKET_ERROR_NOT_FOUND'));
                
                if(empty($this->item)){
                    $redirect = JFactory::getApplication()->input->getInt('redirect', 0);
                    if($redirect > 6)
                        return JError::raiseError(500, 'Please refresh page to try again');
                    sleep(2);
                    $id = $app->input->getInt('id');
                    $app->redirect(
                            'index.php?option=com_marketingrocket&view=preview&'
                            .JComponentHelper::getParams('com_marketingrocket')->get('salt')
                            .'=1&id='.$id.
                            '&redirect='.($redirect+1)
                            );
                }
		if($this->item->form_or_cta == 'cta'){
			$this->cta = $this->_makeCta();
		}
		else {
                    $this->form = $model->getForm();
		}
		$this->addTemplatePath( JPATH_COMPONENT.'/views/landing/tmpl' );
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
                    JError::raiseWarning(500, implode("\n", $errors));
                    return false;
		}

		$this->_prepareDocument();
		
		$this->document->addStyleDeclaration( $this->item->css );
		$this->document->addScriptDeclaration($this->item->javascript);
		
		$jsonCss = json_decode($this->item->hidden_css);
                if(empty($jsonCss))
                    $jsonCss = array();
		
		$css = '';
		
		foreach ($jsonCss as $i => $cssRow){
		    if(empty($cssRow))
		        continue;
		
		    $css .= '#'.$i.' {';
		    foreach ($cssRow->styles as $s => $style){
		        $css .= $s.' : '.$style.';';
		    }
		    $css .= '}';
		
		    $css .= '#'.$i.':hover {';
		    foreach ($cssRow->hover as $s => $style){
		        $css .= $s.' : '.$style.';';
		    }
		    $css .= '}';
		
		    $css .= '#'.$i.' > i {';
		    foreach ($cssRow->iconStyle as $s => $style){
		        $css .= $s.' : '.$style.';';
		    }
		    $css .= '}';
		     
		    $css .= '#'.$i.':hover > i {';
		    foreach ($cssRow->iconStyleHover as $s => $style){
		        $css .= $s.' : '.$style.';';
		    }
		    $css .= '}';
                    
                    if(isset($cssRow->pricetables)){
                        foreach ($cssRow->pricetables as $className => $classCssArray){
                            $css .= '#'.$i.' '.$className.' {';
                            foreach ($classCssArray as $classS => $style){
                                if($style == '')
                                    continue;
                                $css .= $classS.' : '.$style.';';
                            }
                            $css .= '}';
                        }
                    }
                    
                    if(isset($cssRow->after)){
                        $css .= '#'.$i.':after {';
                        foreach ($cssRow->after as $s => $style){
                            $css .= $s.' : '.$style.';';
                        }

                        $css .= '}';

                        $css .= '#'.$i.':before {';
                        foreach ($cssRow->before as $s => $style){
                            $css .= $s.' : '.$style.';';
                        }

                        $css .= '}';
                    }
		
		
		}
                $dom = new DOMDocument();
                $pageHtml = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
                <html xmlns="http://www.w3.org/1999/xhtml">
                <head>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                </head><body>'.$this->item->page_html.'</body></html>';
                @$dom->loadHTML($pageHtml);
    //                                    
                $finder = new DomXPath($dom);
                $classname = "pricatetable";
                $pricetables = $finder->query("//*[contains(@class, '$classname')]");
                foreach ($pricetables as $pricetable){
                    $templateId = $pricetable->getAttribute('data-template');
                    if(!empty($templateId))
                        $css .= file_get_contents(JPATH_COMPONENT_ADMINISTRATOR.DS.'views'.DS.'_common'.DS.'pricetables'.DS.'template_'.$templateId.DS.'style.css');
                }


                $this->document->addStyleDeclaration( $css );
                
                $obj = new stdClass();
                $obj->text = $this->item->page_html;
                $obj->landing = $this->item;

                $null = '';

                JLoader::import('joomla.plugin.helper');
                JPluginHelper::importPlugin('marketingrocket');
                JPluginHelper::importPlugin('system');
                JPluginHelper::importPlugin('content');
                $dispatcher = JEventDispatcher::getInstance();
                $dispatcher->trigger('onContentPrepare', array ('com_marketingrocket.landing', &$obj, &$null, &$null));
                
                
                
                JFactory::getApplication()->input->setVar('COM_MARKETINGROCKET_BODY_ID', 'test');
                
                $this->isPreview = true;

		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function _prepareDocument()
	{
		$app	= JFactory::getApplication();
		$menus	= $app->getMenu();
		$pathway = $app->getPathway();
		$title = null;

		
		if(!empty($this->item->seo_title))
		{
			$title = $this->item->seo_title;
		}
		else {
			$title = $this->item->title . ' - '. $app->getCfg('sitename');
		}
		
		
		$this->document->setTitle($title);

		$this->document->setDescription($this->item->meta_desc);


		$this->document->setMetadata('keywords', $this->item->main_keyword);
		
		if(JComponentHelper::getParams('com_marketingrocket')->get('load_bootstrap', 1)){
			$this->document->addCustomTag('<link rel="stylesheet" href="' . JURI::root(true) . '/components/com_marketingrocket/assets/css/bootstrap.min.css" type="text/css" />');
			$this->document->addCustomTag('<script type="text/javascript" src="' . JURI::base() . '/components/com_marketingrocket/assets/js/bootstrap.min.js"></script>');	
		} else {
			$this->document->addStyleSheet('/media/jui/css/bootstrap.min.css');
			JHtml::_('bootstrap.framework');
		}
		
		
		$this->document->addStyleSheet ('https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css');		
		$this->document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/style.css' );
                
                $this->document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/jquery.remodal.css' );
                $this->document->addScript(JURI::base().'/components/com_marketingrocket/assets/js/jquery.remodal.min.js' , true);
                
                $this->document->addScript(JURI::base().'/components/com_marketingrocket/assets/js/countdown.js' );
                
                $this->document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/jquery.remodal.css' );
                $this->document->addScript(JURI::base().'/components/com_marketingrocket/assets/js/jquery.remodal.min.js', 'text/javascript', true );

		
	}
	private function _makeCta(){
		return JRoute::_('index.php?option=com_marketingrocket&task=redirect.cta');
		
		$model = $this->getModel();
		$data = $model->returnNextStepUrl($this->item);
		$href=  $data[1];
		$title = $data[0];
		$ret = '<a href="'.$href.'" title="'.$title.'">';
		if($this->item->cta_type == 'image'){
			$ret .= '<img src="'.$this->item->cta_image_src.'" alt="'.$this->item->cta_image_alt.'" />';
		}
		else {
			$ret .= $this->item->cta_text;
		}
		$ret .= '</a>';
		return $ret;
	}
	
	
	
}
