
<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewPayment extends JViewLegacy
{
	protected $item;

	protected $params;

	protected $viewEl;

	protected $state;

	protected $user;

	public function display($tpl = null)
	{          
            $app = JFactory::getApplication();

            $model = JModelLegacy::getInstance('Landing', 'MarketingrocketModel', array('ignore_request' => true));

            $id =  JFactory::getApplication()->input->getInt('id', 0);

            JSession::checkToken( 'get' ) or die( 'Invalid Token' );

            $action = JFactory::getApplication()->input->getString('action', null);
            $refCode =  JFactory::getApplication()->input->getString('ref', null);
            
            if(empty($refCode))
                    die('refcode');
            
            // getLanding 
            $item = $model->getItemByRefCode($refCode);
            if(empty($item)){
                throw new Exception('Item Not Found', 404);
            }

            JPluginHelper::importPlugin('marketingrocket');
            $dispatcher = JEventDispatcher::getInstance();
            $paymentApiId = (int)$item->paypal_account;
            require_once JPATH_COMPONENT.DS.'models'.DS.'api.php';
            $this->type = $type = MarketingrocketModelApi::getType($paymentApiId);
            $paymentModel = $this->getModel();         
            
            $order = $this->order = $paymentModel->getItemByRef($refCode);

            $this->templates = array();

            $dispatcher->trigger('onCreateView', array(&$this, $item, $order, $type) );

            // Check for errors.
            if (count($errors = $this->get('Errors')))
            {
                    throw new Exception(implode("\n", $errors), 500);
                    return false;
            }
            
            $this->_prepareDocument();

            parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function _prepareDocument()
	{
		$app	= JFactory::getApplication();
        $title =   $app->getCfg('sitename');
		$this->document->setTitle($title);
	}
	
}
