<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewMessage extends JViewLegacy
{
	protected $item;

	protected $params;

	protected $print;

	protected $state;

	protected $user;

	public function display($tpl = null)
	{
		JSession::checkToken( 'get' ) or die( 'Invalid Token' );
		$app		= JFactory::getApplication();
		
		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		$dispatcher	= JEventDispatcher::getInstance();
		
		JFactory::getApplication ()->setUserState ( 'com_marketingrocket.edit.landingForm.data',array()); // clear the form
		
		$model = JModelLegacy::getInstance('Landing', 'MarketingrocketModel', array('ignore_request' => true));
		
		$id =  JFactory::getApplication()->input->getInt('id', 0);
		$this->item = $model->getItem($id, 'id');
		
// 		$this->print = $app->input->getBool('print');
		$this->state = $this->get('State');
		
		$this->user  = $user;

        $leadModel = JModelLegacy::getInstance('Lead', 'MarketingrocketModel', array('ignore_request' => true));

        $this->lead = $leadModel->getLeadByRefCode(JFactory::getApplication()->input->getString('ref'));


	
		
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		
		
		
		
		

		$this->_prepareDocument();

		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function _prepareDocument()
	{
		$app	= JFactory::getApplication();
		$menus	= $app->getMenu();
		$pathway = $app->getPathway();
		$title = null;

		
		if(!empty($this->item->seo_title))
		{
			$title = $this->item->seo_title;
		}
		else {
			$title = $this->item->title . ' - '. $app->getCfg('sitename');
		}
		

		$this->document->setTitle($title);

		$this->document->setDescription($this->item->meta_desc);


		$this->document->setMetadata('keywords', $this->item->main_keyword);
		
		
		$this->document->addStyleSheet (JURI::root() . '/components/com_marketingrocket/assets/css/font-awesome.min.css' );		
		$this->document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/style.css' );

		
	}
	
}
