<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewLanding extends JViewLegacy
{
	public $item;

	protected $params;

	protected $print;

	protected $state;

	protected $user;

	public function display($tpl = null)
	{
            $input = JFactory::getApplication()->input;
            
            $arr = MarketingrocketFrontHelper::$utmArray;
            
            $session =  @JSession::getInstance('', '');
            foreach ($arr as $row){
                if($input->getString($row, '') != ''){
                    $session->set($row, $input->getString($row, ''), 'MARKETINGROCKET_UTM');
                }
            }
            
            $refer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';
            if(!empty($refer)){
                $referringPage = parse_url( $_SERVER['HTTP_REFERER'] );
                
                $session->set('refer', $refer, 'MARKETINGROCKET_REFER');

                if ( stristr( $referringPage['host'], 'google.' ) )
                {
                    parse_str( $referringPage['query'], $queryVars );


                    if(!empty($queryVars['q'])){
                         $session->set('keyword', $queryVars['q'], 'MARKETINGROCKET_REFER');
                    }
                }

            }
            
            require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'marketingrocket.php';
// 		JFactory::getApplication()->input->setVar('tmpl', 'component');
		$app		= JFactory::getApplication();
		
		$data = JFactory::getApplication()->input->getVar ( 'jform', array (), 'post', 'array' );
		
		$model = $this->getModel();
		if(!empty($data) && !empty($data['landing_id'])){
			
		
			$this->item  = $model->getItem($data['landing_id'], 'id');
			
			$leadModel = JModelLegacy::getInstance('Lead', 'MarketingrocketModel', array('ignore_request' => true));
			$this->form = $this->get('Form');
			if(!$this->form instanceof JForm)
				return JError::raiseError(500, JText::_('ERROR'));
			JFactory::getApplication ()->setUserState ( 'com_marketingrocket.edit.landingForm.data',$data );
			if($this->form->validate($data) &&  JSession::checkToken()){
				
                            if($this->item->have_paypal == '1'){
                                $leadDetail = $model->saveLead($data, 1);
                                $app->redirect('index.php?option=com_marketingrocket&view=payment&ref='.$leadDetail['ref'].'&'.JSession::getFormToken() .'=1');
                            }
                            else {
                                $leadDetail = $model->saveLead($data);
                            }
                            $cronModel = JModelLegacy::getInstance('Cron', 'MarketingrocketModel', array('ignore_request' => true));
                            $cronModel->sendNotificationEmail($leadDetail['ref']);

                            $nextUrl =$model->returnNextStepUrl($this->item,$leadDetail['ref']);

                            $app->redirect($nextUrl[1]);

                            die();
			}
			else {
                            $errors = $this->form->getErrors ();
                            for($i = 0, $n = count ( $errors ); $i < $n && $i < 3; $i ++) {
                                if ($errors [$i] instanceof Exception) {
                                        $app->enqueueMessage ( $errors [$i]->getMessage (), 'warning' );
                                } else {
                                        $app->enqueueMessage ( $errors [$i], 'warning' );
                                }
                            }
			}
			
			
			
		}
//		else {
			$this->item  = $this->get('Item');
			
			if($this->item){
                            $ref = JFactory::getApplication()->input->getString('ref', 0);
                            $ref = $model->checkRef($ref, $this->item);
                            if(!empty($ref)){
                                $leadModel = JModelLegacy::getInstance('Lead', 'MarketingrocketModel', array('ignore_request' => true));
                                $lead = $leadModel->getLeadByRefCode($ref);
                                
                                
                                $text = JText::sprintf(
                                            'COM_MARKETINGROCKET_LOG_LANDING_VISIT',
                                            $this->item->title
                                        );
                                MarketingrocketHelper::log('landing', 'visit', $text, $lead->id, $this->item->id, '#__mrocket_landings');
                                
                                if(!empty($this->item->viewing_tag) &&  $this->item->viewing_tag != '[]') {
                                   $addingTags = json_decode($this->item->viewing_tag);

                                   foreach ($addingTags as $addingTag){
                                       $model->_addTagToLead($lead->id, $addingTag, $this->item->campaign_id);
                                   }

                                }
                            }
                            
                            $obj = new stdClass();
                            $obj->text = $this->item->page_html;
                            $obj->landing = $this->item;
                            
                            $null = '';
                            
                            JLoader::import('joomla.plugin.helper');
                            JPluginHelper::importPlugin('marketingrocket');
                            JPluginHelper::importPlugin('system');
                            JPluginHelper::importPlugin('content');
                            $dispatcher = JEventDispatcher::getInstance();
                            $dispatcher->trigger('onContentPrepare', array ('com_marketingrocket.landing', &$obj, &$null, &$null));
                            
                            
                           $this->item->page_html = $obj->text;

                            // 		$this->print = $app->input->getBool('print');
                            $this->state = $this->get('State');


                            $model = $this->getModel();
                            $model->increaseStat($this->item->id);
                            
                          
                            $this->handleItemJobs($ref);
                            
                            
			}
			else if(empty(JFactory::getApplication()->get('offline'))){
                              return JError::raiseError(404, JText::_('Not Found'));
//				$this->items = $this->get('Landings');
//				$tpl = "list";		
			}

			// Check for errors.
			if (count($errors = $this->get('Errors')))
			{
				JError::raiseWarning(500, implode("\n", $errors));
				return false;
			}
		

		
//		}
                
		parent::display($tpl);
	}
        
        public function handleItemJobs($ref = null){
            if($this->item->form_or_cta == 'cta'){
                    $this->cta = $this->_makeCta($this->item, $ref);
            }
            else if(!isset($this->form)){
                    $this->form = $this->get('Form');

            }
            JFactory::getApplication ()->setUserState ( 'com_marketingrocket.edit.landingForm.data',array() );
            $this->_prepareDocument();


            $this->document->addStyleDeclaration( $this->item->css );
            $this->document->addScriptDeclaration($this->item->javascript);

            $jsonCss = json_decode($this->item->hidden_css);
//                            Zend_Debug::dump($jsonCss);
//                            if(!is_array($jsonCss))
//                                $jsonCss = array();

            $css = '';
//            Zend_Debug::dump($jsonCss);die;
            foreach ($jsonCss as $i => $cssRow){
                if(empty($cssRow))
                    continue;
                $rowCss = '';
                $haveStyle = false;
                $rowCss .= '#'.$i.' {';
                foreach ($cssRow->styles as $s => $style){
                    $haveStyle = true;
                    $rowCss .= $s.' : '.$style.';';
                }
                $rowCss .= '}';
                if($haveStyle)
                   $css .=  $rowCss;

                $rowCss = '';
                $haveStyle = false;
                $rowCss .= '#'.$i.':hover {';
                foreach ($cssRow->hover as $s => $style){
                    $haveStyle = true;
                   $rowCss .= $s.' : '.$style.';';
                }
                $rowCss .= '}';

                if($haveStyle)
                   $css .=  $rowCss;

                $rowCss = '';
                $haveStyle = false;
                $rowCss .= '#'.$i.' > i {';
                foreach ($cssRow->iconStyle as $s => $style){
                    $haveStyle = true;
                    $rowCss .= $s.' : '.$style.';';
                }
                $rowCss .= '}';

                if($haveStyle)
                   $css .=  $rowCss;

                $rowCss = '';
                $haveStyle = false;
                $rowCss .= '#'.$i.':hover > i {';
                foreach ($cssRow->iconStyleHover as $s => $style){
                    $haveStyle = true;
                    $rowCss .= $s.' : '.$style.';';
                }
                
                $rowCss .= '}';
                 if($haveStyle)
                   $css .=  $rowCss;
                
                $haveStyle = false; 
                $rowCss = '';
                if(isset($cssRow->pricetables)){
                    foreach ($cssRow->pricetables as $className => $classCssArray){
                        $rowCss .= '#'.$i.' '.$className.' {';
                        foreach ($classCssArray as $classS => $style){
                            if($style == '')
                                continue;
                            $haveStyle = true;
                            $rowCss .= $classS.' : '.$style.';';
                        }
                        $rowCss .= '}';
                    }
                }
                
                if($haveStyle)
                   $css .=  $rowCss;
                if(isset($cssRow->after)){
                    $rowCss = '';
                    $haveStyle = false;
                    $rowCss .= '#'.$i.':after {';
                    foreach ($cssRow->after as $s => $style){
                        $haveStyle = true;
                        $rowCss .= $s.' : '.$style.';';
                    }

                    $rowCss .= '}';
                     if($haveStyle)
                       $css .=  $rowCss;

                    $rowCss = '';
                    $haveStyle = false;
                    $rowCss .= '#'.$i.':before {';
                    foreach ($cssRow->before as $s => $style){
                        $haveStyle = true;
                        $rowCss .= $s.' : '.$style.';';
                    }

                    $rowCss .= '}';
                     if($haveStyle)
                       $css .=  $rowCss;
                }
                


            }
            
            
            
            
            $dom = new DOMDocument();

            $pageHtml = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head><body>'.$this->item->page_html.'</body></html>';
            @$dom->loadHTML($pageHtml);
            $this->dom = $dom;
//                                    
            $finder = new DomXPath($dom);
            $classname = "pricatetable";
            $pricetables = $finder->query("//*[contains(@class, '$classname')]");
            foreach ($pricetables as $pricetable){
                $templateId = $pricetable->getAttribute('data-template');
                if(!empty($templateId))
                    $css .= file_get_contents(JPATH_COMPONENT_ADMINISTRATOR.DS.'views'.DS.'_common'.DS.'pricetables'.DS.'template_'.$templateId.DS.'style.css');
            }
            
            
            $this->document->addStyleDeclaration( $css );
            
            $firstDiv = $dom->getElementById('MarketingRocket');

            $children =  $firstDiv->getElementsByTagName('div')->item(0);
            $id =  $children->getAttribute('id');
            $children->setAttribute('id', '');

            $this->item->page_html = $dom->saveHTML($firstDiv);
//                                    echo $firstDiv->nodeValue;
//                                    die;
            
            JFactory::getApplication()->input->set('COM_MARKETINGROCKET_BODY_ID', $id);
            $session = JFactory::getSession();
            $session->set('landing_id', $this->item->id, 'com_marketingrocket');
            if(!empty($this->item->body_code)){
                $session->set('body_code_'.$this->item->id, $this->item->body_code, 'com_marketingrocket');
            }
            else
                $session->set('body_code_'.$this->item->id, '', 'com_marketingrocket');
            
            
            
            
            if(!empty($this->item->page_option)){
                $options = json_decode($this->item->page_option);
                if(!empty($options->header_code))
                    $this->document->addCustomTag($options->header_code);

                if(!empty($options->no_index))
                    $this->document->addCustomTag('<meta name="robots" content="noindex, nofollow">');


            }
        }

	/**
	 * Prepares the document
	 */
	public function _prepareDocument()
	{
		$app	= JFactory::getApplication();
		$menus	= $app->getMenu();
		$pathway = $app->getPathway();
		$title = null;
                JHtml::_('jquery.framework');
		
		if(!empty($this->item->seo_title))
		{
			$title = $this->item->seo_title;
		}
		else {
			$title = $this->item->title . ' - '. $app->getCfg('sitename');
		}
		
		
		$this->document->setTitle($title);

		$this->document->setDescription($this->item->meta_desc);


		$this->document->setMetadata('keywords', $this->item->main_keyword);
		
		if(JComponentHelper::getParams('com_marketingrocket')->get('load_bootstrap', 1)){
			$this->document->addCustomTag('<link rel="stylesheet" href="' . JURI::root(true) . '/components/com_marketingrocket/assets/css/bootstrap.min.css" type="text/css" />');
			$this->document->addCustomTag('<script type="text/javascript" src="' . JURI::base() . '/components/com_marketingrocket/assets/js/bootstrap.min.js"></script>');
		} else {
            $this->document->addStyleSheet('/media/jui/css/bootstrap.min.css');
            JHtml::_('bootstrap.framework');
        }
                
                $landingOptions = json_decode($this->item->page_option);
                
                if(!empty($landingOptions->load_fonts)){
                    $fontString = '';
                    $sep = '';
                    $fontWeights = implode(',', $landingOptions->font_weights);
                    foreach ($landingOptions->load_fonts as $font){
                        if(strpos($font, 'google-') === false)
                            continue;
                        $font = preg_replace('/\w+-{1}/', '', $font);
                        $font = str_replace(' ', '+', $font);
                        $fontString .= $sep.$font;
                        if ($fontWeights != '') {
                            $fontString .= ':'.$fontWeights;
                        }
                        $sep = '|';
                        
                    }
                    if(!empty($fontString))
                        $this->document->addStyleSheet ('https://fonts.googleapis.com/css?family='.$fontString);
                    
                }
		
		
		$this->document->addStyleSheet ('https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css');
                
                require_once JPATH_COMPONENT_ADMINISTRATOR.'/helpers/marketingrocket.php';
                $versionNumber = MarketingrocketHelper::getVersion();
                
		$this->document->addStyleSheetVersion (JURI::base().'/components/com_marketingrocket/assets/css/style.css', $versionNumber );
                $this->document->addStyleSheetVersion (JURI::base().'/components/com_marketingrocket/assets/css/animate.css', $versionNumber );
                
                $this->document->addScript(JURI::base().'/components/com_marketingrocket/assets/js/countdown.js' );
		
		$this->document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/jquery.remodal.css' );
                $this->document->addScript(JURI::base().'/components/com_marketingrocket/assets/js/jquery.remodal.min.js', 'text/javascript', true );
                
                $this->document->addScript(JURI::base().'/components/com_marketingrocket/assets/js/bioep.js', 'text/javascript', true );
                
		
	}
        /**
         * this will return just the url in next version , as our system is work different now, its also set session for url
         * @return string
         */
	private function _makeCta($landing, $ref){
            
                $model = $this->getModel();
                $url = $model->returnNextStepUrl($landing, $ref);
                $session =  @JSession::getInstance('', '');
                $session->set('cta_link', $url[1], 'com_marketingrocket');
                $session->set('landing_id', $landing->id, 'com_marketingrocket');
                return JRoute::_('index.php?option=com_marketingrocket&task=redirect.cta');
	}
	
	public function prepareMenu($item){
		$app = JFactory::getApplication();
		$item->flink = $item->link;
		switch ($item->type)
		{
			case 'separator':
			case 'heading':
				// No further action needed.
				continue;
		
			case 'url':
				if ((strpos($item->link, 'index.php?') === 0) && (strpos($item->link, 'Itemid=') === false))
				{
					// If this is an internal Joomla link, ensure the Itemid is set.
					$item->flink = $item->link . '&Itemid=' . $item->id;
				}
				break;
		
			case 'alias':
				// If this is an alias use the item id stored in the parameters to make the link.
				$item->flink = 'index.php?Itemid=' . $item->params->get('aliasoptions');
				break;
		
			default:
				$router = $app::getRouter();
		
				if ($router->getMode() == JROUTER_MODE_SEF)
				{
					$item->flink = 'index.php?Itemid=' . $item->id;
				}
				else
				{
					$item->flink .= '&Itemid=' . $item->id;
				}
				break;
		}
			
		if (strcasecmp(substr($item->flink, 0, 4), 'http') && (strpos($item->flink, 'index.php?') !== false))
		{
		
		
			$item->flink = JRoute::_($item->flink, true, $item->params->get('secure'));
		
		}
		else
		{
			$item->flink = JRoute::_($item->flink);
		}
		return $item->flink;
		
	}
	
}
