<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketTableLanding extends JTable
{
	/**
	 * Constructor
	 *
	 * @param JDatabaseDriver A database connector object
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__mrocket_landings', 'id', $db);
	}



	/**
	 *
	 */
	public function store($updateNulls = false)
	{
		$date	= JFactory::getDate();
		$user	= JFactory::getUser();

		if ($this->id) {
			// Existing item
			$this->modified	= $date->toSql();
			$this->modified_by	= $user->get('id');

		} else {
			// so we don't touch either of these if they are set.
			if (!intval($this->created)) {
				$this->created = $date->toSql();
			}
			if (empty($this->created_by)) {
				$this->created_by = $user->get('id');
			}


		}
		

		$resualt = parent::store($updateNulls);

		// Attempt to store the user data.
		return $resualt;
	}

	/**
	 * Overloaded check method to ensure data integrity.
	 *
	 * @return  boolean  True on success.
	 */
	public function check()
	{

		
		if(empty($this->alias)){
			if(!empty($this->seo_title))
				$this->alias = $this->seo_title;
			else 
				$this->alias = $this->name;
		}
		$this->alias = JApplication::stringURLSafe($this->alias);


		// check for user limitaion
		

		// check that alias is not taken
		$i = '';
		$alias = $this->alias;
		do {
			$this->alias = $alias.$i;
			$query = 'SELECT id FROM #__mrocket_landings WHERE alias = '.$this->_db->quote($this->alias);
			if(empty($i))
				$i = 0;
			$i = $i+1;
			$this->_db->setQuery($query);

			$xid = (int) $this->_db->loadResult();
		}while ($xid && $xid != (int) $this->id);
		
		
		

		return true;
	}

	public function delete($pk = null)
	{
		// select user_id first


		$row = $this->load($pk, true);
		if(!$row)
			return false;
	
		$result = parent::delete($pk);

		return $result;
	}


}
