<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelUnsubscribe extends JModelForm
{
    private $lead = false;
	public function getForm($data = array(), $loadData = true) {
            // Get the form.
            $form = $this->loadForm('com_marketingrocket.unsubscribe', 'unsubscribe', array('control' => 'jform', 'load_data' => $loadData));

            if (empty($form))
            {

                    return false;
            }
            
            return $form;
	}
	
	public function unsubscribAll($refCode){
            $db = $this->getDbo();
            $query = $db->getQuery(true);
            $query->select('*')->from($db->qn('#__mrocket_leads_cron'))
            ->where('ref = '.$db->q($refCode));
            
            $db->setQuery($query);
            $row = $db->loadObject();
            if(!empty($row)){
                $query = $db->getQuery(true);
                $query->select('*')->from($db->qn('#__mrocket_leads_cron'))->where('lead_id = '.$row->lead_id)
                        ->where('is_done = 0');
                $db->setQuery($query);
                $res = $db->loadObjectList();
                JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
                foreach ($res as $cron){
                    $leadCrons = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
                    $leadCrons->bind($cron);
                    $leadCrons->delete();
                }
                
                $query = $db->getQuery(true);
                $query->select('*')->from($db->qn('#__mrocket_lead_campaigns'))->where('lead_id = '.$row->lead_id);
                $db->setQuery($query);
                $res = $db->loadObjectList();
                foreach ($res as $leadCampaignRow){
                    $leadCampaign = JTable::getInstance('Leadcampaign', 'MarketingrocketTable');
                    $leadCampaign->bind($leadCampaignRow);
                    $leadCampaign->delete();
                }

            }
	}
	public function unsubscribe($refCode){
            $db = $this->getDbo();
            $query = $db->getQuery(true);
            $query->select('c.campaign_id,a.lead_id')->from($db->qn('#__mrocket_leads_cron', 'a'))->where('a.ref = '.$db->q($refCode))
                ->innerJoin($db->qn('#__mrocket_responder_templates', 'b') .' ON a.responder_id = b.id')
                ->innerJoin($db->qn('#__mrocket_reponders_sequences', 'c') . ' ON b.sequence_id = c.id')
            ;
            $db->setQuery($query);
            $row = $db->loadObject();
            if(!empty($row)){
                $campaingId = $row->campaign_id;
                $leadId = $row->lead_id;

                $q = $db->getQuery(true);
                $q->select('a.*')->from($db->qn('#__mrocket_responder_templates', 'a'))
                        ->innerJoin($db->qn('#__mrocket_reponders_sequences', 'b').' ON a.sequence_id = b.id')
                        ->where($db->qn('b.campaign_id') .' = '.$db->q($campaingId));
                $db->setQuery($q);
                $res = $db->loadObjectList();

                JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
                $lead = JTable::getInstance('Lead', 'MarketingrocketTable');
                $lead->load($leadId);

                foreach ($res as $row){
                    $lead->removeResponderFromLead($row->id);
                }
                $lead->removeFromCampaign($campaingId);
            }
	}
        
        public function getLead($refCode){
            $db = $this->getDbo();
            $query = $db->getQuery(true);
            $query->select('c.campaign_id,a.lead_id,l.email')->from($db->qn('#__mrocket_leads_cron', 'a'))->where('a.ref = '.$db->q($refCode))
                ->leftJoin($db->qn('#__mrocket_responder_templates', 'b') .' ON a.responder_id = b.id')
                ->leftJoin($db->qn('#__mrocket_reponders_sequences', 'c') . ' ON b.sequence_id = c.id')
                ->innerJoin($db->qn('#__mrocket_leads', 'l') . ' ON a.lead_id = l.id')
                ->where('l.recieve_email = 1')
            ;
            $db->setQuery($query);
            $this->lead = $db->loadObject();
            return $this->lead;
            
        }

	
	

}
