<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketModelPayment extends JModelForm
{
	/**
	 * Model context string.
	 *
	 * @var        string
	 */
	protected $_context = 'com_marketingrocket.payment';
        
        public function getTable($name = 'Payment', $prefix = 'MarketingrocketTable', $options = array()) {
            return parent::getTable($name, $prefix, $options);
        }

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since   1.6
	 */
	protected function populateState()
	{
		$app = JFactory::getApplication('site');

// 		// Load state from the request.
		$pk = $app->input->get('orderId');
		$this->setState('payment.id', $pk);



		// Load the parameters.
		$params = $app->getParams();
		$this->setState('params', $params);

		
		$this->setState('filter.language', JLanguageMultilang::isEnabled());
	}
        
        public function getItemByRef($ref, $checkNotPayed = true){
            $db = $this->getDbo();

            $query = $db->getQuery(true)
                    ->select('*');
            $query->from('#__mrocket_payments');
            $query->where("ref_code = ".$db->q($ref))
                    ->order('id DESC')
                    ;
            if($checkNotPayed)
                $query->where("status = 0");

            $db->setQuery($query);

            $data = $db->loadObject();
            if (empty($data))
            {
                return JError::raiseError(404, JText::_('COM_MARKETINGROCKET_ERROR_NOT_FOUND'));
            }
            return $data;
        }

	/**
	 * Method to get article data.
	 *
	 * @param   integer    The id of the article.
	 *
	 * @return  mixed  Menu item data object on success, false on failure.
	 */
	public function getItem($pk = null)
	{
		$pk = (!empty($pk)) ? $pk :$this->getState('payment.id');
		if(empty($pk))
		{
			
			return JError::raiseError(404, JText::_('COM_MARKETINGROCKET_ERROR_NOT_FOUND'));
		}
		if ($this->_item === null)
		{
			$this->_item = array();
		}

		if (!isset($this->_item[$pk]))
		{
			try
			{
                            $db = $this->getDbo();
                            $app = JFactory::getApplication('site');



                            $query = $db->getQuery(true)
                                    ->select('*');
                            $query->from('#__mrocket_payments');
                            $query->where("id = ".$db->q($pk));
                            $query->where("status = 0");

                            $db->setQuery($query);

                            $data = $db->loadObject();

                            if (empty($data))
                            {

                                    return JError::raiseError(404, JText::_('COM_MARKETINGROCKET_ERROR_NOT_FOUND'));
                            }


                            $this->_item[$pk] = $data;
			}
			catch (Exception $e)
			{
                            if ($e->getCode() == 404)
                            {
                                    // Need to go thru the error handler to allow Redirect to work.
                                    JError::raiseError(404, $e->getMessage());
                            }
                            else
                            {
                                    $this->setError($e);
                                    $this->_item[$pk] = false;
                            }
			}
		}

		return $this->_item[$pk];
	}
	public function createOrder($landingId , $leadId , $price , $ref , $formData = array()){
            
                $table = $this->getTable();
               
                $table->landing_id = $landingId;
                $table->lead_id = $leadId;
                $table->price = $price;
                $table->ref_code = $ref;
                $table->params = json_encode($formData);
                $table->date = JFactory::getDate()->toSql();
                $table->store();
		$orderId = $table->id;
		
		return array(
			'orderId' => $orderId,
			'price' =>  '',
			'name' => '',
// 			'' => 
		);
	}
	public function getForm($data = array(), $loadData = true) {
		
	}
	public function payOrder($id , $email , $data = array()){
            $table = $this->getTable();
            $table->load($id);
            $table->status = 1;
            $table->payer_email = $email;
            
            $params = json_decode($table->params, true);
            if(is_array($data))
               $params = array_merge($params, $data);

            $table->params = json_encode($params);
            
            $table->store();

            return $table;
            
	}
	public function getAlias(){
		$app = JFactory::getApplication('site');
		$refCode = $app->input->get('ref');
		$orderId = $app->input->get('order');
		$db = $this->getDbo();
		$query = $db->getQuery(true)->select("b.alias")
		->from($db->qn('#__mrocket_payments') .' as a')
		->join('INNER', $db->qn('#__mrocket_landings') . 'as b ON a.landing_id = b.id');
		$db->setQuery ( $query );
		$data = $db->loadObject();
		return $data->alias;
	}
        
        public function updateParams($id , $data){
            $table = $this->getTable();
            $table->load($id);
            
            $params = json_decode($table->params);
            
            if(!is_array($data))
               $data = (array)$data;
            $params = array_merge($params, $data);
            
            $table->params = json_encode($params);
            
            $table->store();
        }

}
