<?php

/**

 *  @package Marketing Rocket

 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.

 *  @license GNU General Public License version 2 or later

 */



defined('_JEXEC') or die;



class MarketingrocketModelLanding extends JModelForm

{

	/**

	 * Model context string.

	 *

	 * @var        string

	 */

	protected $_context = 'com_marketingrocket.landing';

        

        protected $_items = array();

        

        public $checkSeqCond = false;

        

        public $contryList = 	array('AF' => 'Afghanistan',

'AX' => 'Aland Islands',

'AL' => 'Albania',

'DZ' => 'Algeria',

'AS' => 'American Samoa',

'AD' => 'Andorra',

'AO' => 'Angola',

'AI' => 'Anguilla',

'AQ' => 'Antarctica',

'AG' => 'Antigua And Barbuda',

'AR' => 'Argentina',

'AM' => 'Armenia',

'AW' => 'Aruba',

'AU' => 'Australia',

'AT' => 'Austria',

'AZ' => 'Azerbaijan',

'BS' => 'Bahamas',

'BH' => 'Bahrain',

'BD' => 'Bangladesh',

'BB' => 'Barbados',

'BY' => 'Belarus',

'BE' => 'Belgium',

'BZ' => 'Belize',

'BJ' => 'Benin',

'BM' => 'Bermuda',

'BT' => 'Bhutan',

'BO' => 'Bolivia',

'BA' => 'Bosnia And Herzegovina',

'BW' => 'Botswana',

'BV' => 'Bouvet Island',

'BR' => 'Brazil',

'IO' => 'British Indian Ocean Territory',

'BN' => 'Brunei Darussalam',

'BG' => 'Bulgaria',

'BF' => 'Burkina Faso',

'BI' => 'Burundi',

'KH' => 'Cambodia',

'CM' => 'Cameroon',

'CA' => 'Canada',

'CV' => 'Cape Verde',

'KY' => 'Cayman Islands',

'CF' => 'Central African Republic',

'TD' => 'Chad',

'CL' => 'Chile',

'CN' => 'China',

'CX' => 'Christmas Island',

'CC' => 'Cocos (Keeling) Islands',

'CO' => 'Colombia',

'KM' => 'Comoros',

'CG' => 'Congo',

'CD' => 'Congo, Democratic Republic',

'CK' => 'Cook Islands',

'CR' => 'Costa Rica',

'CI' => 'Cote D\'Ivoire',

'HR' => 'Croatia',

'CU' => 'Cuba',

'CY' => 'Cyprus',

'CZ' => 'Czech Republic',

'DK' => 'Denmark',

'DJ' => 'Djibouti',

'DM' => 'Dominica',

'DO' => 'Dominican Republic',

'EC' => 'Ecuador',

'EG' => 'Egypt',

'SV' => 'El Salvador',

'GQ' => 'Equatorial Guinea',

'ER' => 'Eritrea',

'EE' => 'Estonia',

'ET' => 'Ethiopia',

'FK' => 'Falkland Islands (Malvinas)',

'FO' => 'Faroe Islands',

'FJ' => 'Fiji',

'FI' => 'Finland',

'FR' => 'France',

'GF' => 'French Guiana',

'PF' => 'French Polynesia',

'TF' => 'French Southern Territories',

'GA' => 'Gabon',

'GM' => 'Gambia',

'GE' => 'Georgia',

'DE' => 'Germany',

'GH' => 'Ghana',

'GI' => 'Gibraltar',

'GR' => 'Greece',

'GL' => 'Greenland',

'GD' => 'Grenada',

'GP' => 'Guadeloupe',

'GU' => 'Guam',

'GT' => 'Guatemala',

'GG' => 'Guernsey',

'GN' => 'Guinea',

'GW' => 'Guinea-Bissau',

'GY' => 'Guyana',

'HT' => 'Haiti',

'HM' => 'Heard Island & Mcdonald Islands',

'VA' => 'Holy See (Vatican City State)',

'HN' => 'Honduras',

'HK' => 'Hong Kong',

'HU' => 'Hungary',

'IS' => 'Iceland',

'IN' => 'India',

'ID' => 'Indonesia',

'IR' => 'Iran, Islamic Republic Of',

'IQ' => 'Iraq',

'IE' => 'Ireland',

'IM' => 'Isle Of Man',

'IL' => 'Israel',

'IT' => 'Italy',

'JM' => 'Jamaica',

'JP' => 'Japan',

'JE' => 'Jersey',

'JO' => 'Jordan',

'KZ' => 'Kazakhstan',

'KE' => 'Kenya',

'KI' => 'Kiribati',

'KR' => 'Korea',

'KW' => 'Kuwait',

'KG' => 'Kyrgyzstan',

'LA' => 'Lao People\'s Democratic Republic',

'LV' => 'Latvia',

'LB' => 'Lebanon',

'LS' => 'Lesotho',

'LR' => 'Liberia',

'LY' => 'Libyan Arab Jamahiriya',

'LI' => 'Liechtenstein',

'LT' => 'Lithuania',

'LU' => 'Luxembourg',

'MO' => 'Macao',

'MK' => 'Macedonia',

'MG' => 'Madagascar',

'MW' => 'Malawi',

'MY' => 'Malaysia',

'MV' => 'Maldives',

'ML' => 'Mali',

'MT' => 'Malta',

'MH' => 'Marshall Islands',

'MQ' => 'Martinique',

'MR' => 'Mauritania',

'MU' => 'Mauritius',

'YT' => 'Mayotte',

'MX' => 'Mexico',

'FM' => 'Micronesia, Federated States Of',

'MD' => 'Moldova',

'MC' => 'Monaco',

'MN' => 'Mongolia',

'ME' => 'Montenegro',

'MS' => 'Montserrat',

'MA' => 'Morocco',

'MZ' => 'Mozambique',

'MM' => 'Myanmar',

'NA' => 'Namibia',

'NR' => 'Nauru',

'NP' => 'Nepal',

'NL' => 'Netherlands',

'AN' => 'Netherlands Antilles',

'NC' => 'New Caledonia',

'NZ' => 'New Zealand',

'NI' => 'Nicaragua',

'NE' => 'Niger',

'NG' => 'Nigeria',

'NU' => 'Niue',

'NF' => 'Norfolk Island',

'MP' => 'Northern Mariana Islands',

'NO' => 'Norway',

'OM' => 'Oman',

'PK' => 'Pakistan',

'PW' => 'Palau',

'PS' => 'Palestinian Territory, Occupied',

'PA' => 'Panama',

'PG' => 'Papua New Guinea',

'PY' => 'Paraguay',

'PE' => 'Peru',

'PH' => 'Philippines',

'PN' => 'Pitcairn',

'PL' => 'Poland',

'PT' => 'Portugal',

'PR' => 'Puerto Rico',

'QA' => 'Qatar',

'RE' => 'Reunion',

'RO' => 'Romania',

'RU' => 'Russian Federation',

'RW' => 'Rwanda',

'BL' => 'Saint Barthelemy',

'SH' => 'Saint Helena',

'KN' => 'Saint Kitts And Nevis',

'LC' => 'Saint Lucia',

'MF' => 'Saint Martin',

'PM' => 'Saint Pierre And Miquelon',

'VC' => 'Saint Vincent And Grenadines',

'WS' => 'Samoa',

'SM' => 'San Marino',

'ST' => 'Sao Tome And Principe',

'SA' => 'Saudi Arabia',

'SN' => 'Senegal',

'RS' => 'Serbia',

'SC' => 'Seychelles',

'SL' => 'Sierra Leone',

'SG' => 'Singapore',

'SK' => 'Slovakia',

'SI' => 'Slovenia',

'SB' => 'Solomon Islands',

'SO' => 'Somalia',

'ZA' => 'South Africa',

'GS' => 'South Georgia And Sandwich Isl.',

'ES' => 'Spain',

'LK' => 'Sri Lanka',

'SD' => 'Sudan',

'SR' => 'Suriname',

'SJ' => 'Svalbard And Jan Mayen',

'SZ' => 'Swaziland',

'SE' => 'Sweden',

'CH' => 'Switzerland',

'SY' => 'Syrian Arab Republic',

'TW' => 'Taiwan',

'TJ' => 'Tajikistan',

'TZ' => 'Tanzania',

'TH' => 'Thailand',

'TL' => 'Timor-Leste',

'TG' => 'Togo',

'TK' => 'Tokelau',

'TO' => 'Tonga',

'TT' => 'Trinidad And Tobago',

'TN' => 'Tunisia',

'TR' => 'Turkey',

'TM' => 'Turkmenistan',

'TC' => 'Turks And Caicos Islands',

'TV' => 'Tuvalu',

'UG' => 'Uganda',

'UA' => 'Ukraine',

'AE' => 'United Arab Emirates',

'GB' => 'United Kingdom',

'US' => 'United States',

'UM' => 'United States Outlying Islands',

'UY' => 'Uruguay',

'UZ' => 'Uzbekistan',

'VU' => 'Vanuatu',

'VE' => 'Venezuela',

'VN' => 'Viet Nam',

'VG' => 'Virgin Islands, British',

'VI' => 'Virgin Islands, U.S.',

'WF' => 'Wallis And Futuna',

'EH' => 'Western Sahara',

'YE' => 'Yemen',

'ZM' => 'Zambia',

'ZW' => 'Zimbabwe',

); 



	/**

	 * Method to auto-populate the model state.

	 *

	 * Note. Calling getState in this method will result in recursion.

	 *

	 * @since   1.6

	 */

	protected function populateState()

	{

		$app = JFactory::getApplication('site');

		// Load state from the request.

		$pk = $app->input->getString('alias');

		$this->setState('landing.alias', $pk);



		$id = $app->input->get('id');

                $this->setState('landing.id', $id);

		// Load the parameters.

		$params = $app->getParams();

		$this->setState('params', $params);

                

                if(empty($pk) && empty($id)){ // in case of set menu as home

                    $requestUrl = $_SERVER['REQUEST_URI'];

                    $data = parse_url($requestUrl);



                    $alias = str_replace('/landing/', '',$data['path']);



                    // get menu itam

                    $menu = $this->getMenuUrl();

                    $alias = str_replace('/'.$menu['path'], '',$alias);

                    $alias = str_replace('/', '',$alias);

                    if(empty($alias)){ // direct called

                        $alias = JComponentHelper::getParams('com_marketingrocket')->get('default_landing');

                    }

                    $this->setState('landing.alias', $alias);

                }

                

                $this->setState('landing.foundby', JFactory::getApplication()->input->get('load', 'alias'));



		$this->setState('filter.language', JLanguageMultilang::isEnabled());

                parent::populateState();

	}

        

        public function getItemById($id){

            $this->populateState();

            $this->getState('landing.foundby');

            $this->setState('landing.id', $id);

            $this->setState('landing.foundby', 'id');

            return $this->getItem($id);

        }



	/**

	 * Method to get article data.

	 *

	 * @param   integer    The id of the article.

	 *

	 * @return  mixed  Menu item data object on success, false on failure.

	 */

	public function getItem($pk = null, $foundBy = 'alias')

	{

                $foundBy = $this->getState('landing.foundby');

                $pk = (!empty($pk)) ? $pk : $this->getState('landing.alias');



		

                // commented this line because its cuase the problem when form validation gone wrong , then all things will work with id

//                $this->setState('landing.foundby', 'alias'); // reset

		if(empty($pk))

		{

			$foundBy = 'id';

			$pk = $this->getState('landing.id');

		}

// 		if(empty($pk))

// 		{

// 			return JError::raiseError(404, JText::_('COM_MARKETINGROCKET_ERROR_NOT_FOUND'));

// 		}

		if (empty($this->_item))

		{

			$this->_item = array();

		}

                JFactory::getApplication()->setUserState('marketing_rocket_template.alias', $pk);

		if (!isset($this->_item[$pk]) && !empty($pk))

		{



			try

			{

				$db = $this->getDbo();

				$app = JFactory::getApplication('site');

				$user = JFactory::getUser();

				$query = $db->getQuery(true)

					->select('a.*,SUM(b.visit) AS allvisits');

                                

                                $date = JFactory::getDate('now', JFactory::getConfig()->get('offset'));

				$query->from('#__mrocket_landings AS a');

				$query->join('LEFT', $db->qn('#__mrocket_daily_stat').' AS b ON a.id = b.landing_id AND b.date >= '.$db->q($date->format('Y-m-d', true)))

                                        ;

				if($foundBy == 'alias')

					$query->where("a.alias = ".$db->q($pk));

				else

					$query->where("a.id = ".$db->q($pk));

// 				if($app->input->get('preview', 0) != 1 && $user->get('isRoot'))

// 				{

					$query->where("a.published = 1");

// 				}

				$query->group('b.landing_id');

				$query->order('allvisits ASC'); // for split pages

			//	$query->order('hits ASC'); // for split pages



				$db->setQuery($query);

				$data = $db->loadObject();

				if (empty($data))

				{

				    $offine = JFactory::getApplication()->get('offline');

                    if(empty($offine))

                    {

                        throw new Exception( JText::_('COM_MARKETINGROCKET_ERROR_NOT_FOUND'), 404);

                    }

				}

				$pk = $data->alias;

                                $pageOptions = json_decode($data->page_option, true);

                                if(is_array($pageOptions)){

                                    foreach ($pageOptions as $key => $option){

                                        $data->$key = $option;

                                    }

                                }

				$this->_item[$pk] = $data;

			}

			catch (Exception $e)

			{

				if ($e->getCode() == 404)

				{

					// Need to go thru the error handler to allow Redirect to work.

					throw new Exception(JText::_('COM_MARKETINGROCKET_ERROR_NOT_FOUND'), 404);

				}

				else

				{

					$this->setError($e);

					$this->_item[$pk] = false;

				}

			}

			return $this->_item[$pk];

		}

		else if(isset($this->_item[$pk]))

			return $this->_item[$pk];

		else {

			return false;

		}



		

	}

	public function getLandings(){

		$db = $this->getDbo();

		$query = $db->getQuery(true)

		->select('a.*');

		$query->from('#__mrocket_landings AS a');

		$query->where("a.published = 1")

		->where('public_accsess = 1')

		->where('type = 1')

		;

		$db->setQuery($query, 0, 10);



		$data = $db->loadObjectList();

		return $data;

	}

        

        private function _getFormJson($item){

            $jsonData = $item->form_json;

			

            $jsonData = json_decode($jsonData);



            if($item->have_paypal == 1){

                JLoader::import('joomla.plugin.helper');



                JPluginHelper::importPlugin('marketingrocket');

                $dispatcher = JDispatcher::getInstance();

                $paymentApiId = (int)$item->paypal_account;

                require_once 'api.php';

                $type = MarketingrocketModelApi::getType($paymentApiId);

                $dispatcher->trigger('onBeforePayemtnFormCreation', array(&$jsonData, $item, $type) );

            }

            return $jsonData;

        }





        public function getForm($data = array(), $loadData = true, $returnXml = false){

		

		$source = 'landing';

		$options = array('control' => 'jform', 'load_data' => $loadData);

		$clear = false;

		$xpath = false;

		

		// Handle the optional arguments.

		$options['control'] = Joomla\Utilities\ArrayHelper::getValue($options, 'control', false);


		// Create a signature hash.

		$hash = md5($source . serialize($options));

			

		// Check if we can use a previously loaded form.

		if (isset($this->_forms[$hash]) && !$clear)

		{

            return $this->_forms[$hash];

		}
	
		

		// Get the form.

		JForm::addFormPath(JPATH_COMPONENT . '/models/forms');

		JForm::addFieldPath(JPATH_COMPONENT . '/models/fields');

		JForm::addFormPath(JPATH_COMPONENT . '/model/form');

		JForm::addFieldPath(JPATH_COMPONENT . '/model/field');                

        JForm::addRulePath(JPATH_COMPONENT . '/models/rules');

		

		try

		{

			$XmlStartString = '<?xml version="1.0" encoding="utf-8"?><form><fieldset name="main"></fieldset></form>';

			$xml = new SimpleXMLElement($XmlStartString);

			if(JFactory::getApplication()->input->getCmd('view') == 'preview')

				$item = $this->getTemp();

                        else if(JFactory::getApplication()->input->getCmd('task') == 'savehtml')

                                $item = $this->getTemp('html');

                        else {

				$item = $this->getItem();

                        }

                        $name = "com_marketingrocket.edit.landingForm.".$item->id;

                        

                        $jsonData = $this->_getFormJson($item);

//                        Zend_Debug::dump($jsonData);

//                        die;

                        

			$fieldSet = $xml->getName('main');

			foreach ($xml->children() as $child) {

                            foreach ( $jsonData as $k =>  $row){



                                if($row->field_type == 'address'){

                                    $addressPrefix = (!empty($row->address_prefix)) ? $row->address_prefix : '';

                                    $isRequired = (!isset($row->is_required)) ? 'true' : (string) $row->is_required;

                                    

                                    $rowChild = $child->addChild('field');

                                    $rowChild->addAttribute('name',$addressPrefix.'address');

                                    $rowChild->addAttribute('type','textarea');

                                    $rowChild->addAttribute('label',  JText::_('COM_MARKETINGROCKET_ADDRESS'));

                                    $rowChild->addAttribute('required',$isRequired);

                                    

                                    $rowChild = $child->addChild('field');

                                    $rowChild->addAttribute('name',$addressPrefix.'address2');

                                    $rowChild->addAttribute('type','textarea');

                                    $rowChild->addAttribute('label',JText::_('COM_MARKETINGROCKET_ADDRESS2'));



                                    $rowChild = $child->addChild('field');

                                    $rowChild->addAttribute('name',$addressPrefix.'city');

                                    $rowChild->addAttribute('type','text');

                                    $rowChild->addAttribute('label',JText::_('COM_MARKETINGROCKET_CITY'));

                                    $rowChild->addAttribute('required',$isRequired);



                                    $rowChild = $child->addChild('field');

                                    $rowChild->addAttribute('name',$addressPrefix.'state');

                                    $rowChild->addAttribute('type','text');

                                    $rowChild->addAttribute('label',JText::_('COM_MARKETINGROCKET_STTE_PROVINCE_REGION'));



                                    $rowChild = $child->addChild('field');

                                    $rowChild->addAttribute('name',$addressPrefix.'zipcode');

                                    $rowChild->addAttribute('type','text');

                                    $rowChild->addAttribute('label',JText::_('COM_MARKETINGROCKET_ZIPCODE'));

                                    $rowChild->addAttribute('required',$isRequired);



                                    $rowChild = $child->addChild('field');

                                    $rowChild->addAttribute('name',$addressPrefix.'country');

                                    $rowChild->addAttribute('type','list');

                                    $rowChild->addAttribute('label',JText::_('COM_MARKETINGROCKET_COUNTRY'));

                                    $rowChild->addAttribute('required',$isRequired);

                                    

                                    

                                    



                                    foreach ($this->contryList as  $countryCode => $countryName){

                                            $rowOption = $rowChild->addChild('option', str_replace('&', '&amp;', $countryName));

                                            $rowOption->addAttribute('value', $countryCode);

                                    }

                                    

                                    

                                    $rowChild = $child->addChild('field');

                                    $rowChild->addAttribute('name',$addressPrefix.'phone');

                                    $rowChild->addAttribute('type','text');

                                    $rowChild->addAttribute('label',JText::_('COM_MARKETINGROCKET_PHONE'));

                                    $rowChild->addAttribute('required',$isRequired);

                                    $rowChild->addAttribute('maxlength',"10");



                                    continue;

                                }

                                else {

                                    $rowChild = $child->addChild('field');

                                     if($row->field_type == 'tester'){

                                          $rowChild->addAttribute('name','answer_seq_54321');

                                     }

                                     else {

                                     	$id = '';

                                        if(empty($row->name)) {                                       
                                            $rowChild->addAttribute('name',strtolower(str_replace(' ', '_', $row->label)));	
                                        }
                                        else {
                                        	$id = preg_replace('#\W#', '',$row->name);
                                        	$id = str_replace('_', '', $id);
                                            $rowChild->addAttribute('name',$row->name);
                                        }
                                        if(empty($id)){
                                            $rowChild->addAttribute('id','field_'.$k);
                                        }
                                     }      

                                }

                               
                                if($row->field_type == 'tester'){

                                    $rowChild->addAttribute('type','text');

                                    $rowChild->addAttribute('label', 'answer'); 

                                }

                                else {

                                    $rowChild->addAttribute('type',$this->_switchType($row->field_type));

                                    $rowChild->addAttribute('label',empty($row->label) ? '' : $row->label);

                                }

                                

                                if($row->field_type == 'email'){

                                    $rowChild->addAttribute('validate','emailadress');

                                }

                                if($row->field_type == 'list'){

                                    $rowChild->addAttribute('validate','options');

                                }

                                

                                if(isset($row->format))

                                    $rowChild->addAttribute('format',$row->format);



                                if(isset($row->hint))

                                    $rowChild->addAttribute('hint',$row->hint);



                                if(isset($row->pattern))

                                    $rowChild->addAttribute('pattern',$row->pattern);

                                if(!empty($row->required) && $row->field_type != 'section_break')

                                        $rowChild->addAttribute('required',"true");



                                if($row->field_type == 'section_break')

                                    $rowChild->addAttribute('required',"false");

                                

                                if(!empty($row->default))

                                        $rowChild->addAttribute('default',(string)$row->default);

                                

                                if(!empty($row->attributes)){

                                    foreach ($row->attributes as $attrKey => $attribute){

                                        $rowChild->addAttribute($attrKey,$attribute);

                                    }

                                }

                                

                                

                                if(!empty($row->field_options)){

                                    $rowOptions = $row->field_options;

                                    if(!empty($rowOptions->description)){

                                            $rowChild->addAttribute('description',$rowOptions->description);

                                    }

                                    if(!empty($rowOptions->options)){

                                        

                                        if(!empty($rowOptions->include_blank_option)){

                                            if(isset($rowOptions->blank_option_value))

                                                $rowOption = $rowChild->addChild('option', $rowOptions->blank_option_value);

                                            else 

                                                $rowOption = $rowChild->addChild('option', '');

                                            $rowOption->addAttribute('value', '');

                                        }

                                        

                                        foreach ($rowOptions->options as $option){

                                                $rowOption = $rowChild->addChild('option', htmlspecialchars($option->label));

                                                if(!isset($option->value))

                                                    $rowOption->addAttribute('value', str_replace(' ', '_', $option->label));

                                                else {

                                                    $rowOption->addAttribute('value', (string)$option->value);

                                                }

                                        }

                                    } 

                                }

                            }

			}

			$idChild = $child->addChild('field');

			$idChild->addAttribute('type','hidden');

			$idChild->addAttribute('name','landing_id');

			

// 			echo $xml->asXML();

// 			die;

// 			echo'</pre>';

			

			

			if($returnXml)

                            return $xml;

			

			$form = JForm::getInstance($name, $xml->asXML(), $options, false, $xpath);

			if (isset($options['load_data']) && $options['load_data'])

			{

				// Get the data for the form.

				$data = $this->loadFormData();

			}

			else

			{

				$data = array();

			}

			// Allow for additional modification of the form, and events to be triggered.

			// We pass the data because plugins may require it.

			parent::preprocessForm($form, $data);

		

			// Load the data into the form after the plugins have operated.

			$form->bind($data);

		

		}

		catch (Exception $e)

		{

			throw new Exception($e->getMessage());

		}

		

		

		// Store the form for later.

		$this->_forms[$hash] = $form;

		return $form;

	}

	protected function loadFormData()

	{

	

		

		if(JFactory::getApplication()->input->getCmd('view') == 'preview')

			$item = $this->getTemp();

		else 

			$item = $this->getItem();

                

                // Check the session for previously entered form data.

		$data = JFactory::getApplication()->getUserState('com_marketingrocket.edit.landingForm.'.$item->id.'.data', array());

                if(empty($data)){

                    $session =  @JSession::getInstance('', '');

                    if($session->has('refcode', 'com_marketingrocket')){

                        $ref = $session->get('refcode', false, 'com_marketingrocket');

                        $refValue = sha1($ref.'_MR'.JComponentHelper::getParams('com_marketingrocket')->get('salt'));

                        if(isset($_COOKIE[$ref]) && $_COOKIE[$ref] == $refValue){

                            $db = $this->getDbo ();

                            $query = $db->getQuery(true);

                            $query->select("a.*")

                            ->from($db->quoteName ( '#__mrocket_leads', 'a' ))

                            ->join('INNER', $db->qn('#__mrocket_refcodes', 'b') . ' ON a.id = b.lead_id')

                            ->where('b.ref_code = '.$db->q($ref))

                            ->where('a.published = 1')

                            ->where('a.is_temp = 0')

                            ;

                            $db->setQuery ( $query );

                            $leadDetail = $db->loadObject();

                            

                            if(!empty($leadDetail)){

                                $lead = $this->getTable('Lead', 'MarketingrocketTable');

                                $lead->bind($leadDetail);

                                $data = $lead->getFormData();

                                $data['first_name'] = $data['first-name'] = $leadDetail->first_name;

                                $data['last_name'] = $leadDetail->last_name;

                            }

                            

                        }

                    }

                }

                

		$data['landing_id'] = $item->id;

			

	

		return $data;

	}

	private function _switchType($name){

		$name = strtolower($name);

		switch ($name){

			case 'date' :

				return 'calendar';

				break;

			case 'dropdown' :

				return 'list';

				break;

			case 'paragraph' :

				return 'textarea';

				break;

			case 'website' :

				return 'url';

				break;

			case 'section_break' :

				return 'spacer';

				break;

                        case 'address' :

                            return 'textarea';

                            break;

			default: 

				return $name;

		}

	}

	/**

	 * Increment the hit counter for the article.

	 *

	 * @param   integer  $pk  Optional primary key of the article to increment.

	 *

	 * @return  boolean  True if successful; false otherwise and internal error set.

	 */

	public function hit($pk = 0)

	{

		$input = JFactory::getApplication()->input;

		$hitcount = $input->getInt('hitcount', 1);

	

		if ($hitcount)

		{

			$pk = (!empty($pk)) ? $pk : (int) $this->getState('landing.id');

			

	

			$table = JTable::getInstance('Landing', 'MarketingrocketTable');

			$table->load($pk);

			$table->hit($pk);

		}

	

	}

	public function getNextStepLandingUrl($item, $field = 'to_landing_page'){

		$id = $item->$field;

		if(empty($id)){

			return JError::raiseError(500, JText::_('Next Landing Not Found'));

		}

                $this->setState('landing.foundby', 'id');

		$newItem = $this->getItem($id, 'id');

		return $newItem->alias; 

	}

	public function saveLead($data, $isTemporary = 0){

		$db = $this->getDbo ();

		try {

            if (!isset($data['email'])) {

                $item = $this->getItem();

                $jsonData = $item->form_json;

                $jsonData = json_decode($jsonData);



                foreach ($jsonData as $row) {

                    if ($row->field_type == 'email') {

                        if (empty($row->name))

                            $newName = strtolower(str_replace(' ', '_', $row->label));

                        else

                            $newName = $row->name;



                        $data['email'] = $data[$newName];

                        break;

                    }

                }

            }



            $db->transactionStart();

            $item = $this->getItem();

            // check for existing user

            $leadModel = JModelLegacy::getInstance('Lead', 'MarketingrocketModel', array('ignore_request' => true));

            $row = $leadModel->getTable();

            $row->load(array('email' => $data['email']));



            if($row->id != 0 && $row->is_temp == 1)

            {

                $row->delete();

                $row = $leadModel->getTable();

            }





            $formData = array(0 => $data);
			
            $formData[0]['MR_submited_date'] = JFactory::getDate()->toSql();

            $formData[0]['MR_form_name'] = $item->title;

            $this->checkSeqCond = true;



            $exist = true;



            if ($row->id == 0) { // if this email is new register it

                $date = JFactory::getDate();



                $item = $this->getItem();



                $options = json_decode($item->page_option);

                if(!empty($options->is_double_optin))

                    $isTemporary = true;



                $exist = false;



                $leadData = array();

                if (!empty($data['first_name']))

                    $leadData['first_name'] = $data['first_name'];

                else if (!empty($data['first-name']))

                    $leadData['first_name'] = $data['first-name'];

                else if (!empty($data['name'])) {

                    $fullName = explode(' ', $data['name']);

                    $leadData['first_name'] = array_shift($fullName);

                    $leadData['last_name'] = implode(' ', $fullName);

                }

                if (!empty($data['last-name']))

                    $leadData['last_name'] = $data['last-name'];



                $leadData['email'] = $data['email'];

                $leadData['landing_id'] = $item->id;

//                                $leadData['lead_status'] = $statusRow->id;

                $leadData['created'] = $date->toSql();

                if (!$isTemporary) {

                    $leadData['published'] = 1;

                } else {

                    $leadData['is_temp'] = 1;

                }

                $leadModel->save($leadData);





                $row->load($leadModel->getState($leadModel->getName() . '.id'));





                $lead_id = $row->id;



                $query = $db->getQuery(true);

                $query->select('id')->from('#__mrocket_statuses')

                    ->where($db->qn('default') . ' = 1');



                $db->setQuery($query);



                $defaultStatus = $db->loadResult();

                if (!empty($defaultStatus))

                    $this->_setLeadStatus($lead_id, $defaultStatus, $item->campaign_id);



//				$this->_addLeadToCampaign($lead_id, $item->campaign_id);





                $refCode = $this->_addRefCode($lead_id);



                $urlPatch = JUri::getInstance();

                $ex = JFactory::getDate('now', JFactory::getConfig()->get('offset'));

                $ex->modify('+1 year');



                setcookie($refCode, sha1($refCode . '_MR' . JComponentHelper::getParams('com_marketingrocket')->get('salt')), $ex->getTimestamp(), '', $urlPatch->getHost());



                if (!$isTemporary)

                    $this->increaseStat($item->id, 'submission'); // increase Submissions



            } else { // if not exist just change responder based on admin selected

                // check if user alredy filled this page





                // MR-330 - URGENT: Auto Responders NOT firing if lead has already recieved it regardless of logic setting.

//                                $refCode = $row->isRegisteredInLanding($item->id);

//                                if(!empty($refCode)){

//                                    $db->transactionCommit();

//                                    return array('id' => $row->id, 'ref' => $refCode);

//                                    return false;

//                                }





                $lead_id = $row->id;



                if ($row->recieve_email == 0) {

//                                    JTable::addIncludePath();

                    $leadTable = $this->getTable('Lead', 'MarketingrocketTable');

                    $leadTable->load($row->id);

                    $leadTable->recieve_email = 1;

                    $leadTable->store();

                }

                $refCode = $this->_addRefCode($lead_id, false);





            }



            $db->transactionCommit();

        } catch (Exception $e) {

            $db->transactionRollback();

            throw $e;

        }

        require_once JPATH_COMPONENT_SITE.DS.'tables'.DS.'leaddetails.php';

        //unset($formData[0]['landing_id']);

        unset($formData[0]['MR_form_name']);





        $xml = $this->getForm(array(), true, true);

        $dom = new DOMDocument();

        $dom->loadXML($xml->asXML());

        $formFields = $dom->getElementsByTagName('field');



        $jsonData = $this->_getFormJson($item);

        $formDecoded = $data;	
		
        foreach ($formFields as $field){
			
            $name = $field->getAttribute('name');
			
            $val = $formData[0][$name];

            if(empty($val))

                continue;



            $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');

            $leadDetailsTable->landing_id = $item->id;

            $leadDetailsTable->lead_id = $lead_id;

            $leadDetailsTable->field_name = $name;

            $leadDetailsTable->label = JText::_($field->getAttribute('label'));

            if(is_array($val))

                $val = json_encode ($val);

            $leadDetailsTable->value = $val;



            $leadDetailsTable->store();



        }
		
        $session =  @JSession::getInstance('', '');



        if($session->get('refer', '', 'MARKETINGROCKET_REFER') != ''){

            $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');



            $leadDetailsTable->landing_id = $item->id;

            $leadDetailsTable->lead_id = $lead_id;

            $leadDetailsTable->field_name = 'refer';

            $leadDetailsTable->label = JText::_('COM_MARKETINGROCKET_REFER');

            $leadDetailsTable->value = $session->get('refer', '', 'MARKETINGROCKET_REFER');

            $leadDetailsTable->store();



        }



        if($session->get('keyword', '', 'MARKETINGROCKET_REFER') != ''){

            $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');

            $leadDetailsTable->landing_id = $item->id;

            $leadDetailsTable->lead_id = $lead_id;

            $leadDetailsTable->field_name = 'keyword';

            $leadDetailsTable->label = JText::_('COM_MARKETINGROCKET_KEYWORD');

            $leadDetailsTable->value = $session->get('keyword', '', 'MARKETINGROCKET_REFER');

            $leadDetailsTable->store();

        }



        $arr = MarketingrocketFrontHelper::$utmArray;



        foreach ($arr as $arrayRow){

            $arrayRowVal = $session->get($arrayRow, '', 'MARKETINGROCKET_UTM');

            if(!empty($arrayRowVal)){

                $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');

                $leadDetailsTable->landing_id = $item->id;

                $leadDetailsTable->lead_id = $lead_id;

                $leadDetailsTable->field_name = $arrayRow;

                $leadDetailsTable->label = $arrayRow;

                $leadDetailsTable->value = $arrayRowVal;

                $leadDetailsTable->store();

            }

        }
		
        if($item->have_paypal == 0) {

            $this->handleAllAfterRegisterJobs($row, $item, $exist);

        }

        else

            $isTemporary = 1; // for plugins



        JPluginHelper::importPlugin('marketingrocket');

        $dispatcher = JEventDispatcher::getInstance();

        $dispatcher->trigger('onAfterFrontRegisterLead', array($row, $exist, $item, $data, $isTemporary));

		

        return array('id' => $lead_id, 'ref' => $refCode, 'exist' => $exist);







		

	}



	public function handleAllAfterRegisterJobs($lead, $landing, $exist = false){

        require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_marketingrocket'.DS. 'helpers' . DS . 'marketingrocket.php';



        $text = JText::sprintf('COM_MARKETINGROCKET_LOG_FORM_SUBMIT', $landing->title);

		

        MarketingrocketHelper::log('form', 'submit', $text, $lead->id, $landing->id, '#__mrocket_landings');





        $this->handleLandingActions($lead, $landing);



        $this->handleAfterRegisterLeadJobs($lead, $landing);



        if ($exist) {

            $this->checkSequenceCond($lead, $landing);

        } else {

            $this->checkSequenceCond($lead, $landing, false);

        }



    }

        

        /**

         * check from sequence options that lead can register in sequence or not

         * 

         * @param MarketingrocketTableLead $lead

         * @param MarketingrocketTableLanding $landing

         * @param boolean $isExist

         */

        public function checkSequenceCond($lead, $landing, $isExist = true){

            

            

            

            if($this->_isJson($landing->responder_sequence_id))

                $sequences = json_decode ($landing->responder_sequence_id);

            else 

                $sequences = array($landing->responder_sequence_id);

            

            $leadTags = $lead->getTags(); // get user tags as array

            

            $leadsSequence = false;

            

            require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_marketingrocket'.DS.'tables'.DS.'sequence.php';

            foreach ($sequences as $sequence){

                

                if($landing->responder_type != 'default'){

                    $obj = new stdClass();

                    $obj->responder_sequence_id = $sequence;

                    $obj->responder_type = $landing->responder_type;

                    $obj->api_id = $landing->api_id;

                    $this->_addResponderToLead($lead->id, $lead->email, $obj);

                    continue;

                }

                

                $table = JTable::getInstance('Sequence', 'MarketingrocketTable');

                $table->load($sequence);

               

                if(empty($table->id)) // sequence is not exist anymore

                    continue;

                

                

                if(!empty($table->adding_tag_before)){

                    $this->_addTagToLead($lead->id, $table->adding_tag_before);

                }

                

                

                if($isExist && $table->add_to_existing_lead == 0) // lead was exist and setting dont allow to this lead be in this sequence

                    continue;

                

                if($isExist && $table->add_to_recieved_before == 0){

                    

                    

                    if($leadsSequence === false){

                        $leadsSequence = $lead->getRegisteredSequence();

                    }



                    if($leadsSequence !== false){

                        if(in_array($sequence, $leadsSequence)){

                            //die;

                            continue;

                        }

                        

                    }

                }

                

                

                $canAdd = static::checkCanBeAddToSequence($table, $leadTags);

                if($canAdd){

                    $obj = new stdClass();

                    $obj->responder_sequence_id = $table->id;

                    $obj->responder_type = $landing->responder_type;

                    $obj->api_id = $landing->api_id;

                    $this->_addResponderToLead($lead->id, $lead->email, $obj);

                    

                    if(!empty($table->adding_tag)){

                        $this->_addTagToLead($lead->id, $table->adding_tag);

                    }

                }

               //die;

                

            }

            

        }

        

        public function handleLandingActions($lead, $landing){

            $db = $this->getDbo();

            $q = $db->getQuery(true);

            

            $q->select('*')->from('#__mrocket_actions')

                    ->where($db->qn('landing_id') .' = '.$db->q($landing->id))

                    ->where($db->qn('action') .' != '.$db->q('open_landing'))

                    ->where($db->qn('type') .' = '.$db->q('landing_action'))

                    ->order($db->qn('order').' ASC');

            $db->setQuery($q);

            $res = $db->loadObjectList();

            foreach ($res as $row){

                if($this->actionConditionCheck($lead, $row) == true){

                    $this->_handleAction($row , $lead);

                }

            }

        }

        

        public function actionConditionCheck($lead, $actionRow){

            require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables'.DIRECTORY_SEPARATOR.'lead.php';

            if(!$lead instanceof MarketingrocketTableLead){

                $leadTable = JTable::getInstance('Lead', 'MarketingrocketTable');

                $leadTable->bind($lead);

                $lead = $leadTable;

            }

                

            $leadTags = $lead->getTags();

            $rowTags = json_decode($actionRow->tags);

            switch ($actionRow->condition_type){

                case 'any' :

                    foreach ($rowTags as $rowTag){

                        if(in_array($rowTag, $leadTags)){

                            return true;

                        }

                    }

                    break;

                case 'all':

                    $canAdd = true;

                    foreach ($rowTags as $rowTag){

                        if(!in_array($rowTag, $leadTags)){

                            $canAdd = false;

                            break ;

                        }

                    }

                    if($canAdd){

                        return true;

                    }

                    break;

                case 'dont_any' :

                    foreach ($rowTags as $rowTag){

                        if(!in_array($rowTag, $leadTags)){

                            return true;

                        }

                    }

                    break;

                case 'dont_all' :

                    $canAdd = true;

                    foreach ($rowTags as $rowTag){

                        if(in_array($rowTag, $leadTags)){

                            $canAdd = false;

                            break ;

                        }

                    }

                    if($canAdd){

                        return true;

                    }

                    break;

                case 'all_time' :

                    return true;

                    break;

            }

            return false;

        }

        

        public function _handleAction($action, $lead){

            switch($action->action){

                case 'add_responder':

                    $item = new stdClass();

                    $item->responder_type = $action->responder_type;

                    $item->api_id = $action->api_id;

                    $item->responder_sequence_id = $action->target;

                    $this->_addResponderToLead($lead->id, $lead->email, $item);

                    break;

                case 'remove_responder':

                    $this->_removeResponderFromLead($lead->id, $lead->email, $action->responder_type, $action->target, $action->api_id);

                    break;

                case 'add_campaign' :

                    $this->_addLeadToCampaign($lead->id, $action->target);

                    break;

                default :

                    JPluginHelper::importPlugin('marketingrocket');

                    $dispatcher = JEventDispatcher::getInstance();

                    $dispatcher->trigger('onHandleAction', array($action, $lead) );

                    break;

            }

        }

        

        public static function checkCanBeAddToSequence($sequenceTable, $leadTags){

            $table = $sequenceTable;

            $canAdd = true;

                

            if(!empty($table->send_to_tags)){ // so lets check lead tags



                $tableTags = json_decode($table->send_to_tags);



                if($table->send_to_tags_if == 'any'){ // if any of lead tags are in sequence condition , its ok to add

                    $canAdd = false;

                    foreach ($tableTags as $tableTag){

                        if(in_array($tableTag, $leadTags)){

                            $canAdd = true;

                            break;

                        }

                    }

                }

                else { // all tags must be in lead tags

                    $canAdd = true;

                    if(is_array($tableTags)){

                        foreach ($tableTags as $tableTag){

                            if(!in_array($tableTag, $leadTags)){

                                $canAdd = false;

                                break;

                            }

                        }

                    }

                }

            }

            if(!empty($table->dont_send_to_tags) && $canAdd){ // lets check to block conditions , if user currently dont approved , we will jumb over this step



                 $tableTags = json_decode($table->dont_send_to_tags);



                if($table->dont_send_to_tags_if == 'any'){

                    foreach ($tableTags as $tableTag){

                        if(in_array($tableTag, $leadTags)){

                            $canAdd = false;

                            break;

                        }

                    }

                }

                else {

                    if(is_array($tableTags)){

                        foreach ($tableTags as $tableTag){

                            if(!in_array($tableTag, $leadTags)){

                                $canAdd = true;

                                break;

                            }

                        }

                    }

                }

            }

            

            return $canAdd;

        }

        

        /**

         * 

         * @param string $string

         * @return bollean

         */

        private function _isJson($string) {

            return is_array(json_decode($string,true));

        }

        

        public function handleExistingLeadJobs($lead, $landing){

            $leadCampaigns = $lead->getCampaigns();

            if(in_array($landing->campaign_id, $leadCampaigns)){

                if($landing->convert_again == 'add'){

                    $this->checkSequenceCond($lead, $landing);

                }

                else if($landing->convert_again == 'remove'){

                    $this->_removeLeadFromCampaign($lead->id);

                    $this->_removeResponderFromLead($lead->id, $lead->email , $landing->responder_type, $landing->auto_responder_id);

                }

            }

            if(!in_array($landing->campaign_id, $leadCampaigns)){

                if($landing->convert_from_another == 'add'){

                    $this->checkSequenceCond($lead, $landing);

                }

                else if($landing->convert_from_another == 'remove'){

                    $this->_removeLeadFromCampaign($lead->id);

                    $this->_removeResponderFromLead($lead->id, $lead->email , $landing->responder_type, $landing->auto_responder_id);

                }

            }

        }

        

        public function handleAfterRegisterLeadJobs($lead, $landing){

            // add User To Campaign

            $this->_addLeadToCampaign($lead->id, $landing->campaign_id);



            // Remove Tags

            $this->_removeTagFromLead($lead->id, $landing->removing_tag, $landing->campaign_id);



            // Now Add Tags To User

            $this->_addTagToLead($lead->id, $landing->adding_tag, $landing->campaign_id);





            // check and set the lead status to complete

            if($landing->convert_lead == 1){

                $db = $this->getDbo();

                $query = $db->getQuery(true);

                $query->select('id')->from('#__mrocket_statuses')

                ->where($db->qn('final').' = 1');



                $db->setQuery($query);



                $defaultStatus =  $db->loadResult();

                

//                $lead->lead_status = $defaultStatus;

//                $lead->store();

                

                $this->_setLeadStatus($lead->id, $defaultStatus, $landing->campaign_id);

            }

        }

        

        public function _setLeadStatus($leadId, $statusId, $campaignId) {

            

            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');

            $lead = JTable::getInstance('Lead', 'MarketingrocketTable');

            $lead->load($leadId);

            $lead->setStatus($statusId, $campaignId);

            

        }

        

	public function _addRefCode($lead_id, $check = true){

		$db = $this->getDbo ();

		$item = $this->getItem();

                $session =  @JSession::getInstance('', '');

		if($check === true){

                    $query = $db->getQuery(true);

                    $query->select('*')->from($db->qn ( '#__mrocket_refcodes' ))

                            ->where( $db->qn('lead_id') .' = '.$db->q($lead_id))

                            ->where( $db->qn('landing_id') .' = '.$db->q($item->id))

                    ;

                    $db->setQuery($query);

                    $row = $db->loadObject();

                    if(!empty($row)){

                        $session->set('refcode', $row->ref_code, 'com_marketingrocket');

                        return $row->ref_code;

                    }

		}

                

		$refCode = $this->_randomid(2).time().$this->_randomid(3);

                $session->set('refcode', $refCode, 'com_marketingrocket');

                

		$query = $db->getQuery(true);

		$query->insert ( $db->quoteName ( '#__mrocket_refcodes' ) );

		$query->set ( $db->qn('lead_id') .' = '.$db->q($lead_id));

		$query->set ( $db->qn('landing_id') .' = '.$db->q($item->id));

		$query->set ( $db->qn('ref_code') .' = '.$db->q($refCode));

		$db->setQuery ( $query );

		$db->execute ();

		

		return $refCode;

	}

	public function _addTagToLead($lead_id, $tag_id, $campaign_id = 0){

                if(empty($tag_id))

                    return;

                

                if($this->_isJson($tag_id)){

                    $tag_ids = json_decode($tag_id);

                }

                else {

                    $tag_ids = array($tag_id);

                }

                JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');

                $lead = JTable::getInstance('Lead', 'MarketingrocketTable');

                $lead->load($lead_id);

                

                foreach ($tag_ids as $tag_id ){

                    $lead->addTag($tag_id, $campaign_id);

                }

                

		

		

	}

	public function _removeTagFromLead($lead_id, $tag_id, $campaign_id = 0){

                if(empty($tag_id))

                    return;

                

                

               

                if($this->_isJson($tag_id)){

                    $tag_ids = json_decode($tag_id);

                }

                else {

                    $tag_ids = array($tag_id);

                }

                

                JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');

                

                

                foreach ($tag_ids as $tag_id ){

                    $leadTag = JTable::getInstance('Leadtag', 'MarketingrocketTable');

                    $leadTag->load(array('lead_id' => $lead_id, 'tag_id' => $tag_id,'campaign_id' => $campaign_id));

                    

                    if(!empty($leadTag->id)){

                        $leadTag->delete();

                    }

                }

                

		

	}

	public function _removeLeadFromCampaign($leadId){

		$db = $this->getDbo ();

		$query = $db->getQuery(true);

		$query->delete($db->quoteName ( '#__mrocket_lead_campaigns' ))

		->where($db->qn('lead_id').' = '.$db->q($leadId));

		$db->setQuery($query);

		$db->execute();

	}

	

	private  function _removeResponderFromLead($lead_id, $lead_email, $type, $responder_id, $apiId = 0){



		if($type == '0')

			return false;

		else if($type == 'default'){

                    JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');

                    

                    $lead = JTable::getInstance('Lead', 'MarketingrocketTable');

                    $lead->load($lead_id);

                    $lead->removeResponderFromLead($responder_id);

                  

		}

        else {



            require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';



            $item = $this->getItem();





            $model = JModelLegacy::getInstance("Api", "MarketingrocketModel");

            $api = $model->getItem($apiId);



            JLoader::import('joomla.plugin.helper');

            JPluginHelper::importPlugin('marketingrocket');

            $dispatcher = JEventDispatcher::getInstance();



            try {

                $dispatcher->trigger('onRemoveFromResponder', array(&$api->type, $api, $lead_email, $lead_id, $responder_id) );



            }

            catch (Exception $e){

                require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'marketingrocket.php';

                MarketingrocketHelper::sendSystemMessage($e->getMessage(), $e->getMessage());

            }

            return true;

        }



	}

	public function _addLeadToCampaign($leadId, $campaignId){

                

            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');

            $lead = JTable::getInstance('Lead', 'MarketingrocketTable');

            $lead->load($leadId);

            $lead->addToCampaign($campaignId);

	}

	public function _addResponderToLead($leadId, $leadEmail, $item = null){

        if(empty($item))

            $item = $this->getItem();

		$db = $this->getDbo ();

                

		if($item->responder_type == '0')

			return false;

		else if($item->responder_type == 'default'){

			$query = $db->getQuery(true);

			

			$nullDate	= $db->quote($db->getNullDate());

			$nowDate	= $db->quote(JFactory::getDate('now', JFactory::getConfig()->get('offset'))->toSql(true));

			

			$query->select("b.*")

			->from($db->quoteName ( '#__mrocket_reponders_sequences' ). 'as a')

			->innerJoin('#__mrocket_responder_templates as b ON a.id = b.sequence_id')

			->where('a.id = '.$db->q($item->responder_sequence_id))

			->where('a.published = 1')

			->where('b.published = 1')

			->where('(b.publish_up = '.$nullDate.' OR b.publish_up <= '.$nowDate.')')

			->where('(b.publish_down = '.$nullDate.' OR b.publish_down >= '.$nowDate.')')

                        ->where('b.type = "responder"')

                        ->where('( '.$db->qn('b.split_by').' = 0 OR '.$db->qn('b.must_show_next').' = 1 )')

// 			->where('published = 1')

			;

			$db->setQuery ( $query );

			$founded = $db->loadObjectList();

			if(empty($founded))

				return false;

                // this method can be used in anywhere like plugin so we add address globaly

            JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');



            $sendImmediate = array();



            foreach ($founded as $row){

                try {

                    switch ($row->send_type){

                        case 'after':

                            $sendAfter = (int)$row->send_option;

                            if($sendAfter == 0){

                                $sendImmediate[] = $row->id;

                            }

                            $time = time()+($sendAfter*60);



                            $date = JFactory::getDate($time);



                            break;

                        case 'on_date' :

                            $date = $row->send_option;

                            break;

                        case 'before' :

                            $webinarTable = JTable::getInstance('Webinar', 'MarketingrocketTable', array());

                            $webinarTable->load($row->webinar_id);



                            $date = JFactory::getDate(strtotime($webinarTable->start_time), $webinarTable->timezone);

                            $timeData = explode(':', $row->send_option);

                            $date->modify('-'.$timeData[0].' day');

                            $date->modify('-'.$timeData[1].' hour');

                            break;

                        case 'rough':

                            $responderSendTimeData = explode('|', $row->send_option);



                            $clockData = explode(':', $responderSendTimeData[1]);



                            $date = JFactory::getDate('now', JFactory::getConfig()->get('offset'));

                            $date->setTime($clockData[0], $clockData[1]);



                            if($responderSendTimeData[0] > 0)

                                $date->modify('+ '.$responderSendTimeData[0]."days");



                            $date->setTimezone(new DateTimeZone('UTC'));





                            break;

                    }

                }

                catch (Exception $e){

                    $mailer = JFactory::getMailer();



                    // Build email message format.

                    $mailer->IsHTML();

                    $mailer->setSender(array(JFactory::getApplication()->getCfg('mailfrom'), JFactory::getApplication()->getCfg('fromname')));

                    $mailer->setSubject('Marketing Rocket Error For Set Responder To Lead');

                    $mailer->setBody('Error :'.$e->getMessage().' at responder:'.$row->name);



                    $mailer->addRecipient(JFactory::getApplication()->getCfg('mailfrom'));

                    $mailer->SetFrom(JFactory::getApplication()->getCfg('mailfrom'));

                    $rs	= $mailer->Send();

                    continue;

                }







                $leadCron  = JTable::getInstance('Leadcrons', 'MarketingrocketTable');



                $leadCron->lead_id = $leadId;

                if(is_object($date))

                   $leadCron->cron_date = $date->format("Y-m-d H:i:s", true);

                else

                   $leadCron->cron_date = $date;



                $leadCron->cron_job = 'default';

                $leadCron->responder_id = $row->id;



                if($leadCron->check()){

                    $leadCron->store();



                    if(!empty($row->split_by)){

                        $table = JTable::getInstance('Responder', 'MarketingrocketTable');

                        $table->bind($row);

                        $table->must_show_next = 0;

                        $table->store();



                        $targetTable = $table->getSplit();

                        $targetTable->must_show_next = 1;

                        $targetTable->store();



                    }



                }



            }

                        

            if(!empty($sendImmediate)){

                $cronModel = JModelLegacy::getInstance('Cron', 'MarketingrocketModel');

                if(!empty($cronModel)) // when this called from admin and maybe its bulk , so it will take time

                    $cronModel->sendZeroDays($leadId, $sendImmediate);

            }



			

			return true;

			

		}

		else {



                require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';



                if(empty($item))

                    $item = $this->getItem();



                $apiId = $item->api_id;

                if(empty($apiId))

                    return array();





                $model = JModelLegacy::getInstance("Api", "MarketingrocketModel");

                $api = $model->getItem($apiId);



                JLoader::import('joomla.plugin.helper');

                JPluginHelper::importPlugin('marketingrocket');

                $dispatcher = JEventDispatcher::getInstance();



                try {

                    $dispatcher->trigger('onAddToResponder', array(&$api->type, $api, $leadEmail, $leadId, $item) );



                    MarketingrocketHelper::log('responder', 'add', JText::_('COM_MARKETINGROCKET_LOG_ADDED_TO_'.strtoupper($item->responder_type)), $leadId);



                }

                catch (Exception $e){

                    require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'marketingrocket.php';

                    MarketingrocketHelper::sendSystemMessage($e->getMessage(), $e->getMessage());

                }

			    return true;

		}

	}

	public function _randomid($count=false)

	{

		if($count == FALSE)

			$count = 5;

		$text = "";

		$possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

		$possible = str_split($possible);

	

		for ($i = 0; $i < $count; $i++) {

			shuffle($possible);

			$text .= $possible[0];

		}

		return $text;

	}

	public function makeSession($ref = null){

		if($ref == null){

			$ref = $this->_randomid(2).time().$this->_randomid(3);

		}

		$session =& JFactory::getSession();

		$session->set( 'MR-refcode', $ref);

		return $ref;

	}

        /**

         * check the refrence and validate it , if $ref param is empty it will check the session and will get ref code from here , and also if 

         * $item param is not null and ref is not valid, it will check the public_accsess of $item and if its equal to Zero it will thorw 404 not found error

         * @param string $ref

         * @param mixed Object(landing row)|null $item 

         * @return mixed false if ref is not valid or string if found the ref code

         */

	public function checkRef($ref, $item = null){

                $session =  @JSession::getInstance('','');

                if(empty($ref)){

                    if($session->has('refcode', 'com_marketingrocket')){

                        $ref = $session->get('refcode', false, 'com_marketingrocket');

                    }

                }

                $db = $this->getDbo ();

                $query = $db->getQuery(true);

                $query->select("b.ref_code")

                ->from($db->quoteName ( '#__mrocket_leads' ) .' AS a')

                ->join('INNER', $db->qn('#__mrocket_refcodes') . ' AS b ON a.id = b.lead_id')

                ->where('b.ref_code = '.$db->q($ref))

                ->where('a.published = 1')

                ->where('a.is_temp = 0')

                ;

                $db->setQuery ( $query );

                $ref = $db->loadResult();



                if(empty($ref)){

                    if($item && $item->public_accsess == 0){

                        // TODO check for correct ref code , that comes from correct landing . or just if its payment page

                        return JError::raiseError(404, JText::_('Not Found'));

                    }

                    return false;

                }

                $session->set('refcode', $ref, 'com_marketingrocket');

                return $ref;

		

	}

        /*

         * return @array $title = title for <a> tag or for case of canceling pay is message for reirect

         */

	public function returnNextStepUrl($item, $ref = 'ref', $searchField = 'after_filling', $checkAction = true){

		$app    = JFactory::getApplication();

		$href= "";

		$title = "";



        if($checkAction) {



            $db = $this->getDbo();

            $q = $db->getQuery(true);

            $q->select('*')->from('#__mrocket_actions')

                ->where($db->qn('landing_id') . ' = ' . $db->q($item->id))

                ->where($db->qn('action') . ' = ' . $db->q('open_landing'))

                ->order($db->qn('order') . ' ASC');

            $db->setQuery($q);

            $res = $db->loadObjectList();

            if (!empty($res)) {



                $leadModel = JModelLegacy::getInstance('Lead', 'MarketingrocketModel');

                $leadRow = $leadModel->getLeadByRefCode($ref);

                if (!empty($leadRow)) {

                    $lead = $leadModel->getTable();

                    $lead->bind($leadRow);

                    foreach ($res as $row) {

                        if ($this->actionConditionCheck($lead, $row) === true) {

                            $landingId = $row->target;

                            $newItem = $this->getItem($landingId, 'id');

                            $href = $newItem->alias;

                            $href = 'index.php?option=com_marketingrocket&view=landing&alias=' . $href . '&ref=' . $ref;

                            $href = JRoute::_($href);

                            return array($title, $href);

                        }

                    }

                }





            }

        }



		if($item->$searchField == 'menu_item'){

			$menus		= $app->getMenu();

			$menuItem = $menus->getItems(array('id'), $item->menu_item, true);

			$href = $this->prepareMenu($menuItem);

            if($searchField == 'after_pay') // we dont have title here

                $title        = htmlspecialchars($menuItem->title, ENT_COMPAT, 'UTF-8', false);

		}

		else if($item->$searchField == 'redirect_url')

		{

			$href = $item->redirect_url;

		}

		else if($item->$searchField == 'message'){

            if($searchField == 'after_pay' && $checkAction){

                $title = $item->pay_message;

                $target = $this->getItemByRefCode($ref);

                $href = 'index.php?option=com_marketingrocket&alias='.$target->alias.'&ref='.$ref;



                $href = JRoute::_($href);

            }

            else {

                $href = 'index.php?option=com_marketingrocket&view=message&id='.$item->id.'&ref='.$ref.'&'.JSession::getFormToken() .'=1';

            }

                        

		}

		else { // Landing Page

             if($searchField == 'after_pay'){

                $href = $this->getNextStepLandingUrl($item, 'pay_to_landing_page');

             }

             else {

                 $href = $this->getNextStepLandingUrl($item);

             }

	

			$href = 'index.php?option=com_marketingrocket&view=landing&alias='.$href.'&ref='.$ref;

	

			//$href = JRoute::_($href);

		}

		return array($title, $href);

	}

	public function getItemByRefCode($ref){

                if(!isset($this->_items[$ref])){

                    $db = $this->getDbo ();

                    $query = $db->getQuery(true);

                    $query->select("b.*")

                    ->from($db->quoteName ( '#__mrocket_refcodes' ) .' AS a')

                    ->join('INNER', $db->qn('#__mrocket_landings'). ' AS b ON a.landing_id = b.id')

                    ->where('ref_code = '.$db->q($ref))

                    ;

                    $db->setQuery ( $query );

                    $this->_items[$ref] = $db->loadObject();

                }

		return  $this->_items[$ref];

	}

	public function unMarkAsTemporary($refCode){

		$db = $this->getDbo();

		$query = $db->getQuery(true);

			

		$query->update ( $db->quoteName ( '#__mrocket_leads' ) .' AS a');

		$query->innerJoin($db->quoteName ( '#__mrocket_refcodes' ) .' AS b ON a.id = b.lead_id');

		$query->set ( $db->qn('a.is_temp') .' = 0');

		$query->set ( $db->qn('a.published') .' = 1');

                $query->where('b.ref_code = '.$db->q($refCode));

		

		$db->setQuery ( $query );

		$db->execute ();

		

		$item = $this->getItemByRefCode($refCode);

		$this->increaseStat($item->id, 'submission');

	}

	public function increaseStat($landing_id, $type = 'visit'){

		$db = $this->getDbo();

		$query = $db->getQuery(true);

                $date = JFactory::getDate('now', JFactory::getConfig()->get('offset'));

                

		$query->select('id')

		->from( $db->quoteName ( '#__mrocket_daily_stat' ))

		->where($db->qn('landing_id'). ' = '.$db->q($landing_id))

		->where($db->qn('date'). ' = '.$db->q($date->format('Y-m-d', true)));

		$db->setQuery ( $query );

		$res = $db->loadObject();

		if(empty($res)){

			$query = $db->getQuery(true);

			$query->insert ( $db->quoteName ( '#__mrocket_daily_stat' ));

			if($type == 'visit')

				$query->set ( $db->qn('visit') .' = 1');

			else

				$query->set ( $db->qn('submission') .' = 1');

			$query->set ( $db->qn('landing_id') .' = '.$db->q($landing_id));

			$query->set ( $db->qn('date') .' = '.$db->q($date->format('Y-m-d', true)));

			$db->setQuery ( $query );

			$db->execute ();

		}

		else {

			$query = $db->getQuery(true);

			$query->update ( $db->quoteName ( '#__mrocket_daily_stat' ));

			if($type == 'visit')

				$query->set ( $db->qn('visit') .' = visit+1');

			else 

				$query->set ( $db->qn('submission') .' = submission+1');

			$query->where('landing_id = '.$db->q($landing_id));

			$query->where ( $db->qn('date') .' = '.$db->q($date->format('Y-m-d', true)));

			$db->setQuery ( $query );

			$db->execute ();

		}





		if($type == 'submission' && JComponentHelper::getParams('com_marketingrocket')->get('high_registration_warning') > 0){



		    $lastData = explode('|', JComponentHelper::getParams('com_marketingrocket')->get('lead_register_stats'));

            $date = JFactory::getDate('now', JFactory::getConfig()->get('offset'));



            $todayDate = $date->format('Y-m-d');

            $lastData[1] = (int) $lastData[1];

            if($todayDate != $lastData[0]){

                $lastData[1] = 0;

            }

            $lastData[1] = $lastData[1]+1;



            $string = $todayDate.'|'.$lastData[1];



            $params = JComponentHelper::getParams('com_marketingrocket');

            $params->set('lead_register_stats', $string);

            $db = JFactory::getDbo();

            $query = $db->getQuery(true);



            // Build the query

            $query->update('#__extensions AS a');

            $query->set('a.params = ' . $db->quote((string)$params));

            $query->where('a.element = "com_marketingrocket"');



            // Execute the query

            $db->setQuery($query);

            $db->execute();



            if($lastData[1] == JComponentHelper::getParams('com_marketingrocket')->get('high_registration_warning')){

                $cronModel = JModelLegacy::getInstance('Cron','MarketingrocketModel');

                $cronModel->sendHighRegistrationWarning();

            }

        }

		

		

	}

	public function prepareMenu($item){

		$app = JFactory::getApplication();

		$item->flink = $item->link;

		switch ($item->type)

		{

			case 'separator':

			case 'heading':

				// No further action needed.

				continue;

	

			case 'url':

				if ((strpos($item->link, 'index.php?') === 0) && (strpos($item->link, 'Itemid=') === false))

				{

					// If this is an internal Joomla link, ensure the Itemid is set.

					$item->flink = $item->link . '&Itemid=' . $item->id;

				}

				break;

	

			case 'alias':

				// If this is an alias use the item id stored in the parameters to make the link.

				$item->flink = 'index.php?Itemid=' . $item->params->get('aliasoptions');

				break;

	

			default:

				$router = $app::getRouter();

	

				if ($router->getMode() == JROUTER_MODE_SEF)

				{

					$item->flink = 'index.php?Itemid=' . $item->id;

				}

				else

				{

					$item->flink .= '&Itemid=' . $item->id;

				}

				break;

		}

			

		if (strcasecmp(substr($item->flink, 0, 4), 'http') && (strpos($item->flink, 'index.php?') !== false))

		{

	

	

			$item->flink = JRoute::_($item->flink, true, $item->params->get('secure'));

	

		}

		else

		{

			$item->flink = JRoute::_($item->flink);

		}

		return $item->flink;

	

	}

	public function getTemp($type = 'preview'){

            

            $id = JFactory::getApplication()->input->getInt('id');

            

            $db = $this->getDbo ();

            $query = $db->getQuery(true);

            $query->select("*")

            ->from($db->quoteName ( '#__mrocket_temp' ))

                    ->where('id >= '.$id)

                    ->where($db->qn('save_type').' = '.$db->q($type))

            ;

           

            $db->setQuery ( $query );

            return  $db->loadObject();

	}

        

        public function validate($form, $data, $group = null)

	{



            $ret = parent::validate($form, $data, $group);

            if($ret !== false){

                

                $email = $ret['email'];

                $pattern = '/^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\.[a-zA-Z0-9-.]+$/';

                if(isset($ret['email']) && !preg_match($pattern, $email)){

                    $this->setError('Email Is Wrong');

                    return false;

                }

                if(JFactory::getApplication()->input->getCmd('view') == 'preview')

                        $item = $this->getTemp();

                else 

                        $item = $this->getItem();

                

                if(isset($ret['answer_seq_54321']) && !empty($ret['answer_seq_54321']))

                    return false;

                else if(isset($ret['answer_seq_54321']))

                    unset($ret['answer_seq_54321']);

                

                $jsonData = $item->form_json;



                $jsonData = json_decode($jsonData);



                $type = '';

                

                JLoader::import('joomla.plugin.helper');

                JPluginHelper::importPlugin('marketingrocket');

                $dispatcher = JEventDispatcher::getInstance();

                

                if($item->have_paypal == 1){

                    

                    $paymentApiId = (int)$item->paypal_account;

                    

                    $type = MarketingrocketModelApi::getType($paymentApiId);



                }

                $dispatcher->trigger('onValidateForm', array($form, $data, $type, &$ret) );

            }

            return $ret;

        }

        

    public function getMenuUrl(){

		$db		= $this->getDbo();

		$query	= $db->getQuery(true);

		$query->select(array('a.path', 'a.home'))

		->from($db->quoteName('#__menu').' AS a')

		->join('INNER', '#__extensions AS b ON a.component_id = b.extension_id')

		->where('b.name = "com_marketingrocket" and a.published = 1')

		->where('a.link = '.$db->q('index.php?option=com_marketingrocket&view=seo'))

		;

		$db->setQuery($query);

		return $db->loadAssoc();

	}

	

}

