<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
use Joomla\Registry\Registry;
class MarketingrocketModelCron extends JModelForm
{
	/* (non-PHPdoc)
	 * @see JModelForm::getForm()
	 */
	public function getForm($data = array(), $loadData = true) {
		// TODO Auto-generated method stub
		
	}
        
        public function getQuerySelect(){
            return $this->_getQuerySelect();
        }
        
        private function _getQuerySelect(){
            $db = $this->getDbo ();
           
		
		$query = $db->getQuery(true);
		$query->select(array($db->qn('a.id' , 'cron_id'),
                    $db->qn('a.body', 'sent_body'),
                    $db->qn('a.lead_id', 'lead_id'),
                    $db->qn('a.modified', 'cron_last_modified'),
                    'b.*',
                    $db->qn('c.name', 'campaign_name'),
                    $db->qn('lead.form_data'),
                    $db->qn('lead.first_name'), 
                    $db->qn('lead.last_name'),
                    $db->qn('lead.email'),
                    $db->qn('lead.created', 'register_date'),
                    $db->qn('ref_code'),
                    $db->qn('respondersequence.adding_tag_end'),
                    $db->qn('respondersequence.remove_tag_end'),
                    ))
                        
		->from($db->quoteName ( '#__mrocket_leads_cron' ) .' AS a')
		->join('INNER', $db->qn('#__mrocket_responder_templates') . ' AS b ON a.responder_id = b.id' )
		->join('LEFT', $db->qn('#__mrocket_reponders_sequences') . ' AS respondersequence ON b.sequence_id = respondersequence.id' )
		->join('LEFT', $db->qn('#__mrocket_campaign') .' AS c ON respondersequence.campaign_id = c.id')
        ->join('INNER', $db->qn('#__mrocket_leads') .' AS lead ON a.lead_id = lead.id')
//		->join('INNER', $db->qn('#__mrocket_landings') .' AS landing ON lead.landing_id = landing.id')
		->join('INNER', $db->qn('#__mrocket_refcodes') .' AS ref ON ref.lead_id = a.lead_id')
		->group('cron_id')
		->order('RAND()')
		->where('a.is_done = 0')
		->where('b.published = 1')
        ->where('(lead.is_temp = 0 OR b.sequence_id = -1 OR b.type = "opt_in")')
		;
//            if($includeTemp){
//
//            }
//            else {
//                $query->join('INNER', $db->qn('#__mrocket_leads') .' AS lead ON a.lead_id = lead.id AND lead.is_temp = 0');
//            }
            
            return $query;
        }
        
        private function _makeeDataReady($data){
            $db = $this->getDbo();
            
            $readyData = array();
                
            $leadsTags = array();

            require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'tables'.DS.'sequence.php';
            require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'tables'.DS.'lead.php';
            require_once 'landing.php';

            $blockedCronsArray = array();

            $leadTable = JTable::getInstance('Lead', 'MarketingrocketTable');
            foreach ($data as $row){

                $leadId = $row->lead_id;
                // check for bug
//                    if(empty($row->ref_code) && empty($leadsTags[$leadId])){
//                        $leadTable->reset();
//                        $leadTable->bind(array('id' => $leadId));
//                        
//                        $row->ref_code = $leadTable->addRefCode();
//                    }

                if(in_array($row->cron_id, $blockedCronsArray))
                    continue;
                $table = JTable::getInstance('Sequence', 'MarketingrocketTable');
                $table->load($row->sequence_id);


                if(!isset($leadsTags[$leadId])){

                    $leadTable->reset();
                    $leadTable->bind(array('id' => $leadId));

                    $leadsTags[$leadId] = $leadTable->getTags();
                }
                $leadTags = $leadsTags[$leadId];



                $canAdd = MarketingrocketModelLanding::checkCanBeAddToSequence($table, $leadTags);

                if($canAdd == true){
                    $readyData[] = $row;
                }
                else { // remove all emails 
                    $q = $db->getQuery(true);
                    $q->select('id')->from('#__mrocket_responder_templates')
                            ->where('sequence_id = '.$db->q($row->sequence_id))
                            ;
                    $db->setQuery($q);

                    $mostDeleteIds = $db->loadColumn();

                    $blockedCronsArray = array_merge($blockedCronsArray, $mostDeleteIds);

                    $q = $db->getQuery(true); 
                    $q->delete('#__mrocket_leads_cron')->where('responder_id IN ('.implode(',', $mostDeleteIds).')')
                        ->where('lead_id = '.$db->q($leadId))
                        ;

                    $db->setQuery($q);
                    $db->execute();
                }
            }
            return $readyData;
        }
        
    public function sendZeroDays($leadId, $responders){
        $db = $this->getDbo ();
        $query = $this->_getQuerySelect();
        $query->where($db->qn('a.lead_id').' = '.$db->q($leadId));

        $query->where($db->qn('a.responder_id').' IN ('.  implode(',', $responders).')');


        $db->setQuery ( $query);
        $data = $db->loadObjectList();

        $readyData = $this->_makeeDataReady($data);

        $this->sendCronsEmail($readyData);
    }

    public function sendHighRegistrationWarning(){
        $row = new stdClass();
        $row->subject = JText::_('COM_MARKETINGROCKET_HIGH_REGISTRATION_WARNING_SUBJECT');
        $row->body = JText::_('COM_MARKETINGROCKET_HIGH_REGISTRATION_WARNING_BODY');


        require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';

        $url = MRRoute::createFrontRoute('');

        $adminUrl = $url.'administrator/index.php?option=com_marketingrocket';

        $row->body = str_replace('<a>', '<a href="'.$adminUrl.'">', $row->body);
        $row->body = str_replace('{administartor_link}', $adminUrl, $row->body);


        $toEmail = JComponentHelper::getParams('com_marketingrocket')->get('error_email_reciver', null);
        if(empty($toEmail))
            $toEmail = JFactory::getApplication()->get('mailfrom');

        $row->email = $toEmail;

        $row->from_email= $toEmail;
        $row->from_name = $toEmail;
        $row->type = 'pre';


        $this->sendCronsEmail(array($row));


    }

        
	public function sendCrons($limit = null){
        if(empty($limit))
            $limit = JComponentHelper::getParams('com_marketingrocket')->get('cron_number_of_email', 50);
		
//                $date = JFactory::getDate('now', JFactory::getConfig()->get('offset'));
        $date = JFactory::getDate();
        $db = $this->getDbo ();
                $query = $this->_getQuerySelect();
                $query->where($db->qn('cron_date').' <= '.$db->q($date->toSql(true)));
        $db->setQuery ( $query, 0,  $limit);
        $data = $db->loadObjectList();
        if(empty($data))
            return false;


        $readyData = $this->_makeeDataReady($data);
        $this->sendCronsEmail($readyData);
        return true;
		
	}


	public function sendCronsEmail($data){
            
        require_once 'landing.php';
            
		$db = $this->getDbo ();
		set_time_limit(0);
		
		$locationOfJoomla = JURI::root(true);
                $urlPatch = JUri::getInstance();
		$joomlaHost = $urlPatch->getHost();
                
//                $url = JURI::root();
                require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';
                $url = MRRoute::createFrontRoute('');
                $api = false;
                $selectOption = JComponentHelper::getParams('com_marketingrocket')->get('send_mail_by');
                if(!empty($selectOption)){
                    require_once 'api.php';
                    $paiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
                    $api = $paiModel->getItem($selectOption);
                }
                $attachmentsModel = JModelLegacy::getInstance('ResponderAttachment', 'MarketingrocketModel', array('ignore_request' => true));
                require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'tables'.DS.'lead.php';
                
                $leadTable = JTable::getInstance('Lead', 'MarketingrocketTable');
                
                $leadFormData = array();
                
                $landingModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel', array('ignore_request' => true));
                $leadData = array();

		        foreach ($data as $row){

                        if(!isset($leadFormData[$row->lead_id]) && !empty($row->lead_id)){
                            $leadTable->reset();
//                            $leadTable->bind(array('id' => $row->lead_id));
                            $leadTable->load($row->lead_id);
                            if($leadTable->recieve_email == '0'){ // this email must not be send , so we will delete it
                                $leadsCron = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
                                $leadsCron->load($row->cron_id);
                                $leadsCron->delete();
                                continue;
                            }
                            $leadData[$row->lead_id] = $leadTable;
                            $leadFormData[$row->lead_id] = $leadTable->getFormData();
                        }
                        if(!empty($row->lead_id)) {
                            $row->lead_detail = $leadData[$row->lead_id];
                            $row->form_data = $leadFormData[$row->lead_id];
                        }
                        $form_data = $leadFormData[$row->lead_id];

                        $subject = $this->preparSubject($row->subject, $row, $form_data);

                        $salt = JComponentHelper::getParams('com_marketingrocket')->get('salt','');
                        $rowRef = md5($salt.time().uniqid());

                        $body = $this->prepareBody($row, $form_data, $url, $rowRef);

                        $attachments = array();
						if(isset($row->id))
						{	
							$attachments = $attachmentsModel->getAttachments($row->id);
						}	


                        if(!empty($api)){
//                             die('ok');
                            try {
                                $type = $api->type;
                                $res = true;
                                JLoader::import('joomla.plugin.helper');
                                JPluginHelper::importPlugin('marketingrocket');
                                JPluginHelper::importPlugin('system');
                                JPluginHelper::importPlugin('user');
                                $dispatcher = JEventDispatcher::getInstance();
                                
                                // for notification emails
                                if(isset($row->send_to_email))
                                    $mails = explode(',', $row->send_to_email);
                                else     
                                    $mails = explode(',', $row->email);
                                
                                foreach ($mails as $key => $email){
                                    $email = trim($email);
                                    if(empty($email))
                                        continue;
                                    $mails[$key] = $email;
                                }

                                foreach ($mails as $key => $mail){
                                    if(empty($mail))
                                        unset($mails[$key]);
                                }
                                if(empty($mails)){
                                    throw new Exception('Email Is Empty ! id : '.$row->cron_id);
                                }
                                $body = str_replace('/en//en/', '/en/', $body);   
                                
                                $dispatcher->trigger('sendEmail', array(
                                        &$type, // type
                                        $api, // api
                                        $body, // body
                                        $subject, // subject
                                        $row->from_email, // from email
                                        $row->from_name, // from name
                                        $mails, // to email
                                        $rowRef, // ref
                                        $row, // db row
                                        $attachments, // attachments
                                        &$res // obj resualt
                                    ) 
                                );
//                              
                                
                            }
                            catch (Exception $e){
                                 $res = new stdClass();
                                 $res->error = true;
                                 $res->code = $e->getCode();
                                 $res->name = '';
                                 $res->message = $e->getMessage();
                            
                            }
                            if(is_object($res) && !empty($res->error)){
                                $rowDate = JFactory::getDate();
                                
                                $configErrorFrequency = (int)JComponentHelper::getParams('com_marketingrocket')->get('send_error_frequency', 24);
                                
                                if($configErrorFrequency < 24)
                                    $rowDate->modify('-'.$configErrorFrequency.' hour');
                                else 
                                    $rowDate->modify('-1 day');
                                
                                if($row->cron_last_modified != '0000-00-00 00:00:00' 
                                        && JFactory::getDate(strtotime($row->cron_last_modified))->getTimestamp() > $rowDate->getTimestamp()) // per user responder sent 1 error
                                    continue;
                                $res->message .=  '<br /> Subject : '.$subject.'<br /> Recivers : '.
                                        implode(',', $mails).' <br /> From Email :'.$row->from_email.'<br /> From Name :'.
                                        $row->from_name.' Responder Id : '.$row->id .' <br /> Responder Name : '.$row->name.'<br /> Body :'.$body;
                                
                                require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'marketingrocket.php';
                                MarketingrocketHelper::sendSystemMessage('Responder Send Error', $res->message);
                                
                                
                                if(!empty($row->cron_id))
                                {
                                    JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
                                    $leadCrons = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
                                    $leadCrons->load($row->cron_id);

                                    $leadCrons->modified = 1;
                                    $leadCrons->store();
                                }
                                
                                
                                $lastSentLog = JComponentHelper::getParams('com_marketingrocket')->get('last_sent_log', '2016-01-01');
                                
                                $lastSentLog = JFactory::getDate(strtotime($lastSentLog));
                                
                                $nowDate = JFactory::getDate()->getTimestamp();
                                
                                $calDate = ($configErrorFrequency*60*60)+$lastSentLog->getTimestamp();
                                if($calDate > $nowDate){
                                    continue;
                                }
                                $mailer = JFactory::getMailer();
                                
                               
		 		
                                // Build email message format.
                                
                                $dashBoardUrl = JUri::base().'/administrator/index.php?option=com_marketingrocket#show_popup';
                                
                                $mailer->IsHTML();
                                $mailer->setSender(array(JFactory::getApplication()->getCfg('mailfrom'), JFactory::getApplication()->getCfg('fromname')));
                                $mailer->setSubject('Warning: Your Marketing Rocket Installation has send errors.');
                                $mailer->setBody('You have one or more email sending errors in your Marketing Rocket installation at "'.JUri::base().'"<br/>.'
                                        . ' Please review these errors as soon as possible in the attached document, and resolve or remove any invalid emails in your lead system. You will only receive this message'
                                        . ' maximum of once per day, even if you generate further sending errors. You may review your errors in the Marketing Rocket Message System on the Marketing Rocket Dashboard:'
                                        . ' <a href="'.$dashBoardUrl.'">'.$dashBoardUrl.'</a>');

                                $toEmail = JComponentHelper::getParams('com_marketingrocket')->get('error_email_reciver', null);
                                if(empty($toEmail))
                                    $mailer->addRecipient(JFactory::getApplication()->getCfg('mailfrom'));
                                else
                                    $mailer->addRecipient($toEmail);
                                $rs	= $mailer->Send();
                                
                                
                                $params = JComponentHelper::getParams('com_marketingrocket');
                                $params->set('last_sent_log', JFactory::getDate()->toSql(true));
                                $db = JFactory::getDbo();
                                $query = $db->getQuery(true);

                                // Build the query
                                $query->update('#__extensions AS a');
                                $query->set('a.params = ' . $db->quote((string)$params));
                                $query->where('a.element = "com_marketingrocket"');

                                // Execute the query
                                $db->setQuery($query);
                                $db->execute();
                                
                                
                                
                                
                                continue;
                            }
                            
                        }
                        else {
                            $dom = new DOMDocument();
                            
                            if(strpos($body, '<head>') === false){
                                $body = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head><body>'.$body.'</body></html>';
                            }
                            @$dom->loadHTML($body);


                            $allA = $dom->getElementsByTagName('a');
                            for ($i = 0;$i < $allA->length;$i++){
                                $rowA = $allA->item($i);
                                $href = $rowA->getAttribute('href');
                                if(strpos($href, 'mailto:') !== false)
                                    continue;
                                $rowA->setAttribute(
                                    'href',
                                     $url.JRoute::_('index.php?option=com_marketingrocket&task=redirect.go&url='.base64_encode($href).'&ref='.$rowRef, false)
                                    );
                            }



                            $body = $dom->saveHTML();

                            $body .= '<img style="width:1px;height:1px!important;min-height:1px;" src="'.$url.JRoute::_('index.php?option=com_marketingrocket&task=redirect.counter&ref='.$rowRef).'" />';
                            $body = str_replace('/en//en/', '/en/', $body);

                            // Get the Mailer
                            $mailer = JFactory::getMailer();

                            // Build email message format.
                            $mailer->setSender(array($row->from_email, $row->from_name));
                            $mailer->setSubject(stripslashes($subject));
                            $mailer->setBody($body);
                            $mailer->IsHTML(true);
                            
                            // for notification emails
                            if(isset($row->send_to_email) && $row->send_to_email != '')                                
								$mails = explode(',', $row->send_to_email);                            
							else if(isset($row->lead_detail))
								$mails = explode(',', $row->lead_detail->email);								
							else 								
								$mails = explode(',', $row->email);  
								
                            foreach ($mails as $mail)
                                $mailer->addRecipient(trim($mail));
                            
                            foreach ($attachments as $attachment){
                                 $mailer->addAttachment( JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'com_marketingrocket'.
                                    DIRECTORY_SEPARATOR.'attachments'.DIRECTORY_SEPARATOR.$attachment->file_name, $attachment->orginal_file_name);
                            }

                            $rs	= $mailer->Send();
                            // Check for an error
                            if ($rs instanceof Exception)
                            {

                            	//die('error');
                                echo $rs->getMessage().'<br />';
                                $mailer = JFactory::getMailer();
                                
                               
		 		
                                // Build email message format.
                                $mailer->IsHTML();
                                //$mailer->setSender(array(JFactory::getApplication()->getCfg('mailfrom'), JFactory::getApplication()->getCfg('fromname')));
								$mailer->setSender(array($row->from_email, $row->from_name));
                                $mailer->setSubject('Marketing Rocket Error During Send Email');
                                $mailer->setBody('Error :'.$rs->getMessage());

                                //$mailer->addRecipient(JFactory::getApplication()->getCfg('mailfrom'));
								foreach ($mails as $mail)
									$mailer->addRecipient(trim($mail));
                                //$mailer->SetFrom(JFactory::getApplication()->getCfg('mailfrom'));
								$mailer->SetFrom($row->from_email);
                                $rs	= $mailer->Send();
                                continue;
                            }
                        }



                        if(empty($row->cron_id))
                            continue;

                        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
                        $leadCrons = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
                        $leadCrons->load($row->cron_id);
                        
                        $leadCrons->is_done = 1;
                        $leadCrons->ref = $rowRef;
                        
                        $leadCrons->body = $body;
                        
                        $leadCrons->store();
                        // check to see all lead emails are sent or not
                        if($row->adding_tag_end != 0 || $row->remove_tag_end != 0){
                            $q = $db->getQuery(true);
                            $q->select('COUNT(b.id)')
                                    ->from($db->qn('#__mrocket_responder_templates', 'a'))
                                    ->innerJoin($db->qn('#__mrocket_leads_cron', 'b'). ' ON a.id = b.responder_id')
                                    ->where('a.sequence_id = '.$row->sequence_id)
	                                ->where('b.lead_id = '.$row->lead_id)
                                    ->where('b.is_done = 0')
                                    ;
                            
                            $db->setQuery($q);
                            $res = $db->loadResult();
                            if($res == 0){
                                if($row->adding_tag_end != 0){
                                    $landingModel->_addTagToLead($row->lead_id, $row->adding_tag_end);
                                }
                                if($row->remove_tag_end != 0){
                                    $landingModel->_removeTagFromLead($row->lead_id, $row->remove_tag_end);
                                }
                            }
                        }

			
		}

	}
	public function sendNotificationEmail($redCode){
		$db = $this->getDbo ();
		
		$query = $db->getQuery(true);
		$query->select(array(
                    'b.*',
                    $db->qn('a.lead_id'),
                    $db->qn('c.name', 'campaign_name'),
                    $db->qn('lead.form_data'),
                    $db->qn('lead.first_name'),
                    $db->qn('lead.last_name'),
                    $db->qn('lead.created', 'register_date'),
                    $db->qn('landing.form_name'),
                    $db->qn('landing.notification'),
                    $db->qn('landing.notification_email','send_to_email'),
                ))
		->from($db->quoteName ( '#__mrocket_refcodes' ) .' AS a')
		->join('INNER', $db->qn('#__mrocket_responder_templates') . ' AS b ON b.type = '.$db->q('pre') )
		
		->join('INNER', $db->qn('#__mrocket_leads') .' AS lead ON a.lead_id = lead.id')
		->join('INNER',  $db->qn('#__mrocket_landings') .' AS landing ON a.landing_id = landing.id')
		->join('INNER', $db->qn('#__mrocket_campaign') .' AS c ON landing.campaign_id = c.id')
		->where('a.ref_code = '.$db->q($redCode))
		;
		$db->setQuery ( $query );
		
	
		$data = $db->loadObjectList();
		
		if($data[0]->notification == '1')
			$this->sendCronsEmail($data);
                
	}
	
	public function sendStats($date){
		$db = $this->getDbo ();
		$query = $db->getQuery(true);
		$query->select('SUM(a.visit) as visit, SUM(a.submission) as submission, b.title as landing_name, c.name as campaing_name')
		->from($db->quoteName ( '#__mrocket_daily_stat' ) .' AS a')
		->join('INNER', '#__mrocket_landings as b ON a.landing_id = b.id')
		->join('INNER', '#__mrocket_campaign as c ON b.campaign_id = c.id')
		->where('a.date >= '.$db->q($date))
		->order('campaign_id ASC , date ASC')
                ->group('a.landing_id')
                        ;
		$db->setQuery($query);
		$data = $db->loadObjectList();
		
		$firstRow = $data[0]->campaing_name;
		$returnData = '
				<style>
					.MR_EMAIL > table{
						border-collapse :collapse;
					}
	
					td {
					    border: 1px solid #808080;
						text-align : center;
					}
				</style>
				<div class="MR_EMAIL">
				<h1>Marketing Rocket Report : From '.$date.' </h1>
				<p>Campaign :'.$firstRow.'</p>
				<table style="width: 100%; border-collapse: collapse;">
					<tr>
						<th>Lanidng Page</th>
						<th>Visits</th>
						<th>Submissions</th>
					</tr>';
		$visitCounts = $submissiontCount = $i = 0 ; 
		foreach ($data as $row){
			if($row->campaing_name != $firstRow){
				$firstRow = $row->campaing_name;
				$returnData .= '
						<tfoot>
							<tr style="background : #E3E3E3">
								<td>Total</td>
								<td>'.$visitCounts.'</td>
								<td>'.$submissiontCount.'</td>
							</tr>
						</tfoot>
						</table>
						<p>Campaign : '.$firstRow.'</p>
						<table style="width: 100%; border-collapse: collapse;">
							<tr>
								<th>Lanidng Page</th>
								<th>Visits</th>
								<th>Submissions</th>
							</tr>';
				$visitCounts = $submissiontCount = $i  = 0;
			}
			$i++;
			$visitCounts = $visitCounts+$row->visit;
			$submissiontCount = $submissiontCount+$row->submission;
			$color = "";
			if($i % 2 == 0)
				$color = 'background : #E3E3E3';
			$returnData .= '<tr style="'.$color.'">
							<td style="text-align:center">'.$row->landing_name.'</td>
							<td style="text-align:center">'.$row->visit.'</td>
							<td style="text-align:center">'.$row->submission.'</td>	
					</tr>';
			
		}
		
		$returnData .= '<tfoot>
							<tr style="background : #E3E3E3">
								<td style="text-align:center">Total</td>
								<td style="text-align:center">'.$visitCounts.'</td>
								<td style="text-align:center">'.$submissiontCount.'</td>
							</tr>
						</tfoot>
						</table></div>';
		$mailer = JFactory::getMailer();
		
			
		// Build email message format.
		$mailer->setSender(array(JFactory::getApplication()->getCfg('mailfrom'), JFactory::getApplication()->getCfg('fromname')));
		$mailer->setSubject(' Marketing Rocket Report : From '.$date);
		$mailer->setBody($returnData);
		$mailer->IsHTML(true);
		
		$mailer->addRecipient(JComponentHelper::getParams('com_marketingrocket')->get('stats_email'));
		$mailer->SetFrom(JFactory::getApplication()->getCfg('mailfrom'));
		$rs	= $mailer->Send();
		if($rs == 1){
			$params = JComponentHelper::getParams('com_marketingrocket');
			$params->set('last_sent', date('Y-m-d'));
			
			$query = $db->getQuery(true);
				
			// Build the query
			$query->update('#__extensions AS a');
			$query->set('a.params = ' . $db->quote((string)$params));
			$query->where('a.element = "com_marketingrocket"');
				
			// Execute the query
			$db->setQuery($query);
			$db->execute();
		}
		
		
		
	}
        
        public function preparSubject($subject, $row, $form_data){
            $subject = str_replace('{%email.campaign_name%}', $row->campaign_name, $subject);

            $pattern = '/({%email\.lead\.{1})(.[^}%]+)(%}{1})/';

            preg_match_all($pattern, $subject, $subjectMatches);

            foreach ($subjectMatches[0] as $key => $match){
                    $rowKey = $subjectMatches[2][$key];
                    if(empty($row->$rowKey))
                            $val = $form_data[$rowKey];
                    else 
                            $val = $row->$rowKey;
                    $subject = str_replace($match, $val, $subject);
            }
            return $subject;
        }
        
        public function prepareBody($row, $form_data, $url, $rowRef){
            $body = '';
            if(!empty($row->second_subject)){
                 $body .= '<div style="display:none !important;">'.$row->second_subject.'</div>';

            }
            $body .= $row->body;



            $body = str_replace('{%email.campaign_name%}', $row->campaign_name, $body);

            if(php_sapi_name() != 'cli' || version_compare(JVERSION, '3.7.0') !== 0)
                $body = str_replace('{%email.MR_lead_register_date%}', JHtml::_('date', $row->register_date, JText::_('DATE_FORMAT_LC2')), $body);

            $pattern = '/({%email\.lead\.{1})(.[^}%]+)(%}{1})/';
            preg_match_all($pattern, $body, $matches);

            foreach ($matches[0] as $key => $match){
                    $rowKey = $matches[2][$key];
                    if(empty($row->$rowKey))
                            $val = $form_data[$rowKey];
                    else
                            $val = $row->$rowKey;

                    $body = str_replace($match, $val, $body);
            }


            $pattern = '/({landing-link={1})(.[^}]+)(}{1})(.[^{]+)({\/landing\-link}{1})/';
            preg_match_all($pattern, $body, $matches);
            foreach ($matches[0] as  $key => $match){
                $alias = $matches[2][$key];
                $href = 'index.php?option=com_marketingrocket&view=landing&alias='.$alias.'&ref='.$row->ref_code;
                $href = $url.JRoute::_($href, false);

                $http = 'http://';
                if(strpos('https://', $url) !== false)
                        $http = 'https://';

                $href = str_replace('https://', '', $href);
                $href = str_replace('http://', '', $href);
                $href = str_replace('//', '/', $href);
                $href = $http.$href;

                $count = 1;
                $body = str_replace('{landing-link='.$alias.'}', '<a href="'.$href.'">', $body, $count);
                $count = 1;
                $body = str_replace('{/landing-link}', '</a>', $body, $count);
            }

             // ADDING Unsubscribe links

            $baseUrl = substr(JUri::base(), 0, strlen(JUri::base())-1);

            $body = preg_replace("#(<\s*a\s+[^>]*href\s*=\s*[\"'])(?!http)(?!mailto:)(?!\/)([^\"'>]+)([\"'>]+)#", '$1'.$baseUrl.'/$2$3', $body);
            $body = preg_replace("#(<\s*a\s+[^>]*href\s*=\s*[\"'])(?!http)(?!mailto:)([^\"'>]+)([\"'>]+)#", '$1'.$baseUrl.'$2$3', $body);

            $rowUrl = $url.'index.php?option=com_marketingrocket&view=unsubscribe&ref='.$rowRef.'&Itemid='.JComponentHelper::getParams('com_marketingrocket')->get('email_unsubscribe_menu_item');

            $unsubscribLink = JText::_('COM_MARKETINGROCKET_UNSUBSCRIBED_LINK');
            $unsubscribLink = sprintf($unsubscribLink, $row->email,$row->email);
            $unsubscribLink = preg_replace('/<a>/', '<a href="'.$rowUrl.'">', $unsubscribLink, 1);

            $rowUrl = $url.'index.php?option=com_marketingrocket&view=unsubscribe&ref='.$rowRef.'&all=true&Itemid='.JComponentHelper::getParams('com_marketingrocket')->get('email_unsubscribe_menu_item');
            $rowUrl = str_replace('//', '/', $rowUrl);
            $b = base64_encode($rowUrl);
            $unsubscribLink = preg_replace('/<a>/', '<a href="'.$rowUrl.'">', $unsubscribLink, 1);


            $optinLink = $url.'index.php?option=com_marketingrocket&task=landing.confirm&ref='.$rowRef;

            $body = str_replace('{opt-in-link}', '<a href="'.$optinLink.'">', $body);
            $body = str_replace('{/opt-in-link}', '</a>', $body);


            $body .= "<hr/><small>".$unsubscribLink.'</small>';

            // replacing relative path for images
            $pattern = '/(src="\/)|(src="[^http])/';
            preg_match_all($pattern, $body, $matches);
            foreach ($matches[0] as $match){

                $char = substr($match, -1);
                if($char == '/')
                    $char = '';
                $body = str_replace($match, 'src="'.$url.$char, $body);
            }

            $pattern = '/url\(("|\'|&quot;)[^http]/';
            preg_match_all($pattern, $body, $matches);


            foreach ($matches[0] as $key => $match){

                $char = substr($match, -1);
                if($char == '/')
                    $char = '';
                $body = str_replace($match, 'url('.$matches[1][$key].$url.$char, $body);
            }



            if(strpos($body, '{VIEW_IN_BROWSERLINK}') !== false){
                $tranlsted = JText::_('COM_MARKETINGROCKET_VIEW_IN_BROWSER');

                $rowUrl = $url.JRoute::_('index.php?option=com_marketingrocket&task=email.preview&ref='.$rowRef, false);

                $tranlsted = str_replace('<a>', '<a href="'.$rowUrl.'">', $tranlsted);
                $body = str_replace('{VIEW_IN_BROWSERLINK}', $tranlsted, $body);
            }
            if(php_sapi_name() != 'cli' || version_compare(JVERSION, '3.7.0') !== 0){
                JLoader::import('joomla.plugin.helper');
                JPluginHelper::importPlugin('marketingrocket');
                $dispatcher = JEventDispatcher::getInstance();

                $dispatcher->trigger('afterPrepareBodyEmail', array(&$body, $row, $form_data, $url, $rowRef));
            }

            return $body;
        }
        public function sendInovice($lead, $landing, $order, $type){
            
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            $q->select('*')->from($db->qn('#__mrocket_responder_templates'))->where($db->qn('type').' = '.$db->q('invoice'));
            $db->setQuery($q);
            $responder = $db->loadObject(); 
            
            $q->clear();
            $q->select($db->qn('title'))
                    ->from($db->qn('#__mrocket_api_types'))
                    ->where($db->qn('type').' = '.$db->q($type))
                    ;
            $db->setQuery($q);
            $typeTitle = $db->loadResult();
            
            $responder->subject = str_replace('{%invoice.number%}', $order->id, $responder->subject);
            
            $responder->body = str_replace('{%invoice.number%}', $order->id, $responder->body);
            $responder->body = str_replace('{%invoice.date%}', JHtml::_('date', $order->date, JText::_('DATE_FORMAT_LC2')), $responder->body);
            $responder->body = str_replace('{%invoice.method%}', $typeTitle, $responder->body);
            $responder->body = str_replace('{%invoice.price%}', $order->price, $responder->body);
            $responder->body = str_replace('{%invoice.currency%}', $landing->paypal_currency, $responder->body);
            $responder->body = str_replace('{%invoice.product_name%}', $landing->paypal_product_name, $responder->body);
            
            $leadsCron = $this->getTable('Leadcrons', 'MarketingrocketTable');
            
            $saveData = array(
                'lead_id' => $lead->id,
                'cron_date' => JFactory::getDate()->toSql(),
                'cron_job' => 'invoice',
                'responder_id' => $responder->id,
            );
            
            
            
            $leadsCron->bind($saveData);
            $leadsCron->store();
            
            foreach ($saveData as $key => $row)
                $responder->$key = $row;
            
            $registry = new Registry;
            $registry->loadObject($responder);
            
            $leadRegistery = new Registry;
            
            $leadRegistery->loadObject($lead);
            $leadRegistery->merge($registry);
            
            $object = $leadRegistery->toObject();
            $object->cron_id = $leadsCron->id;
            $this->sendCronsEmail(array($object));
            
        }

}
