<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
use Joomla\Registry\Registry;
class MarketingrocketModelApi extends JModelAdmin
{

    public function getTable($name = 'Api', $prefix = 'MarketingrocketTable', $options = array()) {
        return parent::getTable($name, $prefix, $options);
    }
    
    public static function getType($apiId){
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('b.type')->from('#__mrocket_api AS a')->innerJoin('#__mrocket_api_types AS b ON a.type = b.type')
            ->where('a.id = '.$db->q($apiId));

        $db->setQuery($query);
        $type = $db->loadResult();
        return $type;
    }
    
    public static function getApi($apiId){
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('a.*')->from('#__mrocket_api AS a')->innerJoin('#__mrocket_api_types AS b ON a.type = b.type')
            ->where('a.id = '.$db->q($apiId));

        $db->setQuery($query);
        $type = $db->loadObject();
        return $type;
    }
    
    public function getItem($pk = null)
    {
        
        $row = self::getApi($pk);
        $row = $this->loadData($row);

        return $row;
    }
    /**
     * get by api 
     * @param type $key
     */
    public static function getApiByKey($key, $type){
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('a.*')->from('#__mrocket_api AS a')->innerJoin('#__mrocket_api_types AS b ON a.type = b.type')
            ->where('a.api = '.$db->q($key))
            ->where('a.type = '.$db->q($type))
                ;

        $db->setQuery($query);
        $row = $db->loadObject();
        
        $row = self::loadData($row);
        return $row;
    }
    
    private static function loadData($row){
        if(empty($row))
            return $row;
        $registry = new Registry;
        $registry->loadString($row->params);
        $row->params = $registry->toArray();
        
        if(!empty($row->params)){
           foreach ($row->params as $key => $val){
               if(self::isJson($val))
                   $row->$key = json_decode($val);
                else    
                    $row->$key = $val;
            } 
        }

        return $row;
    }

    public static function getAllInstanceOfApiType($type){
        $db = JFactory::getDbo();
        $q = $db->getQuery(true);

        $q->select('a.*')->from('#__mrocket_api AS a')->innerJoin('#__mrocket_api_types AS b ON a.type = b.type')
            ->where('a.type = '.$db->q($type));
        $db->setQuery($q);
        $rows = $db->loadObjectList();

        if(empty($rows))
            return array();

        foreach ($rows as $k => $row){
            $registry = new Registry;
            $registry->loadString($row->params);
            $row->params = $registry->toArray();

            if(!empty($row->params)){
                foreach ($row->params as $key => $val){
                    if(self::isJson($val))
                        $row->$key = json_decode($val);
                    else
                        $row->$key = $val;
                }
            }
            $rows[$k] = $row;
        }


        return $rows;
    }
    
    public function getForm($data = array(), $loadData = true) {
        
    }
    
    public static function getApiByType($type){
        $db = JFactory::getDbo();
        $q = $db->getQuery(true);
        
        $q->select('a.*')->from('#__mrocket_api AS a')->innerJoin('#__mrocket_api_types AS b ON a.type = b.type')
            ->where('a.type = '.$db->q($type));
        $db->setQuery($q);
        $row = $db->loadObject();
        
        if(empty($row))
            return false;
        
        $registry = new Registry;
        $registry->loadString($row->params);
        $row->params = $registry->toArray();
        
        if(!empty($row->params)){
           foreach ($row->params as $key => $val){
               if(self::isJson($val))
                   $row->$key = json_decode($val);
                else    
                    $row->$key = $val;
            } 
        }
        return $row;
        
    }
    
    public static function isJson($string) {
        @json_decode($string);
        return (json_last_error() == JSON_ERROR_NONE);
    }

}
