<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

class MRRoute {
    
    private static $_router = null;
    
    public static function createFrontRoute($url){
        
        
        $url = JUri::root().$url;



        
        if(JComponentHelper::getParams('com_marketingrocket')->get('site_address', '') == ''){
            return self::removeSlash($url);
        }

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_HEADER, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($ch, CURLOPT_URL, $url);
        $out = curl_exec($ch);

        // line endings is the wonkiest piece of this whole thing
        $out = str_replace("\r", "", $out);

        // only look at the headers
        $headers_end = strpos($out, "\n\n");
        if( $headers_end !== false ) { 
            $out = substr($out, 0, $headers_end);
        }   

        $headers = explode("\n", $out);
        foreach($headers as $header) {
            if( substr($header, 0, 10) == "Location: " ) { 
                $target = substr($header, 10);

                return self::removeSlash($target);
            }   
        }   
        
        return self::removeSlash($url);

    }

    public static function removeSlash($url){
        return preg_replace("#([^http:])\/\/+#", '$1/', $url);
    }
}