<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketFrontHelper
{
    
    public static $utmArray = array('utm_campaign', 'utm_source', 'utm_medium', 'utm_term');
        public static function exportHtml($tempTable, $api, $landingModel = false){
            if(empty($landingModel))
                $landingModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel');
            
            $form = $landingModel->getForm(array(), false);
//            $url = JURI::root();
            
            require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';
            $url = MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=api.webhook&plugin=landing&landing=landingId&key=MR_LANDING_KEY');
            
            $url = str_replace('landingId', "'+landingId+'", $url);
            $url = str_replace('MR_LANDING_KEY', "'+MR_LANDING_KEY", $url);

            require_once JPATH_COMPONENT_SITE.DS.'views'.DS.'landing'.DS.'view.html.php';
            $view = new MarketingrocketViewLanding(array('template_path' => JPATH_COMPONENT_SITE.DS.'views'.DS.'landing'.DS.'tmpl'));

            $view->setModel($landingModel, true);

            $view->document = JFactory::getDocument();
            $view->document->addScriptDeclaration('var MR_LANDING_KEY = "'.JText::_($api , true).'"; var landingId = '.$tempTable->landing_id.';var s = document.createElement(\'script\');'
                    . 's.setAttribute(\'src\', \''.$url.');'
                    . 'document.head.appendChild(s);');

            $pageOptions = json_decode($tempTable->page_option, true);
            if(is_array($pageOptions)){
                foreach ($pageOptions as $key => $option){
                    $tempTable->$key = $option;
                }
            }
            $url = JURI::root();
            $view->item = $tempTable;
            $view->form = $form;

            $view->handleItemJobs();

            $template = $view->loadTemplate();
            
            $obj = new stdClass();
            $obj->text = $template;
            $obj->landing = $tempTable;

            $null = '';

            JPluginHelper::importPlugin('content');
            $dispatcher = JEventDispatcher::getInstance();
            $dispatcher->trigger('onContentPrepare', array ('com_marketingrocket.landing', &$obj, &$null, &$null));
            
            $template = $obj->text;

            $jVersion = (new JVersion())->getShortVersion();

            if ($jVersion < '3.8.0') {
                require_once JPATH_LIBRARIES.DS.'joomla'.DS.'document'.DS.'html'.DS.'renderer'.DS.'head.php';
            }
            $headObj = new JDocumentRendererHead($view->document);

            JLoader::import('joomla.plugin.helper');
            JPluginHelper::importPlugin('system');
            $dispatcher = JDispatcher::getInstance();
            $dispatcher->trigger('onBeforeCompileHead');

            $dispatcher->trigger('onBeforeRender');

            $head = $headObj->render(null);

            $dispatcher->trigger('onAfterRender');


            $pattern = '/(href="\/)|(href="[^http])|(src="\/)|(src="[^http])/';
            preg_match_all($pattern, $head, $matches);
            foreach ($matches[0] as $match){

                $char = substr($match, -1);
                if($char == '/')
                    $char = '';

                $src = 'src';
                if(substr($match, 0, 4) == 'href')
                    $src = 'href';

                $head = str_replace($match, $src.'="'.$url.$char, $head);
            }
            $html = '<!DOCTYPE html>
    <html>
    <head>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        '.$head.'
    </head>
    <body id="'.JFactory::getApplication()->input->getString('COM_MARKETINGROCKET_BODY_ID', '') .'">';



            $html .= $template;

            $html .= '</body>
    </html>';
            
            return $html;
        }

}

