<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketControllerUnsubscribe extends JControllerForm
{
    public function save($key = null, $urlVar = null){
        // Check for request forgeries.
        JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
        
        $refCode = $this->input->getString('ref');
        $data  = $this->input->post->get('jform', array(), 'array');
        
        
        $model = $this->getModel();
        if($data['from'] == 'current'){
            $model->unsubscribe($refCode);
            $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=unsubsribe&done=true', false));
        }
        else if($data['from'] == 'all'){
            $model->unsubscribAll($refCode);
            $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=unsubsribe&done=true&all=true', false));
        }
        else {
            $leadDetail = $model->getLead($refCode);   
            $model->unsubscribAll($refCode);   
            
            $lead = JTable::getInstance('Lead', 'MarketingrocketTable');
            $lead->load($leadDetail->lead_id);
            
            $lead->recieve_email = 0;
            $lead->store();
            $this->setRedirect(JRoute::_('index.php?option=com_marketingrocket&view=unsubscribe&done=true&never=true', false));
        }
        
        return true;
    }
    
    public function getModel($name = 'Unsubscribe', $prefix = 'MarketingrocketModel', $config = array())
    {
        return parent::getModel($name, $prefix, $config);
    }
    

}
