<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined ( '_JEXEC' ) or die ();

class MarketingrocketControllerRedirect extends JControllerForm {
	/**
	 * The URL view item variable.
	 *
	 * @var string
	 * @since 1.6
	 */
	protected $view_item = 'form';
	
	/**
	 * The URL view list variable.
	 *
	 * @var string
	 * @since 1.6
	 */
	protected $view_list = 'categories';
	public function getModel($name = 'Landing', $prefix = 'Marketingrocket', $config = array('ignore_request' => true)) {
		
		$model = parent::getModel ( $name, $prefix, $config );
		
		return $model;
	}
	
	public function go(){
	    
	    $ref = JFactory::getApplication()->input->getString('ref');
            
            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
            $leadCrons = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
            $leadCrons->load(array('ref' => $ref));
            
            if(!empty($leadCrons->id)){
                $leadCrons->is_show = 1;
                $leadCrons->is_clicked = 1;
                $leadCrons->store();
            }
	     
	    $app = JFactory::getApplication();
	    $app->redirect( base64_decode(JFactory::getApplication()->input->getString('url')));
	    die();
	}
	public function counter(){
	    $ref = JFactory::getApplication()->input->getString('ref');
            
            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
            $leadCrons = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
            $leadCrons->load(array('ref' => $ref));
            
            if(!empty($leadCrons->id)){
                $leadCrons->is_show = 1;
                $leadCrons->store();
            }
	    
	    header('Content-Type: image/png');
	    echo base64_decode('iVBORw0KGgoAAAANSUhEUgAAAAEAAAABAQMAAAAl21bKAAAAA1BMVEUAAACnej3aAAAAAXRSTlMAQObYZgAAAApJREFUCNdjYAAAAAIAAeIhvDMAAAAASUVORK5CYII=');
	    die;
	}
        
        public function cta() {
            $ref = JFactory::getApplication()->input->getString('ref', 0);
            $model = JModelLegacy::getInstance('Landing', 'MarketingrocketModel', array('ignore_request' => true));
            $ref = $model->checkRef($ref);
            $session =  @JSession::getInstance('', '');
            if($ref){
                $landing = $model->getItem($session->get('landing_id', '', 'com_marketingrocket'), 'id');
                $model->setState('landing.id', $landing->id);
               
                $leadModel = JModelLegacy::getInstance('Lead', 'MarketingrocketModel', array('ignore_request' => true));
                $lead = $leadModel->getLeadByRefCode($ref);
                $model->_addRefCode($lead->id);
                
                $leadRow = $leadModel->getTable();
                $leadRow->load($lead->id);
                $model->handleExistingLeadJobs($leadRow, $landing);
                $model->handleAfterRegisterLeadJobs($leadRow, $landing);
                
                require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'marketingrocket.php';
                        
                $text = JText::sprintf('COM_MARKETINGROCKET_LOG_CTA_SUBMIT', $landing->title);

                MarketingrocketHelper::log('cta', 'submit', $text, $leadRow->id, $landing->id, '#__mrocket_landings');
            }
           
             $href = $session->get('cta_link', '', 'com_marketingrocket');
             $app = JFactory::getApplication();
             $app->redirect($href);
                
             die;
            
        }
}
