<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined ( '_JEXEC' ) or die ();

class MarketingrocketControllerPayment extends JControllerForm {

    public function success(){
        $refCode =  $this->input->get('ref', null);

        ini_set('max_execution_time', 0);
        
        if(empty($refCode))
            die;
        
        $paymentModel = $this->getModel('Payment', 'MarketingrocketModel');
        $data = $paymentModel->getItemByRef($refCode, false);

        if($data->status == "0"){
            $retry = 0;
            for($i = 0; $i < 3;$i++){
                sleep(15);
                $data = $paymentModel->getItemByRef($refCode, false);
                if($data->status != '0')
                    break;

            }
        }

        if($data->status != '1'){
            $this->cancel();
        }
        
        $landingModel = $this->getModel('Landing', 'MarketingrocketModel');
        $item = $landingModel->getItemByRefCode($refCode);
        
        
        $cronModel = $this->getModel('Cron', 'MarketingrocketModel');
        
        $nextUrl =$landingModel->returnNextStepUrl($item,$refCode);
        $cronModel->sendNotificationEmail($refCode);
        
        $app = JFactory::getApplication();
        $app->redirect($nextUrl[1]);
    }
    
    public function cancel($key = NULL){
        $item = $this->_checkRefCode();
        $landingModel = $this->getModel('Landing', 'MarketingrocketModel');
        
        $refCode =  $this->input->get('ref', null);
        
        /**
         * based on some changes after pay is after cancel
         */
        $nextUrl =$landingModel->returnNextStepUrl($item,$refCode, 'after_pay');

        $app = JFactory::getApplication();
        $app->redirect($nextUrl[1], $nextUrl[0]);
    }
    
    public function ipn(){


        $item = $this->_checkRefCode();
        
        $refCode =  $this->input->get('ref', null);


        JPluginHelper::importPlugin('marketingrocket');
        $dispatcher = JEventDispatcher::getInstance();
        $paymentApiId = (int)$item->paypal_account;
        require_once JPATH_COMPONENT.DS.'models'.DS.'api.php';
        $type = MarketingrocketModelApi::getType($paymentApiId);
        $paymentModel = $this->getModel('Payment', 'MarketingrocketModel');
        $order = $paymentModel->getItemByRef($refCode);

        $this->templates = array();
        $isValid = false;
        
        $data = array();
        $dispatcher->trigger('onIpnCall', array($item, $order, $type, &$isValid, &$email, &$data) );
        if($isValid === true){
            require_once JPATH_COMPONENT.DS.'tables'.DS.'payment.php';
            
            $paymentModel = $this->getModel('Payment', 'MarketingrocketModel');
            $order = $paymentModel->payOrder($order->id, $email, $data);


            $db = JFactory::getDbo();
            $query = $db->getQuery(true);
            $query->select('a.*')->from( $db->quoteName ( '#__mrocket_leads' ) .' AS a');
            $query->innerJoin($db->quoteName ( '#__mrocket_refcodes' ) .' AS b ON a.id = b.lead_id');
            $query->where('b.ref_code = '.$db->q($refCode));
            $db->setQuery($query);
            $res = $db->loadObject();

            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
            $lead = JTable::getInstance("Lead", "MarketingrocketTable");

            $lead->load($res->id);


            $landingModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel', array('ignore_request' => true));

            $exist = true;
            if($lead->is_temp)
                $exist = false;

            $landingModel->handleAllAfterRegisterJobs($lead, $item, $exist);


            $landingModel->unMarkAsTemporary($refCode);
            $dispatcher->trigger('onAfterUnMarkAsTempFront', array($item, $refCode, $order) );
            

            
            require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'marketingrocket.php';
                        
            $text = JText::sprintf('COM_MARKETINGROCKET_LOG_PAYMENT_SUCCESS', $item->title);

            MarketingrocketHelper::log('landing', 'purchase', $text, $lead->id, $item->id, '#__mrocket_landings');
            
            if(JComponentHelper::getParams('com_marketingrocket')->get('send_inovice', 0) == 1){
                $cronModel = $this->getModel('Cron', 'MarketingrocketModel');

                $cronModel->sendInovice($lead, $item, $order, $type);
            }
            
            $dispatcher->trigger('onPaymentComplete', array($item, $order,$type) );
            
        }
        else {
            $landingModel = $this->getModel('Landing', 'MarketingrocketModel');
        
            /**
            * based on some changes after pay is after cancel
            */
            $nextUrl =$landingModel->returnNextStepUrl($item,$refCode, 'after_pay');
            
            echo '<script>location.href="'.JRoute::_($nextUrl[1]).'"</script>';
        }


        die('done');
    }
    
    /**
     * 
     * @return Object Landing
     */
    private function _checkRefCode(){
        $refCode =  $this->input->get('ref', null);
        if(empty($refCode))
            die;
        
        
        $landingModel = $this->getModel('Landing', 'MarketingrocketModel');
        $item = $landingModel->getItemByRefCode($refCode);
        
        if(empty($item))
            die('Not Found');
        
        $paymentModel = $this->getModel('Payment', 'MarketingrocketModel');
        $paymentModel->getItemByRef($refCode);
        
        return $item;
        
    }
}
