<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined ( '_JEXEC' ) or die ();

class MarketingrocketControllerLanding extends JControllerForm {
    
    public function __construct($config = array()) {
        parent::__construct($config);
        $this->registerTask('savelead', 'savelead');
    }

    public function savelead(){
        JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
        $app   = JFactory::getApplication();
        $model = $this->getModel();                
        $data  = $this->input->post->get('jform', array(), 'array');
        
        $model->setState('landing.foundby', 'id');
        $model->setState('landing.id', $data['landing_id']);
        
        $landingId = $data['landing_id'];        
        $context = 'com_marketingrocket.edit.landingForm.'.$landingId;        
        $form = $model->getForm($data, false);

        if (!$form)
        {
                $app->enqueueMessage($model->getError(), 'error');

                return false;
        }
        // Test whether the data is valid.
        $validData = $model->validate($form, $data);

        // Check for validation errors.
        if ($validData === false)
        {
                // Get the validation messages.
                $errors = $model->getErrors();

                // Push up to three validation messages out to the user.
                for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++)
                {
                        if ($errors[$i] instanceof Exception)
                        {
                                $app->enqueueMessage($errors[$i]->getMessage(), 'warning');
                        }
                        else
                        {
                                $app->enqueueMessage($errors[$i], 'warning');
                        }
                }

                // Save the data in the session.
                $app->setUserState($context . '.data', $data);
                // Redirect back to the edit screen.
                $this->setRedirect(
                        JRoute::_(
                                'index.php?option=com_marketingrocket&view=landing&id='.$landingId.'&load=id', false
                        )
                );

                return false;
        }
        $item = $model->getItem();
        if($item->have_paypal == '1'){
                $leadDetail = $model->saveLead($validData, 1);                
                if(empty($leadDetail['ref'])){
                    throw new Exception('You\'re Already Purchased This Item', 500);
                }               
                
                JModelLegacy::addIncludePath(JPATH_COMPONENT.DS.'models');                
                require JPATH_COMPONENT.DS.'tables'.DS.'payment.php';
                
                $paymentModel = JModelLegacy::getInstance('Payment', 'MarketingrocketModel', array('ignore_request' => true));                
                JLoader::import('joomla.plugin.helper');
                JPluginHelper::importPlugin('marketingrocket');
                $dispatcher = JEventDispatcher::getInstance();
                $paymentApiId = (int)$item->paypal_account;
                $type = MarketingrocketModelApi::getType($paymentApiId);
                
                $saveFormData = array();
                
                $dispatcher->trigger('onBeforeCreateOrder', array(&$saveFormData,  $validData, &$item, $type) );
                
                $paymentModel->createOrder($landingId, $leadDetail['id'], $item->price , $leadDetail['ref'], $saveFormData);

                $app->redirect('index.php?option=com_marketingrocket&view=payment&ref='.$leadDetail['ref'].'&'.JSession::getFormToken() .'=1');

        }
        else {

                $leadDetail = $model->saveLead($validData);
        }
        $cronModel = JModelLegacy::getInstance('Cron', 'MarketingrocketModel', array('ignore_request' => true));
        $cronModel->sendNotificationEmail($leadDetail['ref']);

        $options = json_decode($item->page_option);

        if(!empty($options->is_double_optin) && $leadDetail['exist'] == false){


            $ip = $this->input->server->get('REMOTE_ADDR');

            $campaignTable = JTable::getInstance('Campaign', 'MarketingrocketTable');

            $campaignTable->load($item->campaign_id);

            $text  = JText::plural('COM_MARKETINGROCKET_USER_REGISTERED_OPT_IN', $campaignTable->name, $ip);


            require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'marketingrocket.php';
            MarketingrocketHelper::log('opt-in', 'registered', $text, $leadDetail['id'], $item->id, '#__mrocket_landings');


            $responderId = $options->optin_responder;
            if($responderId == 'def'){
                JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
                $responderTable = JTable::getInstance('Responder','MarketingrocketTable');
                $responderTable->load(array('type' => 'opt_in'));
                $responderId = $responderTable->id;

            }

            $date = JFactory::getDate();
            $leadCron  = JTable::getInstance('Leadcrons', 'MarketingrocketTable');

            $leadCron->lead_id = $leadDetail['id'];
            if(is_object($date))
                $leadCron->cron_date = $date->format("Y-m-d H:i:s", true);

            $leadCron->cron_job = 'default';
            $leadCron->responder_id = $responderId;

            $leadCron->store();

            $cronModel = JModelLegacy::getInstance('Cron', 'MarketingrocketModel');
            $cronModel->sendZeroDays($leadDetail['id'], array($responderId));
            $nextUrl = $model->returnNextStepUrl($item,$leadDetail['ref'], 'after_pay', false); // to opt in page

        }
        else
            $nextUrl = $model->returnNextStepUrl($item,$leadDetail['ref']);

        $app->redirect($nextUrl[1]);        
        return true;        
    }
    
    public function savehtml(){
        $token = $this->input->get('token');
        $id = $this->input->getInt('id', 0);
        if($token != JComponentHelper::getParams('com_marketingrocket')->get('salt') || empty($id)){
            die('?');
        }
        
        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
        $tempTable = JTable::getInstance('Temp', 'MarketingrocketTable');
        
        $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel');
        $api = $apiModel->getItem($this->input->getInt('api', 0));
        
        $tempTable->load($id);
        if(empty($tempTable->id))
            die('Id Is Empty');
        
        require_once JPATH_COMPONENT.DS.'helpers'.DS.'marketingrocket.php';
        $html = MarketingrocketFrontHelper::exportHtml($tempTable, $api->api);
        
        $session =  @JSession::getInstance('', '');
        $session->set('MR_EXPORT_HTML', $html, 'com_marketingrocket');
        
        $tempTable->delete();
        
        JFactory::getApplication()->redirect('/administrator/index.php?option=com_marketingrocket&view=landing&layout=edit&id='.$tempTable->landing_id.'&export=1');
        
    }
    
    public function download(){
        $session =  @JSession::getInstance('', '');
        if(!$session->has('MR_EXPORT_HTML', 'com_marketingrocket'))
             die('Session Is Empty');
        
        header('Content-Disposition: attachment');
                
        $data = $session->get('MR_EXPORT_HTML', false,'com_marketingrocket');
        $session->clear('MR_EXPORT_HTML', 'com_marketingrocket');
        echo $data;
        die;
        
        
        
        
    }
    public function confirm(){
        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
        $crons = JTable::getInstance('Leadcrons','MarketingrocketTable');
        $crons->load(array('ref' => $this->input->getString('ref')));

        if(!empty($crons->lead_id)){
            $db = JFactory::getDbo();
            $q = $db->getQuery(true);
            $q->select('*')->from($db->qn('#__mrocket_refcodes'))
                ->where($db->qn('lead_id').' = '.$db->q($crons->lead_id))
                ;
            $db->setQuery($q);
            $ref = $db->loadObject();

            $lead = JTable::getInstance('Lead', 'MarketingrocketTable');
            $lead->load($ref->lead_id);

            $model = $this->getModel();
            if($lead->is_temp == 1){

                $ip = $this->input->server->get('REMOTE_ADDR');

                $text  = JText::plural('COM_MARKETINGROCKET_USER_ACCEPTED_OPT_IN', $ip);


                require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'marketingrocket.php';
                MarketingrocketHelper::log('opt-in', 'registered', $text, $lead->id);


                $model->unMarkAsTemporary($ref->ref_code);
            }


            $model->setState('landing.foundby', 'id');
            $model->setState('landing.id', $ref->landing_id);

            $item = $model->getItem();

            $nextUrl = $model->returnNextStepUrl($item,$ref->ref_code);

            JFactory::getApplication()->redirect($nextUrl[1]);
            return;

        }
        throw new Exception(404);
    }
}
